/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datavalue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BinaryOperator implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    ADD(1, "ADD", "ADD"),
    MUL(2, "MUL", "MUL"),
    SUB(3, "SUB", "SUB"),
    DIV(4, "DIV", "DIV"),
    POW(5, "POW", "POW"),
    MIN(6, "MIN", "MIN"),
    MAX(7, "MAX", "MAX"),
    EQU(8, "EQU", "EQU"),
    IOR(9, "IOR", "IOR"),
    XOR(10, "XOR", "XOR"),
    AND(11, "AND", "AND");

    public static final int UNSET_VALUE = 0;
    public static final int ADD_VALUE = 1;
    public static final int MUL_VALUE = 2;
    public static final int SUB_VALUE = 3;
    public static final int DIV_VALUE = 4;
    public static final int POW_VALUE = 5;
    public static final int MIN_VALUE = 6;
    public static final int MAX_VALUE = 7;
    public static final int EQU_VALUE = 8;
    public static final int IOR_VALUE = 9;
    public static final int XOR_VALUE = 10;
    public static final int AND_VALUE = 11;
    private static final BinaryOperator[] VALUES_ARRAY;
    public static final List<BinaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BinaryOperator[]{UNSET, ADD, MUL, SUB, DIV, POW, MIN, MAX, EQU, IOR, XOR, AND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BinaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BinaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BinaryOperator get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return ADD;
            }
            case 2: {
                return MUL;
            }
            case 3: {
                return SUB;
            }
            case 4: {
                return DIV;
            }
            case 5: {
                return POW;
            }
            case 6: {
                return MIN;
            }
            case 7: {
                return MAX;
            }
            case 8: {
                return EQU;
            }
            case 9: {
                return IOR;
            }
            case 10: {
                return XOR;
            }
            case 11: {
                return AND;
            }
        }
        return null;
    }

    private BinaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

