/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.handlers.merge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonTreeViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.diffmerge.ui.viewers.MergeChoiceData;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.ui.toolkit.viewers.menu.ModalContextMenuExtender;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.MergeEMFDiffNode;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.Messages;

public class DiffComparisonViewer
extends ComparisonViewer {
    private static final String CHECKIN_ACTION_ALL = "checkin_action_all.gif";
    private static final String CHECKOUT_ACTION_ALL = "checkout_action_all.gif";
    private static final String DIFFMERGE_VIEWER_MENU = "org.polarsys.capella.core.transition.common.ui.diffmerge";
    private static boolean mergeAllInProgress = false;
    private static boolean mergeAllSucceed = false;

    public DiffComparisonViewer(Composite parent) {
        super(parent);
        this._isExternallySynced = false;
    }

    protected IWorkbenchPartSite getSite() {
        return null;
    }

    protected ActionContributionItem createItemSyncExternal(IContributionManager context) {
        return null;
    }

    protected MenuManager createViewerContextMenus(HeaderViewer<?> viewer, boolean useLocalSelectionProvider) {
        MenuManager manager = super.createViewerContextMenus(viewer, useLocalSelectionProvider);
        Viewer selectionProvider = useLocalSelectionProvider ? viewer.getInnerViewer() : this.getMultiViewerSelectionProvider();
        ModalContextMenuExtender.registerContextMenu((MenuManager)manager, (String)DIFFMERGE_VIEWER_MENU, (ISelectionProvider)selectionProvider);
        return manager;
    }

    public DiffComparisonViewer(Composite parent, IActionBars actionBars) {
        super(parent, actionBars);
    }

    protected MenuItem createMenuSupportUndoRedo(Menu menu) {
        return null;
    }

    protected void inputChanged(final Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        if (input instanceof EMFDiffNode) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    for (IMatch o : DiffComparisonViewer.this.getExpandedElements((EMFDiffNode)input)) {
                        ((ComparisonTreeViewer)DiffComparisonViewer.this._viewerSynthesisMain.getInnerViewer()).expandToLevel((Object)o, 0);
                    }
                }
            });
        }
    }

    protected Collection<IMatch> getExpandedElements(EMFDiffNode node) {
        LinkedList matches = new LinkedList();
        ArrayList<IMatch> result = new ArrayList<IMatch>();
        EComparison comparison = (EComparison)node.getActualComparison();
        matches.addAll(comparison.getContents());
        while (!matches.isEmpty()) {
            IMatch match = (IMatch)matches.removeFirst();
            if (match == null) continue;
            if (node.getCategoryManager().representAsUserDifference(match)) {
                result.add(match);
                continue;
            }
            matches.addAll(comparison.getContentsOf(match));
        }
        return result;
    }

    protected ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.transition.common.ui", (String)("icons/ctool16/" + key));
        return desc;
    }

    protected ActionContributionItem createToolMergeAll(IContributionManager manager, boolean onLeft) {
        Action action = new Action(){

            public void run() {
                DiffComparisonViewer.this.mergeAll();
            }
        };
        String imageKey = onLeft ? CHECKIN_ACTION_ALL : CHECKOUT_ACTION_ALL;
        action.setImageDescriptor(this.getImageDescriptor(imageKey));
        action.setToolTipText(onLeft ? Messages.ComparisonViewer_MergeAllOnLeftTooltip : Messages.ComparisonViewer_MergeAllOnRightTooltip);
        action.setEnabled(false);
        ActionContributionItem result = new ActionContributionItem((IAction)action);
        manager.add((IContributionItem)result);
        this.addPropertyChangeListener(new IPropertyChangeListener((IAction)action, onLeft){
            private final /* synthetic */ IAction val$action;
            private final /* synthetic */ boolean val$onLeft;
            {
                this.val$action = iAction;
                this.val$onLeft = bl;
            }

            public void propertyChange(PropertyChangeEvent event) {
                if ("PROPERTY_CURRENT_INPUT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_LEFT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_RIGHT".equals(event.getProperty())) {
                    EMFDiffNode input = DiffComparisonViewer.this.getInput();
                    if (input instanceof MergeEMFDiffNode) {
                        MergeEMFDiffNode mergeInput = (MergeEMFDiffNode)input;
                        this.val$action.setEnabled(mergeInput.isMergeAllEnabled(this.val$onLeft));
                    }
                } else if ("DIRTY_STATE".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                    mergeAllSucceed = true;
                }
            }
        });
        return result;
    }

    protected boolean interactionsRequiredForMerge(MergeChoiceData choices, EMFDiffNode input, List<IMatch<?>> selectedMatches) {
        if (mergeAllInProgress) {
            return false;
        }
        return super.interactionsRequiredForMerge(choices, input, selectedMatches);
    }

    protected void setupToolsDetailsSide(ToolBar toolbar, boolean onLeft) {
        ToolBarManager toolbarManager = new ToolBarManager(toolbar);
        this.createToolMergeAll((IContributionManager)toolbarManager, onLeft);
        this.createItemMerge((IContributionManager)toolbarManager, !onLeft);
        this.createItemIgnore((IContributionManager)toolbarManager, onLeft);
        this.createItemDelete((IContributionManager)toolbarManager, onLeft);
        toolbarManager.update(true);
    }

    boolean mergeAll() {
        ITreeDataScope scope = this.getComparison().getScope(this.getInput().getRoleForSide(true));
        List root = scope.getRoots();
        ComparisonSelection selection = this.asComparisonSelection((IStructuredSelection)new StructuredSelection(root));
        mergeAllInProgress = true;
        mergeAllSucceed = false;
        this.merge(false, true, selection);
        mergeAllInProgress = false;
        return mergeAllSucceed;
    }
}

