/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.capellaelement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.util.ModellingcoreSwitch;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.util.InformationSwitch;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.utils.CapellaSwitch;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public abstract class Abstract_MDCHK_NamingConflictRule
extends AbstractValidationRule {
    private CapellaSwitch<Boolean> capellaSwitch;
    private InformationConflictSwitch informationSwitch;
    private ModellingcoreConflictSwitch modellingcoreSwitch;
    private static final String TYPE_SUFFIX = ") ";
    private static final String TYPE_PREFIX = " (";
    List<AbstractNamedElement> conflictCandidates = new ArrayList<AbstractNamedElement>();

    public Abstract_MDCHK_NamingConflictRule() {
        this.capellaSwitch = new CapellaSwitch();
        this.informationSwitch = new InformationConflictSwitch();
        this.modellingcoreSwitch = new ModellingcoreConflictSwitch();
        this.capellaSwitch.setInformation((InformationSwitch)this.informationSwitch);
        this.capellaSwitch.setModellingcore((ModellingcoreSwitch)this.modellingcoreSwitch);
    }

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof CapellaElement && !(eObj instanceof AbstractCapability) && !(eObj instanceof Scenario)) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            boolean hasConflict = false;
            HashMap<EClass, List<AbstractNamedElement>> typesAndNames = new HashMap<EClass, List<AbstractNamedElement>>();
            CapellaElement elt = (CapellaElement)eObj;
            for (EObject obj : elt.eContents()) {
                if (eObj instanceof Parameter && obj instanceof LiteralNumericValue || !(obj instanceof AbstractNamedElement) || !this.isImpactedByCurrentRule(obj)) continue;
                AbstractNamedElement namedElement = (AbstractNamedElement)obj;
                String currentElementName = namedElement.getName();
                if (namedElement instanceof DataValue || currentElementName == null || currentElementName.equalsIgnoreCase("") || currentElementName.equalsIgnoreCase("null") || !this.checkTheNamingConflict(ctx, statuses, typesAndNames, elt, namedElement, currentElementName)) continue;
                hasConflict = true;
            }
            typesAndNames.clear();
            if (hasConflict && !statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean checkTheNamingConflict(IValidationContext ctx, Collection<IStatus> statuses, Map<EClass, List<AbstractNamedElement>> typesAndNames, CapellaElement elt, AbstractNamedElement currentElement, String currentElementName) {
        boolean hasConflict = false;
        if (!typesAndNames.containsKey(currentElement.eClass())) {
            ArrayList<AbstractNamedElement> elements = new ArrayList<AbstractNamedElement>();
            elements.add(currentElement);
            typesAndNames.put(currentElement.eClass(), elements);
        } else {
            this.conflictCandidates = typesAndNames.get(currentElement.eClass());
            HashSet<AbstractNamedElement> conflictingElements = new HashSet<AbstractNamedElement>();
            for (AbstractNamedElement abstractNamedElement : this.conflictCandidates) {
                if (currentElement instanceof ComponentExchange) {
                    this.hasConflictComponentExchange(conflictingElements, abstractNamedElement, (ComponentExchange)currentElement);
                    continue;
                }
                if (currentElement instanceof FunctionalExchange) {
                    this.hasConflictFunctionalExchange(conflictingElements, abstractNamedElement, (FunctionalExchange)currentElement);
                    continue;
                }
                if (currentElement instanceof PhysicalLink) {
                    this.hasConflictPhysicalLink(conflictingElements, abstractNamedElement, (PhysicalLink)currentElement);
                    continue;
                }
                if (!this.hasConflict(currentElement, this.conflictCandidates)) continue;
                conflictingElements.add(currentElement);
            }
            if (!conflictingElements.isEmpty()) {
                hasConflict = true;
                for (Object object : conflictingElements) {
                    AbstractNamedElement abstractNamedElement = (AbstractNamedElement)object;
                    String currentConflict = TYPE_PREFIX + abstractNamedElement.eClass().getName() + TYPE_SUFFIX + currentElementName;
                    IStatus failureStatus = this.createFailureStatus(ctx, new Object[]{elt.getLabel(), TYPE_PREFIX + elt.eClass().getName() + TYPE_SUFFIX, currentConflict});
                    statuses.add(failureStatus);
                }
            }
            this.conflictCandidates.add(currentElement);
        }
        return hasConflict;
    }

    protected abstract void hasConflictComponentExchange(Set<AbstractNamedElement> var1, AbstractNamedElement var2, ComponentExchange var3);

    protected abstract void hasConflictFunctionalExchange(Set<AbstractNamedElement> var1, AbstractNamedElement var2, FunctionalExchange var3);

    protected abstract void hasConflictPhysicalLink(Set<AbstractNamedElement> var1, AbstractNamedElement var2, PhysicalLink var3);

    protected boolean hasConflict(AbstractNamedElement currentElement, List<AbstractNamedElement> conflictCandidates) {
        this.modellingcoreSwitch.setConflictCandidates(conflictCandidates);
        this.informationSwitch.setConflictCandidates(conflictCandidates);
        Boolean result = (Boolean)this.capellaSwitch.doSwitch((EObject)currentElement);
        return result == null ? false : result;
    }

    protected abstract boolean isImpactedByCurrentRule(EObject var1);

    class InformationConflictSwitch
    extends InformationSwitch<Boolean> {
        private List<? extends AbstractNamedElement> conflictCandidates = Collections.emptyList();

        InformationConflictSwitch() {
        }

        public Boolean caseExchangeItem(ExchangeItem exchangeItem) {
            block0: for (AbstractNamedElement abstractNamedElement : this.conflictCandidates) {
                ExchangeItem candidateItem = (ExchangeItem)abstractNamedElement;
                if (!candidateItem.getName().equalsIgnoreCase(exchangeItem.getName()) || candidateItem.getOwnedElements().size() != exchangeItem.getOwnedElements().size()) continue;
                EList listA = exchangeItem.getOwnedElements();
                EList listZ = candidateItem.getOwnedElements();
                int i = 0;
                while (i < candidateItem.getOwnedElements().size()) {
                    ExchangeItemElement e1 = (ExchangeItemElement)listA.get(i);
                    ExchangeItemElement e2 = (ExchangeItemElement)listZ.get(i);
                    if (e1.getType() != e2.getType()) continue block0;
                    ++i;
                }
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public void setConflictCandidates(List<? extends AbstractNamedElement> conflictCandidates) {
            this.conflictCandidates = conflictCandidates;
        }
    }

    class ModellingcoreConflictSwitch
    extends ModellingcoreSwitch<Boolean> {
        private List<? extends AbstractNamedElement> conflictCandidates = Collections.emptyList();

        ModellingcoreConflictSwitch() {
        }

        public Boolean caseAbstractNamedElement(AbstractNamedElement element) {
            for (AbstractNamedElement abstractNamedElement : this.conflictCandidates) {
                if (abstractNamedElement.getName() == null || element.getName() == null || !abstractNamedElement.getName().equalsIgnoreCase(element.getName())) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public void setConflictCandidates(List<? extends AbstractNamedElement> conflictCandidates) {
            this.conflictCandidates = conflictCandidates;
        }
    }
}

