/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelChooserDialog
extends Dialog {
    private TreeViewer workspaceViewer;
    protected String modelExtension;
    protected IFile selectedModel;

    public ModelChooserDialog(String modelExtension) {
        super(Display.getDefault().getActiveShell());
        this.modelExtension = modelExtension;
        this.setShellStyle(67696);
    }

    public Shell getShell() {
        Shell s = super.getShell();
        s.setText(EEFRuntimeUIMessages.ModelChooserDialog_title);
        return s;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData containerData = new GridData(1808);
        container.setLayoutData((Object)containerData);
        GridLayout containerLayout = new GridLayout();
        container.setLayout((Layout)containerLayout);
        Label label = new Label(container, 0);
        label.setText(EEFRuntimeUIMessages.ModelChooserDialog_choose_model);
        this.workspaceViewer = new TreeViewer(container);
        this.workspaceViewer.getTree().setLayoutData((Object)new GridData(1808));
        if (EEFUtils.isBundleLoaded("org.eclipse.ui.ide")) {
            this.workspaceViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        } else {
            this.workspaceViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(EEFRuntimePlugin.getDefault().getAdapterFactory()));
        }
        this.workspaceViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.workspaceViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ModelChooserDialog.this.valid(viewer, parentElement, element);
            }
        });
        this.workspaceViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.workspaceViewer.addSelectionChangedListener((ISelectionChangedListener)new OkButtonEnabler());
        this.workspaceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelChooserDialog.this.okPressed();
            }
        });
        return container;
    }

    protected boolean valid(Viewer p_viewer, Object p_parentElement, Object p_element) {
        boolean retour = false;
        try {
            if (p_element instanceof IProject && ((IProject)p_element).isOpen() && !this.getFiles((IContainer)p_element).isEmpty()) {
                retour = true;
            } else if (p_element instanceof IFolder && !this.getFiles((IContainer)p_element).isEmpty()) {
                retour = true;
            } else if (p_element instanceof IFile && ((IFile)p_element).getFileExtension().equalsIgnoreCase(this.modelExtension)) {
                retour = true;
            }
        }
        catch (Exception p_exception) {
            p_exception.printStackTrace();
        }
        return retour;
    }

    private Collection<IResource> getFiles(IContainer p_container) throws CoreException {
        ArrayList<IResource> files = new ArrayList<IResource>();
        ArrayList<IContainer> folders = new ArrayList<IContainer>();
        IResource[] children = p_container.members();
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            int childType = child.getType();
            if (childType == 1 && child.getFileExtension() != null && child.getFileExtension().equalsIgnoreCase(this.modelExtension)) {
                files.add(child);
            } else if (childType == 2 && !child.getName().startsWith(".")) {
                folders.add((IContainer)child);
            }
            ++i;
        }
        Iterator iter = folders.iterator();
        while (iter.hasNext()) {
            files.addAll(this.getFiles((IContainer)iter.next()));
        }
        return files;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setOkButtonEnabled(false);
    }

    protected void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public IFile getSelectedModel() {
        return this.selectedModel;
    }

    protected class OkButtonEnabler
    implements ISelectionChangedListener {
        protected OkButtonEnabler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                IFile file;
                String fileExtension;
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof IFile && (fileExtension = (file = (IFile)selectedElement).getFileExtension().toString()).equals(ModelChooserDialog.this.modelExtension)) {
                    ModelChooserDialog.this.setOkButtonEnabled(true);
                    ModelChooserDialog.this.selectedModel = file;
                    return;
                }
            }
            ModelChooserDialog.this.selectedModel = null;
            ModelChooserDialog.this.setOkButtonEnabled(false);
        }
    }
}

