/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.image.Base64ImageHelper;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.ext.emf.edit.EditingDomainServices;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.core.data.migration.Activator;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.data.migration.contribution.Messages;

public class ImagePathInRichTextAttributeContribution
extends AbstractMigrationContribution {
    private static final String HTML_IMAGE_ABSOLUTE_PATH_PATTERN = "<img.*?src=\"((file:/|//|\\\\).*?)\".*?/>";
    private static final String IMAGE_NAME_FORMAT = "yyyyMMdd_HHmmssSSSSSS";

    @Override
    public void postMigrationExecute(ExecutionManager executionManager, ResourceSet resourceSet, MigrationContext context) {
        Resource resourceToMigrate = resourceSet.getResource(EcoreUtil2.getURI((IFile)context.getResource()), false);
        if (resourceToMigrate != null) {
            IProject project = EcoreUtil2.getFile((Resource)resourceToMigrate).getProject();
            if (project != null) {
                Set richTextAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
                TreeIterator allContents = resourceToMigrate.getAllContents();
                LinkedHashSet<String> nonFoundRelativeFiles = new LinkedHashSet<String>();
                while (allContents.hasNext()) {
                    EObject eObject = (EObject)allContents.next();
                    List featuresToMigrate = eObject.eClass().getEAllAttributes().stream().filter(feature -> richTextAttributes.contains(feature)).collect(Collectors.toList());
                    for (EStructuralFeature attr : featuresToMigrate) {
                        Object value = eObject.eGet(attr);
                        if (!(value instanceof String)) continue;
                        this.updateBase64Images(eObject, attr);
                        this.createFileAndUpdateAttributeFromAbsoluteToRelativePath(eObject, (EAttribute)attr);
                        this.updateProjectRelativePath(resourceToMigrate, eObject, (EAttribute)attr, nonFoundRelativeFiles);
                    }
                }
                if (!nonFoundRelativeFiles.isEmpty()) {
                    String notFoundFilesPath = nonFoundRelativeFiles.stream().collect(Collectors.joining(", "));
                    Activator.getDefault().getLog().warn(MessageFormat.format(Messages.MigrationAction_Image_RelativePathImageNotFound, notFoundFilesPath));
                }
            } else {
                Activator.getDefault().getLog().error(MessageFormat.format(Messages.MigrationAction_Image_ImpossibleToFindProject, resourceToMigrate.getURI().toPlatformString(true)));
            }
        }
    }

    private void updateBase64Images(EObject eObject, EStructuralFeature attr) {
        Map createdFiles = new Base64ImageHelper().createFileAndUpdateAttribute(eObject, (EAttribute)attr);
        if (!createdFiles.isEmpty()) {
            String createdFilesPath = createdFiles.keySet().stream().collect(Collectors.joining(", "));
            Activator.getDefault().getLog().info(MessageFormat.format(Messages.MigrationAction_Image_Base64ImageMigrated, new EditingDomainServices().getLabelProviderText(eObject), attr.getName(), createdFilesPath));
        }
    }

    private void updateProjectRelativePath(Resource resource, EObject eObject, EAttribute attr, Set<String> nonFoundRelativeFiles) {
        String oldValue = (String)eObject.eGet((EStructuralFeature)attr);
        String newValue = (String)eObject.eGet((EStructuralFeature)attr);
        if (newValue != null && !newValue.isEmpty()) {
            Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
            Matcher matcher = pattern.matcher(newValue);
            IProject project = EcoreUtil2.getFile((Resource)resource).getProject();
            while (matcher.find()) {
                String path;
                if (matcher.groupCount() != 1) continue;
                String newPath = path = matcher.group(1);
                if (!(path.startsWith(project.getName()) || path.startsWith("file:/") || path.startsWith("http://") || path.startsWith("https://") || path.startsWith("//") || path.startsWith("\\\\"))) {
                    newPath = String.valueOf(project.getName()) + "/" + path;
                    newValue = newValue.replace(path, newPath);
                }
                if (!newPath.startsWith(project.getName()) || project.getWorkspace().getRoot().getFile((IPath)new Path(newPath)).exists()) continue;
                nonFoundRelativeFiles.add(newPath);
            }
            if (!Objects.equals(newValue, oldValue)) {
                eObject.eSet((EStructuralFeature)attr, (Object)newValue);
            }
        }
    }

    public List<String> createFileAndUpdateAttributeFromAbsoluteToRelativePath(EObject eObject, EAttribute attr) {
        String strValue = (String)eObject.eGet((EStructuralFeature)attr);
        ArrayList<String> nonCreatedFiles = new ArrayList<String>();
        if (strValue != null) {
            Map<String, IFile> createdFiles = this.createFiles(eObject, attr, strValue, nonCreatedFiles);
            this.updateField(eObject, attr, strValue, createdFiles);
        }
        return nonCreatedFiles;
    }

    private void updateField(EObject eObject, EAttribute attr, String strValue, Map<String, IFile> createdFiles) {
        String newStringValue = strValue;
        for (String absolutePathFile : createdFiles.keySet()) {
            String replacementString = createdFiles.get(absolutePathFile).getFullPath().toString().replaceFirst("^/", "");
            String quote = "\"";
            newStringValue = newStringValue.replace(String.valueOf(quote) + absolutePathFile + quote, String.valueOf(quote) + replacementString + quote);
        }
        if (!Objects.equals(newStringValue, strValue)) {
            eObject.eSet((EStructuralFeature)attr, (Object)newStringValue);
        }
    }

    private Map<String, IFile> createFiles(EObject notifier, EAttribute attribute, String strValue, List<String> nonCreatedFiles) {
        LinkedHashMap<String, IFile> filesToCreate = new LinkedHashMap<String, IFile>();
        Pattern pattern = Pattern.compile(HTML_IMAGE_ABSOLUTE_PATH_PATTERN);
        Matcher matcher = pattern.matcher(strValue);
        IFolder imageFolder = EcoreUtil2.getProject((EObject)notifier).getFolder("images");
        while (matcher.find()) {
            if (matcher.groupCount() < 1) continue;
            Optional<File> fileWithAbsolutePath = this.getFileFromString(matcher.group(1));
            if (fileWithAbsolutePath.isPresent()) {
                IFile fileToCreate = this.getFileToCreate(imageFolder, fileWithAbsolutePath.get(), notifier);
                filesToCreate.put(matcher.group(1), fileToCreate);
                continue;
            }
            nonCreatedFiles.add(matcher.group(1));
        }
        Map<String, IFile> createdFiles = this.createFiles(imageFolder, filesToCreate, notifier, attribute);
        if (!createdFiles.isEmpty()) {
            String createdFilesPath = createdFiles.keySet().stream().collect(Collectors.joining(", "));
            Activator.getDefault().getLog().info(MessageFormat.format(Messages.MigrationAction_Image_AsolutePathImageMigrated, new EditingDomainServices().getLabelProviderText(notifier), attribute.getName(), createdFilesPath));
        }
        if (!nonCreatedFiles.isEmpty()) {
            String nonCreatedFilesPath = nonCreatedFiles.stream().collect(Collectors.joining(", "));
            String message = MessageFormat.format(Messages.MigrationAction_Image_AsolutePathImageNotMigrated, new EditingDomainServices().getLabelProviderText(notifier), attribute.getName(), nonCreatedFilesPath);
            Activator.getDefault().getLog().warn(message);
            Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
            Status status = new Status(2, "org.polarsys.capella.core.data.migration", message);
            LogExt.log((Logger)logger, (IStatus)status);
        }
        return createdFiles;
    }

    private Optional<File> getFileFromString(String fileString) {
        Optional<File> fileOpt = Optional.empty();
        File fileWithAbsolutePath = new File(fileString);
        try {
            URI uri;
            if (!fileWithAbsolutePath.exists() && !(fileWithAbsolutePath = new File(uri = new URL(fileString).toURI())).exists()) {
                String decodedURI = URIUtil.toUnencodedString((URI)uri);
                fileWithAbsolutePath = new File(decodedURI);
            }
            if (fileWithAbsolutePath.exists()) {
                fileOpt = Optional.of(fileWithAbsolutePath);
            }
        }
        catch (IllegalArgumentException | SecurityException | MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        return fileOpt;
    }

    public IFile getFileToCreate(IFolder imageFolder, File fileToCopy, EObject contextObject) {
        String wsImageName = "images" + File.separator + fileToCopy.getName();
        IFile targetImageFile = imageFolder.getProject().getFile(wsImageName);
        return targetImageFile;
    }

    private Map<String, IFile> createFiles(IFolder imageFolder, Map<String, IFile> filesToCopy, EObject contextObject, EAttribute attribute) {
        LinkedHashMap<String, IFile> createdFiles = new LinkedHashMap<String, IFile>();
        if (filesToCopy.isEmpty()) {
            return createdFiles;
        }
        ArrayList<String> nonCreatedFiles = new ArrayList<String>();
        if (!imageFolder.exists()) {
            try {
                imageFolder.create(true, true, null);
            }
            catch (CoreException e) {
                String nonCreatedFilesPath = filesToCopy.values().stream().map(iFile -> iFile.getFullPath().toString()).collect(Collectors.joining(", "));
                Activator.getDefault().getLog().error(MessageFormat.format(Messages.MigrationAction_Image_ImpossibleToCreateImageFolder, imageFolder.getFullPath(), new EditingDomainServices().getLabelProviderText(contextObject), attribute.getName(), nonCreatedFilesPath), (Throwable)e);
            }
        }
        for (String fileToCopy : filesToCopy.keySet()) {
            Optional<File> fileFromString;
            Object formatter;
            IFile targetFileToCreate = filesToCopy.get(fileToCopy);
            if (targetFileToCreate.exists()) {
                Instant now = Instant.now();
                formatter = DateTimeFormatter.ofPattern(IMAGE_NAME_FORMAT).withZone(ZoneId.systemDefault());
                String strDate = ((DateTimeFormatter)formatter).format(now);
                String newName = targetFileToCreate.getFullPath().lastSegment().replace("." + targetFileToCreate.getFileExtension(), String.valueOf(strDate) + "." + targetFileToCreate.getFileExtension());
                targetFileToCreate = targetFileToCreate.getParent().getFile((IPath)new Path(newName));
                filesToCopy.put(fileToCopy, targetFileToCreate);
            }
            if (!(fileFromString = this.getFileFromString(fileToCopy)).isPresent()) continue;
            try {
                formatter = null;
                Object var12_15 = null;
                try (FileInputStream fileInputStream = new FileInputStream(fileFromString.get());){
                    targetFileToCreate.create((InputStream)fileInputStream, false, null);
                    createdFiles.put(fileToCopy, targetFileToCreate);
                }
                catch (Throwable throwable) {
                    if (formatter == null) {
                        formatter = throwable;
                    } else if (formatter != throwable) {
                        ((Throwable)formatter).addSuppressed(throwable);
                    }
                    throw formatter;
                }
            }
            catch (IOException | CoreException e) {
                Activator.getDefault().getLog().error(MessageFormat.format(Messages.MigrationAction_Image_ImpossibleToCreateImage, fileToCopy), e);
                nonCreatedFiles.add(fileToCopy);
            }
        }
        if (nonCreatedFiles.size() > 0) {
            String nonCreatedFilesPath = nonCreatedFiles.stream().collect(Collectors.joining(", "));
            String message = MessageFormat.format(Messages.MigrationAction_Image_ImpossibleToCreateImages, new EditingDomainServices().getLabelProviderText(contextObject), attribute.getName(), nonCreatedFilesPath);
            Activator.getDefault().getLog().error(message);
            Logger logger = ReportManagerRegistry.getInstance().subscribe("Default");
            Status status = new Status(4, "org.polarsys.capella.core.data.migration", message);
            LogExt.log((Logger)logger, (IStatus)status);
        }
        return createdFiles;
    }
}

