/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.osgi.framework.Version;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;

public class EnableFCAndPPFiltersMigrationContribution
extends AbstractMigrationContribution {
    private static final Set<String> FILTER_CANDIDATE_NAMES = new HashSet<String>(Arrays.asList("hide.overlappedphysical.paths.icon.filter", "hide.overlappedphysical.paths.label.filter", "hide.overlappedfunctional.chains.icon.filter", "hide.overlappedfunctional.chains.label.filter"));

    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        super.unaryMigrationExecute(currentElement, context);
        if (this.isValidModelVersion(context) && currentElement instanceof DSemanticDiagram) {
            DSemanticDiagram diagram = (DSemanticDiagram)currentElement;
            DiagramDescription description = diagram.getDescription();
            List filtersToActivate = description.getFilters().stream().filter(filter -> FILTER_CANDIDATE_NAMES.contains(filter.getName())).collect(Collectors.toList());
            diagram.getActivatedFilters().addAll(filtersToActivate);
        }
    }

    private boolean isValidModelVersion(MigrationContext context) {
        Version version = context.getCurrentVersion();
        return version.getMajor() == 1 && version.getMinor() == 4 || version.getMajor() == 5 && version.getMinor() == 0;
    }
}

