/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.osgi.framework.Version;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contribution.AbstractMigrationContribution;
import org.polarsys.capella.core.sirius.analysis.helpers.DDiagramHelper;

public class ActivateDiagramFiltersContribution
extends AbstractMigrationContribution {
    @Override
    public void unaryMigrationExecute(EObject currentElement, MigrationContext context) {
        super.unaryMigrationExecute(currentElement, context);
        if (this.isValidModelVersion(context) && currentElement instanceof DSemanticDiagram && DDiagramHelper.isMSM((DDiagram)((DSemanticDiagram)currentElement))) {
            DSemanticDiagram diagram = (DSemanticDiagram)currentElement;
            DiagramDescription description = diagram.getDescription();
            List filtersToActivate = description.getFilters().stream().filter(filter -> "hide.computed.transitions.filter".equals(filter.getName())).collect(Collectors.toList());
            diagram.getActivatedFilters().addAll(filtersToActivate);
        }
    }

    private boolean isValidModelVersion(MigrationContext context) {
        Version version = context.getCurrentVersion();
        return version.getMajor() < 6;
    }
}

