/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.ui.properties.Messages;

public class CapellaDataListenerForPropertySections {
    private static final String REFRESH_VIEW_JOB_FAMILY = "RefreshPropertiesViewJob";
    private static final String PROPERTY_SHEET_ID = "org.eclipse.ui.views.PropertySheet";
    private Set<TabbedPropertySheetPage> pages;

    public void refresh() {
        if (!this.getPages().isEmpty() && this.isPropertiesViewVisible(this.getPages().iterator().next().getSite())) {
            this.scheduleRefreshPropertiesViewJob();
        }
    }

    public void registerPropertySheetPage(TabbedPropertySheetPage page) {
        if (!this.getPages().contains(page)) {
            this.getPages().add(page);
        }
    }

    public void unregisterPropertySheetPage(TabbedPropertySheetPage page) {
        this.getPages().remove(page);
    }

    public Set<TabbedPropertySheetPage> getPages() {
        if (this.pages == null) {
            this.pages = new HashSet<TabbedPropertySheetPage>();
        }
        return this.pages;
    }

    private boolean isPropertiesViewVisible(IPageSite pageSite) {
        IWorkbenchPage workbenchPage = pageSite.getPage();
        IViewPart propertySheet = workbenchPage.findView(PROPERTY_SHEET_ID);
        return propertySheet != null && workbenchPage.isPartVisible((IWorkbenchPart)propertySheet);
    }

    private void scheduleRefreshPropertiesViewJob() {
        Job[] jobs = Job.getJobManager().find((Object)REFRESH_VIEW_JOB_FAMILY);
        if (jobs.length == 0) {
            new RefreshPropertiesViewJob().schedule();
        } else {
            jobs[0].schedule();
        }
    }

    private class RefreshPropertiesViewJob
    extends UIJob {
        public RefreshPropertiesViewJob() {
            super(Display.getDefault(), Messages.PropertyView_JobName);
        }

        public boolean belongsTo(Object family) {
            return CapellaDataListenerForPropertySections.REFRESH_VIEW_JOB_FAMILY.equals(family);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            for (TabbedPropertySheetPage page : CapellaDataListenerForPropertySections.this.getPages()) {
                if (page.getCurrentTab() != null) {
                    page.refresh();
                }
                page.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)new BaseLabelProvider(), null));
            }
            return Status.OK_STATUS;
        }
    }
}

