/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.merge.ExtendedComparison;
import org.polarsys.capella.core.transition.common.policies.diff.ExtDiffPolicy;
import org.polarsys.capella.core.transition.common.policies.match.TraceabilityHandlerMatchPolicy;
import org.polarsys.capella.core.transition.common.policies.merge.ExtMergePolicy;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DifferencesComputingActivity
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.core.transition.common.activities.DifferencesComputingActivity";

    @Override
    public IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        this.computeDifferences(context);
        return Status.OK_STATUS;
    }

    public void computeDifferences(IContext context) {
        IEditableModelScope sourceScope = (IEditableModelScope)context.get((Object)"MERGE_SOURCE_SCOPE");
        IEditableModelScope targetScope = (IEditableModelScope)context.get((Object)"MERGE_TARGET_SCOPE");
        EComparison comparison = this.createComparison(sourceScope, targetScope);
        context.put((Object)"MERGE_COMPARISON", (Object)comparison);
        comparison.compute(this.createMatchPolicy(context), this.createDiffPolicy(context), this.createMergePolicy(context), null);
        Collection toAnalyseFromSource = comparison.getDifferences(Role.REFERENCE);
        Collection toAnalyseFromTarget = comparison.getDifferences(Role.TARGET);
        context.put((Object)"MERGE_REFERENCE_DIFFERENCES", (Object)toAnalyseFromSource);
        context.put((Object)"MERGE_TARGET_DIFFERENCES", (Object)toAnalyseFromTarget);
        if (this.displayLog(context)) {
            LogHelper.getInstance().debug(NLS.bind((String)"Differences from {0}", (Object)Role.REFERENCE.toString()), Messages.Activity_ComputingDifferenceActivity);
            for (IDifference diff : toAnalyseFromSource) {
                LogHelper.getInstance().debug(NLS.bind((String)" - {0}", (Object)diff.toString()), Messages.Activity_ComputingDifferenceActivity);
            }
            LogHelper.getInstance().debug(NLS.bind((String)"Differences from {0}", (Object)Role.TARGET.toString()), Messages.Activity_ComputingDifferenceActivity);
            for (IDifference diff : toAnalyseFromTarget) {
                LogHelper.getInstance().debug(NLS.bind((String)" - {0}", (Object)diff.toString()), Messages.Activity_ComputingDifferenceActivity);
            }
        }
    }

    protected boolean displayLog(IContext context) {
        return true;
    }

    protected IMergePolicy<EObject> createMergePolicy(IContext context) {
        return new ExtMergePolicy(context);
    }

    protected IDiffPolicy<EObject> createDiffPolicy(IContext context) {
        return new ExtDiffPolicy(context);
    }

    protected EComparison createComparison(IEditableModelScope sourceScope, IEditableModelScope targetScope) {
        return new ExtendedComparison(targetScope, sourceScope);
    }

    protected IMatchPolicy<EObject> createMatchPolicy(IContext context) {
        return new TraceabilityHandlerMatchPolicy(context);
    }
}

