/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.browser.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BrowserElementUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDestroyed(EObject rootElement, List<Notification> notifications) {
        try {
            LinkedList<EObject> list = new LinkedList<EObject>();
            list.add(rootElement);
            List<EObject> parents = BrowserElementUtil.getParents(list, rootElement);
            block7: for (Notification notification : notifications) {
                EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                if (!(feature instanceof EReference)) continue;
                Object objectToLink = notification.getNewValue();
                Object formerObject = notification.getOldValue();
                switch (notification.getEventType()) {
                    case 1: 
                    case 3: {
                        if (objectToLink != null || formerObject == null || !parents.contains(formerObject)) continue block7;
                        return true;
                    }
                    case 4: {
                        if (!parents.contains(formerObject)) continue block7;
                        return true;
                    }
                    case 6: {
                        Collection children = (Collection)notification.getOldValue();
                        for (EObject child : children) {
                            if (!parents.contains(child)) continue;
                            return true;
                        }
                        continue block7;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        catch (NoSuchElementException exception) {
            return false;
        }
    }

    public static List<EObject> getParents(List<EObject> parents, EObject rootElement) {
        EObject parent = rootElement.eContainer();
        if (parent == null) {
            return parents;
        }
        parents.add(parent);
        return BrowserElementUtil.getParents(parents, parent);
    }
}

