/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.massactions.shared.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.ui.massactions.activator.MACapellaActivator;
import org.polarsys.capella.common.ui.massactions.shared.helper.CapellaMASelectionHelper;
import org.polarsys.kitalpha.massactions.shared.view.MAView;

public abstract class AbstractSendToMenuContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    protected CapellaMASelectionHelper selectionHelper;

    protected abstract String getViewID();

    protected abstract String getViewName();

    protected abstract String getCommandID();

    protected abstract String getNewViewIcon();

    protected abstract String getExistingViewIcon();

    protected abstract String getCommandParameterPrimaryId();

    protected abstract String getCommandParameterSecondaryId();

    protected abstract String getCommandParameterShouldCreateViewId();

    protected abstract boolean isMassView(IViewPart var1);

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
        this.selectionHelper = new CapellaMASelectionHelper();
    }

    protected IContributionItem[] getContributionItems() {
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<IViewReference> viewReferenceStream = Stream.of(viewReferences);){
            ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
            TransactionalEditingDomain selectionEditingDomain = this.selectionHelper.getEditingDomainFromSelectionService(selectionService);
            List<MAView> maViewParts = Collections.emptyList();
            if (selectionEditingDomain != null) {
                maViewParts = viewReferenceStream.map(viewRef -> viewRef.getView(false)).filter(this::isMassView).map(MAView.class::cast).filter(this.validMAViewTarget(selectionEditingDomain)).collect(Collectors.toList());
            }
            ArrayList<Object> contributionItems = new ArrayList<Object>();
            contributionItems.add(this.getNewViewContributionItem());
            if (!maViewParts.isEmpty()) {
                contributionItems.add(new Separator());
                contributionItems.addAll(this.getExistingViewContributionItems(maViewParts));
            }
            return contributionItems.toArray(new IContributionItem[contributionItems.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IContributionItem getNewViewContributionItem() {
        return this.createContributionItem(this.getNewViewText(), this.getNewViewIcon(), this.getViewID(), null, true);
    }

    protected Collection<IContributionItem> getExistingViewContributionItems(List<MAView> maViewParts) {
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        for (IViewPart iViewPart : maViewParts) {
            IContributionItem contributionItem = this.createContributionItem(iViewPart.getTitle(), this.getExistingViewIcon(), iViewPart.getViewSite().getId(), iViewPart.getViewSite().getSecondaryId(), false);
            contributionItems.add(contributionItem);
        }
        return contributionItems;
    }

    protected IContributionItem createContributionItem(String itemLabel, String iconKey, String primaryViewId, String secondaryViewId, boolean shouldCreateViewId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(this.getCommandParameterPrimaryId(), primaryViewId);
        parameters.put(this.getCommandParameterSecondaryId(), secondaryViewId);
        parameters.put(this.getCommandParameterShouldCreateViewId(), String.valueOf(shouldCreateViewId));
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, "", this.getCommandID(), 4);
        parameter.label = itemLabel;
        parameter.tooltip = itemLabel;
        parameter.parameters = parameters;
        parameter.icon = MACapellaActivator.getDefault().getImageRegistry().getDescriptor(iconKey);
        return new CommandContributionItem(parameter);
    }

    protected String getNewViewText() {
        return "New " + this.getViewName() + " View";
    }

    private Predicate<? super MAView> validMAViewTarget(TransactionalEditingDomain selectionEditingDomain) {
        return view -> view.getEditingDomain() == null || view.getEditingDomain().equals(selectionEditingDomain);
    }
}

