/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.ecore.tools.ETools;
import org.eclipse.sirius.query.legacy.gen.AcceleoGenMessages;
import org.eclipse.sirius.query.legacy.gen.template.Template;
import org.eclipse.sirius.query.legacy.gen.template.TemplateConstants;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxExceptions;
import org.eclipse.sirius.query.legacy.gen.template.TemplateText;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateCallSetExpression;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.AbstractScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IEvalSettings;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.gen.template.scripts.ISpecificScriptContext;
import org.eclipse.sirius.query.legacy.gen.template.scripts.ScriptDescriptor;
import org.eclipse.sirius.query.legacy.gen.template.scripts.ScriptDescriptorFactory;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalJavaService;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.EvalModel;
import org.eclipse.sirius.query.legacy.gen.template.scripts.imports.JavaServiceNotFoundException;
import org.eclipse.sirius.query.legacy.gen.template.statements.TemplateFeatureStatement;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoMetamodelProvider;
import org.eclipse.sirius.query.legacy.tools.plugins.AcceleoModuleProvider;
import org.eclipse.sirius.query.legacy.tools.resources.Resources;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;
import org.eclipse.sirius.query.legacy.tools.strings.TextSearch;
import org.osgi.framework.Bundle;

public class SpecificScript
extends AbstractScript {
    public static final String GENERATORS_EXTENSION = "mt";
    private boolean initProfiling = false;
    protected Map textTemplates = new TreeMap(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0.equals(arg1)) {
                return 0;
            }
            ScriptDescriptor a0 = (ScriptDescriptor)arg0;
            ScriptDescriptor a1 = (ScriptDescriptor)arg1;
            int result = a0.type.compareTo(a1.type);
            if (result != 0) {
                return result;
            }
            return a0.name.compareTo(a1.name);
        }
    });
    protected List textTemplateNames = new ArrayList();
    protected Map fileTemplates = new HashMap();
    protected File file = null;
    protected EPackage metamodel = null;
    protected Map file2TextTemplate = new HashMap();
    protected Map text2FileTemplate = new HashMap();
    protected File chainFile = null;
    protected ISpecificScriptContext scriptContext = null;
    protected Boolean useSpecificImportsFirst = null;
    private String oldContent = null;
    protected Map id2TextTemplate = new HashMap();
    private final Map quickTemplates = new HashMap();
    protected Template current = null;
    protected Map id2FileTemplate = new HashMap();
    private final List syntaxErrors = new ArrayList();
    private ScriptDescriptorFactory descriptorFactory = null;
    private final Map mt2OldModificationStamp = new HashMap();
    private List oldImports = new ArrayList();
    private final Map name2Properties = new HashMap();
    private Properties[] allProperties = null;

    public SpecificScript() {
        try {
            this.init(new ArrayList(), "", false);
        }
        catch (TemplateSyntaxExceptions templateSyntaxExceptions) {}
    }

    public SpecificScript(File file) {
        this(file, null);
    }

    public SpecificScript(File file, File chainFile) {
        this();
        this.file = file;
        this.chainFile = chainFile;
        this.scriptContext = null;
    }

    public SpecificScript(File file, File chainFile, ISpecificScriptContext scriptContext) {
        this();
        this.file = file;
        this.chainFile = chainFile;
        this.scriptContext = scriptContext;
        if (scriptContext != null) {
            scriptContext.setScript(file, this);
        }
    }

    public EPackage getMetamodel() {
        return this.metamodel;
    }

    public Map getTextTemplates() {
        return this.textTemplates;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public File getChainFile() {
        return this.chainFile;
    }

    public void setChainFile(File chainFile) {
        this.chainFile = chainFile;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean isSpecific() {
        return true;
    }

    @Override
    public void reset() throws TemplateSyntaxExceptions {
        this.reset(new ArrayList());
    }

    protected boolean useSpecificImportsFirst() {
        if (this.useSpecificImportsFirst == null) {
            this.useSpecificImportsFirst = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.query.legacy", "PREF_USE_SPECIFIC_SCRIPTS_FIRST", true, null);
        }
        return this.useSpecificImportsFirst;
    }

    private void reset(List fileHierarchy) throws TemplateSyntaxExceptions {
        if (this.file != null) {
            String content = Resources.getFileContent(this.file).toString();
            this.reset(fileHierarchy, content);
        }
    }

    public void reset(String content) throws TemplateSyntaxExceptions {
        this.reset(new ArrayList(), content);
    }

    private synchronized void reset(List fileHierarchy, String content) throws TemplateSyntaxExceptions {
        boolean checkOnly;
        if (this.file != null) {
            if (fileHierarchy.contains(this.file.getAbsolutePath())) {
                ArrayList<TemplateSyntaxException> problems = new ArrayList<TemplateSyntaxException>();
                problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.RecursiveDependency"), (IScript)this, 0));
                throw new TemplateSyntaxExceptions(problems);
            }
            fileHierarchy.add(this.file.getAbsolutePath());
        }
        if (this.oldContent == null || !this.oldContent.equals(content)) {
            this.oldContent = content;
            checkOnly = false;
            this.textTemplates.clear();
            this.textTemplateNames.clear();
            this.fileTemplates.clear();
            this.id2TextTemplate.clear();
            this.id2FileTemplate.clear();
            this.file2TextTemplate.clear();
            this.text2FileTemplate.clear();
            this.quickTemplates.clear();
        } else {
            checkOnly = true;
        }
        this.clearFoundProperties();
        this.current = null;
        this.init(fileHierarchy, content, checkOnly);
    }

    public Template getFileTemplate(Template textTemplate) {
        return (Template)this.text2FileTemplate.get(textTemplate);
    }

    public Template getTextTemplate(Template fileTemplate) {
        return (Template)this.file2TextTemplate.get(fileTemplate);
    }

    @Override
    public Template getTextTemplateForEObject(EObject object, String name) throws FactoryException, ENodeException {
        return this.getTextTemplateForEClass(object.eClass(), name);
    }

    private Template getTextTemplateForEClass(EClass eClass, String name) throws FactoryException, ENodeException {
        Template template = this.getTextTemplateForEClassifier((EClassifier)eClass, name);
        if (template == null) {
            if (eClass.getESuperTypes().isEmpty() && eClass != EcorePackage.eINSTANCE.getEObject()) {
                template = this.getTextTemplateForEClass(EcorePackage.eINSTANCE.getEObject(), name);
            }
            Iterator superTypes = eClass.getESuperTypes().iterator();
            while (template == null && superTypes.hasNext()) {
                EClassifier superType = (EClassifier)superTypes.next();
                template = superType instanceof EClass ? this.getTextTemplateForEClass((EClass)superType, name) : this.getTextTemplateForEClassifier(superType, name);
            }
        }
        return template;
    }

    private Template getTextTemplateForEClassifier(EClassifier eClass, String name) throws FactoryException, ENodeException {
        ScriptDescriptor key = new ScriptDescriptor(ETools.getEClassifierPath(eClass), name);
        Template template = (Template)this.id2TextTemplate.get(key);
        if (template == null) {
            template = (Template)this.textTemplates.get(key);
            if (template == null) {
                Iterator it = this.textTemplates.entrySet().iterator();
                while (template == null && it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!name.equals(((ScriptDescriptor)entry.getKey()).name) || !(String.valueOf('.') + key.type).endsWith(String.valueOf('.') + ((ScriptDescriptor)entry.getKey()).type)) continue;
                    template = (Template)entry.getValue();
                }
            }
            if (template != null) {
                this.id2TextTemplate.put(key, template);
            }
        }
        return template;
    }

    @Override
    public Template getRootTemplate(EObject object, boolean recursive) throws FactoryException, ENodeException {
        Template textTemplate = null;
        Template fileTemplate = this.getFileTemplateForEObject(object);
        if (fileTemplate != null) {
            textTemplate = (Template)this.file2TextTemplate.get(fileTemplate);
        }
        if (recursive && !this.hasFileTemplate() && textTemplate == null) {
            Iterator imports = this.imports.iterator();
            while (textTemplate == null && imports.hasNext()) {
                IEvalSettings anImport = (IEvalSettings)imports.next();
                if (!(anImport instanceof IScript)) continue;
                try {
                    textTemplate = ((IScript)anImport).getRootTemplate(object, false);
                }
                catch (ENodeException eNodeException) {
                    textTemplate = null;
                }
            }
        }
        if (textTemplate != null) {
            return textTemplate;
        }
        throw new ENodeException(AcceleoGenMessages.getString("ENodeError.UnresolvedRoot"), new Int2(0, 0), this, object, true);
    }

    public Template createTextTemplate(ScriptDescriptor descriptor) throws TemplateSyntaxException {
        return this.createTextTemplate(descriptor, "", new Int2(0, 0));
    }

    public Template createTextTemplate(ScriptDescriptor descriptor, String text, Int2 pos) throws TemplateSyntaxException {
        TemplateSyntaxException failure = null;
        Template template = (Template)this.textTemplates.get(descriptor);
        if (template == null) {
            String quickEntry = String.valueOf(descriptor.getType()) + '\n' + descriptor.getName() + '\n' + text.substring(pos.b(), pos.e());
            template = (Template)this.quickTemplates.get(quickEntry);
            if (template == null) {
                try {
                    template = this.newTextTemplate(descriptor, text, pos);
                }
                catch (TemplateSyntaxException e) {
                    template = this.newTextTemplate(descriptor, null, pos);
                    failure = e;
                }
                this.quickTemplates.put(quickEntry, template);
            }
            template.setPos(pos);
            this.textTemplates.put(descriptor, template);
            if (!this.textTemplateNames.contains(descriptor.getName())) {
                this.textTemplateNames.add(descriptor.getName());
            }
            this.current = template;
        } else {
            failure = new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.DuplicateEntry.Text", new Object[]{descriptor.toString()}), (IScript)this, pos);
        }
        if (failure != null) {
            throw failure;
        }
        return template;
    }

    protected Template newTextTemplate(ScriptDescriptor descriptor, String text, Int2 pos) throws TemplateSyntaxException {
        Template template = Template.read(text, pos, this);
        template.setDescriptor(descriptor);
        return template;
    }

    public Template getCurrent() {
        return this.current;
    }

    public void setCurrent(Template current) {
        this.current = current;
    }

    @Override
    public boolean hasFileTemplate() {
        return this.fileTemplates.size() > 0;
    }

    @Override
    public boolean isGenerated(EObject object) {
        try {
            return this.getFilePath(object, true) != null;
        }
        catch (FactoryException factoryException) {
            return false;
        }
    }

    @Override
    public IPath getFilePath(EObject object, boolean recursive) throws FactoryException {
        if (this.hasFileTemplate()) {
            try {
                String path;
                Template fileTemplate = this.getFileTemplateForEObject(object);
                if (fileTemplate != null && (path = fileTemplate.evaluateAsString(object, LaunchManager.create("run", false)).trim()).length() > 0) {
                    return new Path(path);
                }
            }
            catch (ENodeException eNodeException) {}
        } else if (recursive) {
            for (IEvalSettings anImport : this.imports) {
                IPath path;
                if (!(anImport instanceof IScript) || (path = ((IScript)anImport).getFilePath(object, false)) == null) continue;
                return path;
            }
        }
        return null;
    }

    public Template getFileTemplateForEObject(EObject object) {
        Template res = this.getFileTemplateForEClass(object.eClass());
        if (res == null) {
            res = this.getFileTemplateForEClass(EcorePackage.eINSTANCE.getEObject());
        }
        return res;
    }

    private Template getFileTemplateForEClass(EClass eClass) {
        Template template = this.getFileTemplateForEClassifier((EClassifier)eClass);
        if (template == null) {
            Iterator superTypes = eClass.getESuperTypes().iterator();
            while (template == null && superTypes.hasNext()) {
                EClassifier superType = (EClassifier)superTypes.next();
                template = superType instanceof EClass ? this.getFileTemplateForEClass((EClass)superType) : this.getFileTemplateForEClassifier(superType);
            }
        }
        return template;
    }

    private Template getFileTemplateForEClassifier(EClassifier eClass) {
        String typeID = ETools.getEClassifierPath(eClass);
        Template template = (Template)this.id2FileTemplate.get(typeID);
        if (template == null) {
            template = (Template)this.fileTemplates.get(typeID);
            if (template == null) {
                Iterator it = this.fileTemplates.entrySet().iterator();
                while (template == null && it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!(String.valueOf('.') + typeID).endsWith("." + entry.getKey())) continue;
                    template = (Template)entry.getValue();
                }
            }
            if (template != null) {
                this.id2FileTemplate.put(typeID, template);
            }
        }
        return template;
    }

    public void createFileTemplate(String typeID, String text, Template textTemplate) throws TemplateSyntaxException {
        this.createFileTemplate(typeID, text, new Int2(0, text.length()), textTemplate);
    }

    public void createFileTemplate(String typeID, String text, Int2 pos, Template textTemplate) throws TemplateSyntaxException {
        TemplateSyntaxException failure = null;
        Template template = (Template)this.fileTemplates.get(typeID);
        if (template == null) {
            try {
                template = Template.read(text, pos, this);
            }
            catch (TemplateSyntaxException e) {
                template = new Template(this);
                failure = e;
            }
            this.fileTemplates.put(typeID, template);
            this.file2TextTemplate.put(template, textTemplate);
            this.text2FileTemplate.put(textTemplate, template);
        } else {
            failure = new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.DuplicateEntry.File", new Object[]{typeID}), (IScript)this, pos);
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        for (Map.Entry entry : this.textTemplates.entrySet()) {
            ScriptDescriptor key = (ScriptDescriptor)entry.getKey();
            buffer.append(TemplateConstants.SCRIPT_BEGIN);
            buffer.append(key.toString());
            Template fileTemplate = (Template)this.fileTemplates.get(key.type);
            if (fileTemplate != null) {
                buffer.append(' ');
                buffer.append(TemplateConstants.SCRIPT_FILE);
                buffer.append(TemplateConstants.SCRIPT_PROPERTY_ASSIGN);
                buffer.append(TemplateConstants.LITERAL[0]);
                buffer.append(fileTemplate.toString());
                buffer.append(TemplateConstants.LITERAL[1]);
            }
            buffer.append(TemplateConstants.SCRIPT_END);
            buffer.append('\n');
            String text = ((Template)entry.getValue()).toString();
            buffer.append(text);
            buffer.append("\n\n");
        }
        return buffer.toString();
    }

    protected void init(List fileHierarchy, String text, boolean checkOnly) throws TemplateSyntaxExceptions {
        boolean isRoot;
        boolean bl = isRoot = fileHierarchy.size() <= 1;
        if (AbstractScript.getScriptLoader() != null && (text = AbstractScript.getScriptLoader().load(text)) != null) {
            IFile workspaceFile;
            ArrayList problems = new ArrayList();
            TemplateConstants.initConstants(text);
            this.oldImports = new ArrayList(this.imports);
            this.clearImports();
            if (text != null && text.length() > 0) {
                if (this.file != null) {
                    try {
                        this.addImport(new EvalJavaService(this.file));
                    }
                    catch (JavaServiceNotFoundException javaServiceNotFoundException) {}
                }
                this.parseImports(fileHierarchy, text, problems);
                this.getSystemServicesFactory().addImports(this, isRoot);
                if (!checkOnly) {
                    this.syntaxErrors.clear();
                    this.parseScripts(text, this.syntaxErrors);
                }
                problems.addAll(this.syntaxErrors);
            }
            if (this.file != null && (workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.file.getAbsolutePath()))) != null && workspaceFile.exists() && isRoot) {
                this.checkAllExpressions(problems);
            }
            if (this.scriptContext != null && this.scriptContext.getMaxLevel() != -1) {
                this.checkOverride(problems);
            }
            if (problems.size() > 0) {
                throw new TemplateSyntaxExceptions(problems);
            }
        }
    }

    private void checkOverride(List problems) {
        HashMap overrides = new HashMap();
        Iterator it = this.getImports().iterator();
        while (it.hasNext()) {
            HashMap localOverrides = new HashMap();
            IEvalSettings imp = (IEvalSettings)it.next();
            if (imp instanceof SpecificScript) {
                SpecificScript script = (SpecificScript)imp;
                for (Map.Entry entry : script.textTemplates.entrySet()) {
                    EClassifier type = ETools.getEClassifier(script.getMetamodel(), ((ScriptDescriptor)entry.getKey()).getType());
                    if (!(type instanceof EClass)) continue;
                    Template template = (Template)entry.getValue();
                    String name = template.getDescriptor().getName();
                    ArrayList<EClassifier> typeList = (ArrayList<EClassifier>)overrides.get(name);
                    if (typeList == null) {
                        typeList = new ArrayList<EClassifier>();
                        localOverrides.put(name, typeList);
                    } else if (this.isMaskedOverride((EClass)type, typeList)) {
                        TemplateSyntaxException problem = new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.BadOverride", new Object[]{this.fileScriptToImportString(script.getFile())}), (IScript)this, 1);
                        problem.setSeverity(1);
                        problems.add(problem);
                    }
                    typeList.add(type);
                }
            }
            for (Map.Entry entry : localOverrides.entrySet()) {
                String name = (String)entry.getKey();
                List types = (List)overrides.get(name);
                if (types == null) {
                    overrides.put(name, entry.getValue());
                    continue;
                }
                types.addAll((List)entry.getValue());
            }
        }
    }

    private boolean isMaskedOverride(EClass type, List typeList) {
        boolean res = false;
        EList supertypes = type.getEAllSuperTypes();
        Iterator it = typeList.iterator();
        while (!res && it.hasNext()) {
            res = supertypes.contains(it.next());
        }
        return res;
    }

    private void parseScripts(String text, List problems) {
        TemplateConstants.initConstants(text);
        ScriptDescriptor descriptor = null;
        Int2 end = new Int2(0, 0);
        while (end.e() > -1 && end.e() < text.length()) {
            Int2 begin = TextSearch.getDefaultSearch().indexOf(text, TemplateConstants.SCRIPT_BEGIN, end.e(), null, TemplateConstants.INHIBS_SCRIPT_CONTENT);
            if (begin.b() > -1) {
                try {
                    this.newScript(descriptor, text, new Int2(end.e(), begin.b()));
                }
                catch (TemplateSyntaxException e) {
                    problems.add(e);
                }
                descriptor = null;
                end = TextSearch.getDefaultSearch().blockIndexEndOf(text, TemplateConstants.SCRIPT_BEGIN, TemplateConstants.SCRIPT_END, begin.b(), false, TemplateConstants.SPEC, TemplateConstants.INHIBS_SCRIPT_DECLA);
                if (end.e() == -1) {
                    problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingScriptEndTag"), (IScript)this, begin.b()));
                    continue;
                }
                try {
                    descriptor = this.getDescriptorFactory().createScriptDescriptor(text, this, new Int2(begin.e(), end.b()));
                }
                catch (TemplateSyntaxException e) {
                    problems.add(e);
                    descriptor = null;
                }
                continue;
            }
            try {
                this.newScript(descriptor, text, new Int2(end.e(), text.length()));
            }
            catch (TemplateSyntaxException e) {
                problems.add(e);
            }
            end = new Int2(text.length(), text.length());
        }
    }

    protected ScriptDescriptorFactory createDescriptorFactory() {
        return new ScriptDescriptorFactory();
    }

    private ScriptDescriptorFactory getDescriptorFactory() {
        if (this.descriptorFactory == null) {
            this.descriptorFactory = this.createDescriptorFactory();
        }
        return this.descriptorFactory;
    }

    protected void parseImports(List fileHierarchy, String text, List problems) {
        this.metamodel = null;
        ArrayList<String> importValues = new ArrayList<String>();
        int end = TextSearch.getDefaultSearch().indexOf(text, TemplateConstants.SCRIPT_BEGIN, 0, null, TemplateConstants.INHIBS_SCRIPT_CONTENT).b();
        if (end == -1) {
            end = text.length();
        }
        int pos = 0;
        while (pos > -1 && pos < end) {
            Int2 bComment = TextSearch.getDefaultSearch().indexIn(text, TemplateConstants.COMMENT_BEGIN, pos, end);
            Int2 bImports = TextSearch.getDefaultSearch().indexIn(text, TemplateConstants.IMPORT_BEGIN, pos, end);
            if (bComment.b() > -1 && (bImports.b() == -1 || bComment.b() <= bImports.b())) {
                Int2 eComment = TextSearch.getDefaultSearch().blockIndexEndIn(text, TemplateConstants.COMMENT_BEGIN, TemplateConstants.COMMENT_END, bComment.b(), end, false);
                if (eComment.b() > -1) {
                    pos = eComment.e();
                    continue;
                }
                problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingCommentEndTag"), (IScript)this, bComment.b()));
                pos = end;
                continue;
            }
            if (bImports.b() > -1) {
                Int2 eImports = TextSearch.getDefaultSearch().indexIn(text, TemplateConstants.IMPORT_END, bImports.e(), end);
                if (eImports.b() > -1) {
                    Int2[] imports;
                    Int2[] int2Array = imports = TextSearch.getDefaultSearch().splitPositionsIn(text, bImports.e(), eImports.b(), new String[]{"\n"}, false);
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Int2 import1;
                        Int2 importPos = import1 = int2Array[n2];
                        importPos = TextSearch.getDefaultSearch().trim(text, importPos.b(), importPos.e());
                        if (importPos.b() > -1 && importPos.e() > importPos.b()) {
                            String value;
                            Int2 valuePos;
                            if (TextSearch.getDefaultSearch().indexIn(text, TemplateConstants.IMPORT_WORD, importPos.b(), importPos.e()).b() == importPos.b()) {
                                valuePos = TextSearch.getDefaultSearch().trim(text, importPos.b() + TemplateConstants.IMPORT_WORD.length(), importPos.e());
                                if (valuePos.b() > -1) {
                                    value = text.substring(valuePos.b(), valuePos.e()).trim();
                                    if (importValues.contains(value)) {
                                        problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.DuplicateValue", new Object[]{"import"}), (IScript)this, valuePos));
                                    } else {
                                        importValues.add(value);
                                        try {
                                            this.newImport(fileHierarchy, value, valuePos, importValues.size());
                                        }
                                        catch (TemplateSyntaxException e) {
                                            problems.add(e);
                                        }
                                    }
                                } else {
                                    problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.EmptyImport"), (IScript)this, importPos.b() + TemplateConstants.IMPORT_WORD.length()));
                                }
                            } else if (TextSearch.getDefaultSearch().indexIn(text, TemplateConstants.MODELTYPE_WORD, importPos.b(), importPos.e()).b() == importPos.b()) {
                                valuePos = TextSearch.getDefaultSearch().trim(text, importPos.b() + TemplateConstants.MODELTYPE_WORD.length(), importPos.e());
                                if (valuePos.b() > -1) {
                                    value = text.substring(valuePos.b(), valuePos.e()).trim();
                                    if (importValues.contains(value)) {
                                        problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.DuplicateValue", new Object[]{"metamodel"}), (IScript)this, valuePos));
                                    } else {
                                        importValues.add(value);
                                        try {
                                            this.newImport(fileHierarchy, value, valuePos, importValues.size());
                                        }
                                        catch (TemplateSyntaxException e) {
                                            problems.add(e);
                                        }
                                    }
                                } else {
                                    problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.EmptyValue", new Object[]{"metamodel"}), (IScript)this, importPos.b() + TemplateConstants.MODELTYPE_WORD.length()));
                                }
                            } else {
                                problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.MissingKeyWord", new Object[]{"import"}), (IScript)this, importPos.b()));
                            }
                        }
                        ++n2;
                    }
                    pos = eImports.e();
                    continue;
                }
                problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidImportSequence"), (IScript)this, bImports.b()));
                pos = end;
                continue;
            }
            pos = end;
        }
    }

    protected void newImport(List fileHierarchy, String value, Int2 valuePos, int num) throws TemplateSyntaxException {
        boolean isMetamodelImport = this.parseMetamodelImport(value, valuePos, num);
        if (!(this.scriptContext != null && this.scriptContext.getMaxLevel() != -1 && fileHierarchy.size() >= this.scriptContext.getMaxLevel() || isMetamodelImport || this.file == null)) {
            boolean service = false;
            boolean specificExists = false;
            if (this.useSpecificImportsFirst()) {
                specificExists = this.newImportFromSpecificImports(fileHierarchy, value, valuePos, num);
                service = this.newImportFromJavaServices(value);
            } else {
                service = this.newImportFromJavaServices(value);
                if (!service) {
                    specificExists = this.newImportFromSpecificImports(fileHierarchy, value, valuePos, num);
                }
            }
            if (!service && !specificExists) {
                throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedImport", new Object[]{value}), (IScript)this, valuePos);
            }
        }
    }

    protected boolean newImportFromJavaServices(String qualifiedName) {
        boolean service = false;
        try {
            this.addImportForJavaService(this.file, qualifiedName);
            service = true;
        }
        catch (JavaServiceNotFoundException javaServiceNotFoundException) {}
        return service;
    }

    protected boolean newImportFromSpecificImports(List fileHierarchy, String value, Int2 valuePos, int num) throws TemplateSyntaxException {
        String[] specificExtensions;
        boolean specificExists = false;
        String[] stringArray = specificExtensions = this.getSpecificImportExtensions();
        int n = specificExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String specificExtension = stringArray[n2];
            File specificFile = this.resolveScriptFile(this.file, value, specificExtension);
            if (specificFile != null && specificFile.exists()) {
                IScript genSpecific = this;
                do {
                    if (genSpecific.getFile() == null || !genSpecific.getFile().equals(specificFile)) continue;
                    throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.RecursiveImport"), (IScript)this, valuePos);
                } while ((genSpecific = genSpecific.getSpecific()) != null);
                try {
                    if (!this.tryOptimizedImport(fileHierarchy, specificFile)) {
                        SpecificScript newImport = this.createSpecificImport(specificFile);
                        newImport.setInitProfiling(this.initProfiling);
                        newImport.reset(new ArrayList(fileHierarchy));
                        newImport.setSpecific(this);
                        this.addImport(newImport);
                    }
                }
                catch (TemplateSyntaxExceptions e) {
                    String message = AcceleoGenMessages.getString("SpecificScript.ErroneousTemplate");
                    if (e.getProblems().size() == 1) {
                        message = String.valueOf(message) + " : " + ((TemplateSyntaxException)e.getProblems().get(0)).getMessage();
                    }
                    throw new TemplateSyntaxException(message, (IScript)this, valuePos);
                }
                specificExists = true;
            }
            ++n2;
        }
        return specificExists;
    }

    protected void addImportForJavaService(File file, String value) throws JavaServiceNotFoundException {
        this.addImport(new EvalJavaService(file, value));
    }

    protected File resolveScriptFile(File script, String importValue, String extension) {
        File res = null;
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(script.getAbsolutePath()));
        if (file != null && file.isAccessible()) {
            IPath importPath = new Path(importValue.replaceAll("\\.", "/")).addFileExtension(extension);
            res = this.getScriptFileInProject(file.getProject(), importPath);
        } else {
            Bundle bundle;
            String pluginId = AcceleoModuleProvider.getDefault().getPluginId(script);
            if (pluginId != null && (bundle = Platform.getBundle((String)pluginId)) != null) {
                res = AcceleoModuleProvider.getDefault().getFile(bundle.getSymbolicName(), importValue, extension);
            }
        }
        return res;
    }

    private String fileScriptToImportString(File script) {
        String res = "";
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(script.getAbsolutePath()));
        String[] segments = file.getProjectRelativePath().segments();
        int i = 1;
        while (i < segments.length) {
            res = String.valueOf(res) + segments[i];
            if (i < segments.length - 1) {
                res = String.valueOf(res) + ".";
            }
            ++i;
        }
        return res;
    }

    private File getScriptFileInProject(IProject project, IPath importPath) {
        File result = null;
        if (project.exists()) {
            try {
                IClasspathEntry entry;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length && result == null) {
                    IFile test;
                    entry = entries[i];
                    if (entry.getEntryKind() == 3 && entry.getPath().segmentCount() > 1 && (test = ResourcesPlugin.getWorkspace().getRoot().getFile(entry.getPath().append(importPath))).exists()) {
                        result = test.getLocation().toFile();
                    }
                    ++i;
                }
                i = 0;
                while (i < entries.length && result == null) {
                    IProject entryProject;
                    entry = entries[i];
                    if (entry.getEntryKind() == 2 && entry.getPath().segmentCount() == 1 && (entryProject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0))) != null && entryProject.exists()) {
                        result = this.getScriptFileInProject(entryProject, importPath);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                result = null;
            }
            if (result == null) {
                String[] requiredPluginIDs = Resources.getRequiredPluginIDs(project);
                int i = 0;
                while (i < requiredPluginIDs.length && result == null) {
                    IProject bundleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredPluginIDs[i]);
                    if (bundleProject != null && bundleProject.exists()) {
                        result = this.getScriptFileInProject(bundleProject, importPath);
                    } else if (Platform.getBundle((String)requiredPluginIDs[i]) != null) {
                        result = AcceleoModuleProvider.getDefault().getFile(requiredPluginIDs[i], importPath);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    protected boolean parseMetamodelImport(String value, Int2 valuePos, int num) throws TemplateSyntaxException {
        if (num == 1) {
            File ecoreFile;
            EPackage regValue = EPackage.Registry.INSTANCE.getEPackage(value = value.trim());
            if (regValue != null) {
                EvalModel anImport = new EvalModel(value);
                if (anImport.getMetamodel() == null) {
                    throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedMetamodel"), (IScript)this, valuePos);
                }
                this.metamodel = anImport.getMetamodel();
                this.addImport(anImport);
                return true;
            }
            Path ecorePath = new Path(value);
            if (ecorePath.segmentCount() >= 2) {
                ecorePath = ecorePath.removeFileExtension().addFileExtension("ecore");
            }
            if ((ecoreFile = AcceleoMetamodelProvider.getDefault().getFile((IPath)ecorePath)) != null && ecoreFile.exists()) {
                EvalModel anImport = new EvalModel(value);
                if (anImport.getMetamodel() == null) {
                    throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedMetamodel"), (IScript)this, valuePos);
                }
                this.metamodel = anImport.getMetamodel();
                this.addImport(anImport);
                return true;
            }
            throw new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedMetamodel"), (IScript)this, valuePos);
        }
        return false;
    }

    protected String[] getSpecificImportExtensions() {
        return new String[]{GENERATORS_EXTENSION};
    }

    protected SpecificScript createSpecificImport(File specificFile) {
        SpecificScript result;
        if (this.scriptContext != null && (result = this.scriptContext.getScript(specificFile, this.chainFile)) != null) {
            return result;
        }
        result = new SpecificScript(specificFile, this.chainFile, this.scriptContext);
        return result;
    }

    private boolean tryOptimizedImport(List fileHierarchy, File file) throws TemplateSyntaxExceptions {
        boolean tryOptimizedImport;
        IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
        if (workspaceFile != null && workspaceFile.isAccessible()) {
            Double newModificationStamp = new Double(workspaceFile.getModificationStamp());
            Double oldModificationStamp = (Double)this.mt2OldModificationStamp.get(workspaceFile);
            tryOptimizedImport = oldModificationStamp != null && oldModificationStamp.doubleValue() == newModificationStamp.doubleValue();
            this.mt2OldModificationStamp.put(workspaceFile, newModificationStamp);
        } else {
            tryOptimizedImport = true;
        }
        if (tryOptimizedImport) {
            for (Object oldImportObject : this.oldImports) {
                SpecificScript oldImport;
                if (!(oldImportObject instanceof SpecificScript) || !(oldImport = (SpecificScript)oldImportObject).getFile().equals(file)) continue;
                oldImport.clearFoundProperties();
                oldImport.reset(new ArrayList(fileHierarchy));
                this.addImport(oldImport);
                oldImport.setSpecific(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addImport(IEvalSettings element) {
        super.addImport(element);
    }

    protected void checkAllExpressions(List problems) {
        if (this.metamodel == null) {
            problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidImportSequence"), (IScript)this, 0));
        } else {
            for (Map.Entry entry : this.textTemplates.entrySet()) {
                String type = ((ScriptDescriptor)entry.getKey()).type;
                Template template = (Template)entry.getValue();
                this.checkAllExpressions(problems, type, template);
            }
            for (Map.Entry entry : this.fileTemplates.entrySet()) {
                String type = (String)entry.getKey();
                Template template = (Template)entry.getValue();
                this.checkAllExpressions(problems, type, template);
            }
        }
    }

    private void checkAllExpressions(List problems, String type, Template template) {
        EClassifier classifier = ETools.getEClassifier(this.metamodel, type);
        if (classifier == null) {
            problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedClassifier", new Object[]{type}), (IScript)this, template.getPos()));
        } else {
            List allElements = template.getAllElements(TemplateCallSetExpression.class);
            if (template.getPostExpression() != null) {
                allElements.addAll(template.getPostExpression().getAllElements(TemplateCallSetExpression.class));
            }
            for (TemplateCallSetExpression callSet : allElements) {
                String previousString;
                String nextString;
                int iNewLine;
                if (callSet == null) continue;
                if (!callSet.isPredefined()) {
                    Object resolvedType = callSet.getRootResolver(classifier, this);
                    Iterator calls = callSet.iterator();
                    TemplateCallExpression call = null;
                    while (resolvedType != null && calls.hasNext()) {
                        call = (TemplateCallExpression)calls.next();
                        if (resolvedType == IEvalSettings.GENERIC_TYPE && call.getLink().length() > 0) {
                            char[] array = call.getLink().toCharArray();
                            int i = 0;
                            while (i < array.length) {
                                if (!Character.isJavaIdentifierPart(array[i])) {
                                    problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.InvalidCharacter", new Object[]{Character.toString(array[i])}), (IScript)this, new Int2(call.getPos().b() + i, call.getPos().b() + i + 1)));
                                }
                                ++i;
                            }
                        }
                        resolvedType = this.resolveType(resolvedType, call);
                    }
                    if (call == null || resolvedType != null) continue;
                    problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.UnresolvedCall", new Object[]{call}), (IScript)this, call.getPos()));
                    continue;
                }
                if (!callSet.getFirst().getLink().equals(TemplateConstants.USER_BEGIN_NAME) || callSet.getFirst().countArguments() != 0) continue;
                TemplateFeatureStatement feature = (TemplateFeatureStatement)callSet.getParent();
                boolean valid = false;
                if (feature.getNext() != null && feature.getNext() instanceof TemplateText && ((iNewLine = (nextString = ((TemplateText)feature.getNext()).toString()).indexOf("\n")) == -1 || nextString.substring(0, iNewLine).trim().length() > 0)) {
                    valid = true;
                }
                if (!valid && feature.getPrevious() != null && feature.getPrevious() instanceof TemplateText && ((iNewLine = (previousString = ((TemplateText)feature.getPrevious()).toString()).lastIndexOf("\n")) == -1 || previousString.substring(iNewLine).trim().length() > 0)) {
                    valid = true;
                }
                if (valid) continue;
                problems.add(new TemplateSyntaxException(AcceleoGenMessages.getString("TemplateSyntaxError.EmptyUserTag"), (IScript)this, callSet.getPos()));
            }
        }
    }

    private void newScript(ScriptDescriptor descriptor, String text, Int2 limitsTextTemplate) throws TemplateSyntaxException {
        if (descriptor != null && text != null) {
            limitsTextTemplate = Template.formatTemplate(text, limitsTextTemplate, 2);
            Template textTemplate = this.createTextTemplate(descriptor, text, limitsTextTemplate);
            if (descriptor.getFileTemplate() != null) {
                this.createFileTemplate(descriptor.getType(), text, descriptor.getFileTemplate(), textTemplate);
            }
            if (descriptor.getPostExpression() != null) {
                TemplateExpression postExpression = TemplateExpression.fromString(text, descriptor.getPostExpression(), this);
                textTemplate.setPostExpression(postExpression);
            }
        }
    }

    @Override
    public boolean hasError(EObject object) {
        return false;
    }

    @Override
    public ENode eGetTemplate(ENode node, String name, ENode[] args, LaunchManager mode) throws ENodeException, FactoryException {
        return this.eGetTemplateSub(node, name, args, mode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ENode eGetTemplateSub(ENode node, String name, ENode[] args, LaunchManager mode) throws ENodeException, FactoryException {
        if (!this.textTemplateNames.contains(name)) return null;
        if (!node.isEObject()) return null;
        try {
            EObject object = node.getEObject();
            Template template = this.getTextTemplateForEObject(object, name);
            if (template == null) return null;
            this.contextPush(IScript.TEMPLATE_ARGS, args);
            try {
                List children;
                boolean withComment = !this.hasFileTemplate() && name.equals("write");
                ENode result = withComment ? template.evaluateWithComment(object, mode) : template.evaluate(object, mode);
                if (result.isNull() && ((children = template.getSignificantStatements()).size() > 1 || children.size() == 1 && !(children.get(0) instanceof TemplateFeatureStatement))) {
                    result.asString();
                }
                if (!withComment) return result;
                if (!name.equals("write")) return result;
                if (!template.isEmptyEvaluation()) return result;
                return null;
            }
            finally {
                this.contextPop(IScript.TEMPLATE_ARGS);
            }
        }
        catch (ENodeCastException eNodeCastException) {}
        return null;
    }

    @Override
    public Object resolveType(Object type, TemplateCallExpression call, int depth) {
        block3: {
            block4: {
                if (!"".equals(call.getPrefix()) && !TemplateConstants.LINK_PREFIX_SCRIPT.equals(call.getPrefix())) break block3;
                if (call.getLink().length() == 0) {
                    return IEvalSettings.GENERIC_TYPE;
                }
                if (!(type instanceof EClassifier)) break block4;
                for (Map.Entry entry : this.textTemplates.entrySet()) {
                    ScriptDescriptor key = (ScriptDescriptor)entry.getKey();
                    if (!ETools.ofType((EClassifier)type, key.type) || !key.name.equals(call.getLink())) continue;
                    return IEvalSettings.GENERIC_TYPE;
                }
                break block3;
            }
            if (type != IEvalSettings.GENERIC_TYPE) break block3;
            for (Map.Entry entry : this.textTemplates.entrySet()) {
                ScriptDescriptor key = (ScriptDescriptor)entry.getKey();
                if (!key.name.equals(call.getLink())) continue;
                return IEvalSettings.GENERIC_TYPE;
            }
        }
        return super.resolveType(type, call, depth);
    }

    @Override
    public Object[] getCompletionProposals(Object type, int depth) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (type instanceof EClassifier) {
            for (Map.Entry entry : this.textTemplates.entrySet()) {
                if (!ETools.ofType((EClassifier)type, ((ScriptDescriptor)entry.getKey()).type)) continue;
                result.add(entry);
            }
        }
        result.addAll(Arrays.asList(super.getCompletionProposals(type, depth)));
        return result.toArray();
    }

    private void clearFoundProperties() {
        this.name2Properties.clear();
        this.allProperties = null;
    }

    public String getProperty(String name, String key) throws CoreException, IOException {
        Properties properties = this.getOrCreateProperties(name);
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    private Properties getOrCreateProperties(String name) throws CoreException, IOException {
        Properties properties = (Properties)this.name2Properties.get(name);
        if (properties == null) {
            boolean found = false;
            List containers = this.getPropertyContainers();
            Iterator it = containers.iterator();
            while (it.hasNext() && !found) {
                File container = (File)it.next();
                if (!container.exists() || !container.isDirectory()) continue;
                File[] members = container.listFiles();
                int i = 0;
                while (i < members.length && !found) {
                    if (members[i].isFile() && (String.valueOf(name) + ".properties").equals(members[i].getName())) {
                        properties = new Properties();
                        properties.load(members[i].toURL().openStream());
                        this.name2Properties.put(name, properties);
                        found = true;
                    }
                    ++i;
                }
            }
        }
        return properties;
    }

    public String getProperty(String key) throws CoreException, IOException {
        Properties[] properties;
        Properties[] propertiesArray = properties = this.getOrCreateProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Properties propertie = propertiesArray[n2];
            if (propertie != null && (value = propertie.getProperty(key)) != null) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private Properties[] getOrCreateProperties() throws CoreException, IOException {
        if (this.allProperties == null) {
            ArrayList<Properties> allPropertiesList = new ArrayList<Properties>();
            List containers = this.getPropertyContainers();
            for (File container : containers) {
                File[] members;
                if (!container.exists() || !container.isDirectory()) continue;
                File[] fileArray = members = container.listFiles();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    File member = fileArray[n2];
                    if (member.isFile() && member.getName() != null && member.getName().endsWith(".properties")) {
                        Properties properties = new Properties();
                        properties.load(member.toURL().openStream());
                        this.name2Properties.put(new Path(member.getName()).removeFileExtension().lastSegment(), properties);
                        allPropertiesList.add(properties);
                    }
                    ++n2;
                }
            }
            this.allProperties = allPropertiesList.toArray(new Properties[allPropertiesList.size()]);
        }
        return this.allProperties;
    }

    protected List getPropertyContainers() {
        ArrayList<File> result = new ArrayList<File>();
        if (this.chainFile != null && this.chainFile.getParentFile() != null) {
            result.add(this.chainFile.getParentFile());
        }
        if (this.file != null && this.file.getParentFile() != null) {
            File file;
            URL url;
            Bundle bundle;
            String pluginId;
            result.add(this.file.getParentFile());
            File project = null;
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.file.getAbsolutePath()));
            if (workspaceFile != null && workspaceFile.isAccessible()) {
                project = workspaceFile.getProject().getLocation().toFile();
            }
            if ((pluginId = AcceleoModuleProvider.getDefault().getPluginId(this.file)) != null && (bundle = Platform.getBundle((String)pluginId)) != null && (url = bundle.getEntry("/")) != null && (file = new File(Resources.transformToAbsolutePath(url))).exists()) {
                project = file;
            }
            if (project != null && project.exists()) {
                File parent = this.file.getParentFile().getParentFile();
                while (parent != null && parent.exists()) {
                    result.add(parent);
                    if (parent.equals(project)) break;
                    parent = parent.getParentFile();
                }
            }
        }
        return result;
    }

    @Override
    public boolean validateCall(TemplateCallExpression call) {
        return "".equals(call.getPrefix()) || TemplateConstants.LINK_PREFIX_SCRIPT.equals(call.getPrefix());
    }

    public void setInitProfiling(boolean initProfiling) {
        this.initProfiling = initProfiling;
    }
}

