/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ClassifierExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;

public class InterfacePkgExt {
    public static Component getRootComponent(InterfacePkg interfacePkg) {
        Component comp = null;
        if (interfacePkg != null) {
            EObject container = interfacePkg.eContainer();
            if (container instanceof InterfacePkg) {
                comp = InterfacePkgExt.getRootComponent((InterfacePkg)container);
            } else if (container instanceof Structure) {
                comp = StructureExt.getRootComponent((Structure)container);
            } else if (container instanceof Component) {
                comp = (Component)container;
            }
        }
        return comp;
    }

    public static List<Interface> getOwnedInterfacesFromParentHierarchy(InterfacePkg interfacePkg) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        if (interfacePkg != null) {
            Component parentComp;
            BlockArchitecture compArch = InterfacePkgExt.getRootBlockArchitecture((ModelElement)interfacePkg);
            if (compArch != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(compArch.getOwnedInterfacePkg()));
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = InterfacePkgExt.getRootComponent(interfacePkg)) != null) {
                list.addAll(InterfacePkgExt.getAllInterfaces(parentComp.getOwnedInterfacePkg()));
                list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromComponentParent(Component component) {
        return InterfacePkgExt.getOwnedInterfacesFromComponentParent(component, false);
    }

    public static List<Interface> getOwnedInterfacesFromComponentParent(Component component, boolean isLayerVisibilityRequired) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        EObject container = component.eContainer();
        if (isLayerVisibilityRequired) {
            if (container instanceof SystemComponent && !((SystemComponent)container).isActor()) {
                return list;
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
        }
        if (container instanceof Component) {
            list.addAll(InterfacePkgExt.getAllInterfaces(((Component)container).getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent((Component)container, isLayerVisibilityRequired));
        } else if (container instanceof BlockArchitecture) {
            list.addAll(InterfacePkgExt.getAllInterfaces(((BlockArchitecture)container).getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent((BlockArchitecture)container, isLayerVisibilityRequired));
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromComponentArchitectureParent(ComponentArchitecture compArch) {
        return InterfacePkgExt.getOwnedInterfacesFromComponentArchitectureParent(compArch, false);
    }

    public static List<Interface> getOwnedInterfacesFromBlockArchitectureParent(BlockArchitecture compArch) {
        return InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(compArch, false);
    }

    public static List<Interface> getOwnedInterfacesFromComponentArchitectureParent(ComponentArchitecture compArch, boolean isLayerVisibilityRequired) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        EObject container = compArch.eContainer();
        if (isLayerVisibilityRequired) {
            if (container instanceof SystemComponent && !((SystemComponent)container).isActor()) {
                return list;
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
        }
        if (container instanceof Component) {
            if (container instanceof LogicalComponent) {
                list.addAll(InterfacePkgExt.getAllInterfaces(((LogicalComponent)container).getOwnedInterfacePkg()));
            }
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent((Component)container, isLayerVisibilityRequired));
        } else if (container instanceof ComponentArchitecture) {
            list.addAll(InterfacePkgExt.getAllInterfaces(((ComponentArchitecture)container).getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentArchitectureParent((ComponentArchitecture)container, isLayerVisibilityRequired));
        }
        return list;
    }

    public static List<Interface> getOwnedInterfacesFromBlockArchitectureParent(BlockArchitecture compArch, boolean isLayerVisibilityRequired) {
        ArrayList<Interface> list = new ArrayList<Interface>(1);
        EObject container = compArch.eContainer();
        if (isLayerVisibilityRequired) {
            if (container instanceof SystemComponent && !((SystemComponent)container).isActor()) {
                return list;
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
        }
        if (container instanceof Component) {
            list.addAll(InterfacePkgExt.getAllInterfaces(((Component)container).getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromComponentParent((Component)container, isLayerVisibilityRequired));
        } else if (container instanceof BlockArchitecture) {
            list.addAll(InterfacePkgExt.getAllInterfaces(((BlockArchitecture)container).getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent((BlockArchitecture)container, isLayerVisibilityRequired));
        }
        return list;
    }

    public static ComponentArchitecture getRootComponentArchitecture(InterfacePkg interfacePkg) {
        ComponentArchitecture compArchitecture = null;
        if (interfacePkg != null) {
            EObject container = interfacePkg.eContainer();
            if (container instanceof ComponentArchitecture) {
                compArchitecture = (ComponentArchitecture)container;
            } else if (container instanceof InterfacePkg) {
                compArchitecture = InterfacePkgExt.getRootComponentArchitecture((InterfacePkg)container);
            } else if (container instanceof Structure) {
                compArchitecture = StructureExt.getRootComponentArchitecture((Structure)container);
            } else if (container instanceof Component) {
                compArchitecture = ComponentExt.getRootComponentArchitecture((Component)container);
            }
        }
        return compArchitecture;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        BlockArchitecture arch = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof BlockArchitecture) {
                return (BlockArchitecture)container;
            }
            if (container instanceof Component) {
                arch = ComponentExt.getRootBlockArchitecture((ModelElement)((Component)container));
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootBlockArchitecture((Structure)container);
            } else if (container instanceof Classifier) {
                arch = ClassifierExt.getRootBlockArchitecture((ModelElement)((Classifier)container));
            } else {
                EObject container2 = container.eContainer();
                if (container2 != null) {
                    arch = InterfacePkgExt.getRootBlockArchitecture((ModelElement)container2);
                }
            }
        }
        return arch;
    }

    public static InterfacePkg getRootInterfacePkg(InterfacePkg interfacePkg) {
        if (interfacePkg.eContainer() instanceof InterfacePkg) {
            return InterfacePkgExt.getRootInterfacePkg((InterfacePkg)interfacePkg.eContainer());
        }
        return interfacePkg;
    }

    public static List<Interface> getAllInterfaces(InterfacePkg interfacePkg) {
        ArrayList<Interface> interfaceList = new ArrayList<Interface>();
        if (interfacePkg != null) {
            interfaceList.addAll((Collection<Interface>)interfacePkg.getOwnedInterfaces());
            for (InterfacePkg subInterfacePkg : interfacePkg.getOwnedInterfacePkgs()) {
                interfaceList.addAll(InterfacePkgExt.getAllInterfaces(subInterfacePkg));
            }
        }
        return interfaceList;
    }

    public static List<Interface> getAllInterfacesFiltered(InterfacePkg interfacePkg, Component component, boolean usedFlag) {
        ArrayList<Interface> interfaceList = new ArrayList<Interface>();
        if (interfacePkg != null) {
            for (Interface inter : interfacePkg.getOwnedInterfaces()) {
                if (component != null && (usedFlag ? ComponentExt.isUsingInterface(component, inter) : ComponentExt.isImplementingInterface(component, inter))) continue;
                interfaceList.add(inter);
            }
            for (InterfacePkg subInterfacePkg : interfacePkg.getOwnedInterfacePkgs()) {
                interfaceList.addAll(InterfacePkgExt.getAllInterfacesFiltered(subInterfacePkg, component, usedFlag));
            }
        }
        return interfaceList;
    }

    public static List<InterfacePkg> getAllInterfacePkgs(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_INTERFACE_PCKS, (Object)context);
    }

    public static List<InterfacePkg> getRecursiveSubInterfacePkgs(InterfacePkg interfacePkg) {
        ArrayList<InterfacePkg> returnedList = new ArrayList<InterfacePkg>();
        returnedList.addAll((Collection<InterfacePkg>)interfacePkg.getOwnedInterfacePkgs());
        for (InterfacePkg aSubPkg : interfacePkg.getOwnedInterfacePkgs()) {
            returnedList.addAll(InterfacePkgExt.getRecursiveSubInterfacePkgs(aSubPkg));
        }
        return returnedList;
    }

    public static Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> getInterfacePkgDependenciesHierarchy2(InterfacePkg interfacePkg) {
        HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result = new HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>>();
        Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> tmp = null;
        for (Interface anInterface : interfacePkg.getOwnedInterfaces()) {
            tmp = InterfaceExt.getInterfaceDependencies2(anInterface);
            for (Map.Entry<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> entry : tmp.entrySet()) {
                if (!result.containsKey(entry.getKey())) {
                    HashSet col = new HashSet();
                    result.put(entry.getKey(), col);
                }
                ((Collection)result.get(entry.getKey())).addAll(entry.getValue());
            }
        }
        for (AbstractExchangeItem anExchangeItem : interfacePkg.getOwnedExchangeItems()) {
            InterfacePkgExt.addToResultMap((EObject)anExchangeItem, ExchangeItemExt.getExchangeItemDependencies2((AbstractExchangeItem)anExchangeItem), result);
        }
        for (InterfacePkg aSubPkg : interfacePkg.getOwnedInterfacePkgs()) {
            tmp = InterfacePkgExt.getInterfacePkgDependenciesHierarchy2(aSubPkg);
            for (Map.Entry<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> entry : tmp.entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Collection)result.get(entry.getKey())).addAll(entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private static void addToResultMap(EObject tgt, Map<AbstractDependenciesPkg, Collection<EObject>> map, Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result) {
        Couple couple = null;
        HashSet col = null;
        if (map != null) {
            for (Map.Entry<AbstractDependenciesPkg, Collection<EObject>> entry : map.entrySet()) {
                if (!result.containsKey(entry.getKey())) {
                    col = new HashSet();
                    result.put(entry.getKey(), col);
                }
                couple = new Couple((Object)tgt, entry.getValue());
                result.get(entry.getKey()).add((Couple<EObject, Collection<EObject>>)couple);
            }
        }
    }

    private static Collection<AbstractDependenciesPkg> getInterfacePkgDependenciesHierarchy(InterfacePkg interfacePkg, int hierarchy) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        HashSet<AbstractDependenciesPkg> dependenciesHierarchy = new HashSet<AbstractDependenciesPkg>();
        for (Interface anInterface : interfacePkg.getOwnedInterfaces()) {
            dependencies.addAll(InterfaceExt.getInterfaceDependencies(anInterface));
        }
        for (ExchangeItem anExchangeItem : interfacePkg.getOwnedExchangeItems()) {
            dependencies.addAll(ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem));
        }
        for (AbstractDependenciesPkg aPackage : dependencies) {
            int i = hierarchy;
            AbstractDependenciesPkg dependentPackage = aPackage;
            InterfacePkg currentPackage = interfacePkg;
            while (i > 0 && dependentPackage.eContainer() instanceof InterfacePkg && !EcoreUtil.isAncestor((EObject)dependentPackage.eContainer(), (EObject)currentPackage) && !EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage.eContainer())) {
                dependentPackage = (AbstractDependenciesPkg)dependentPackage.eContainer();
                currentPackage = (AbstractDependenciesPkg)currentPackage.eContainer();
                --i;
            }
            while (i > 0) {
                currentPackage = (AbstractDependenciesPkg)currentPackage.eContainer();
                --i;
            }
            if (EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage) || EcoreUtil.isAncestor((EObject)dependentPackage, (EObject)currentPackage) || currentPackage.equals(dependentPackage)) continue;
            dependenciesHierarchy.add(dependentPackage);
        }
        for (InterfacePkg aSubPkg : interfacePkg.getOwnedInterfacePkgs()) {
            dependenciesHierarchy.addAll(InterfacePkgExt.getInterfacePkgDependenciesHierarchy(aSubPkg, hierarchy + 1));
        }
        return dependenciesHierarchy;
    }

    public static Collection<AbstractDependenciesPkg> getInterfacePkgDependencies(InterfacePkg interfacePkg) {
        HashSet<AbstractDependenciesPkg> returnedDependencies = new HashSet<AbstractDependenciesPkg>();
        if (interfacePkg.eContainer() instanceof InterfacePkg) {
            return InterfacePkgExt.getInterfacePkgDependenciesHierarchy(interfacePkg, 0);
        }
        Iterator<AbstractDependenciesPkg> iterator = InterfacePkgExt.getInterfacePkgDependenciesHierarchy(interfacePkg, 0).iterator();
        while (iterator.hasNext()) {
            AbstractDependenciesPkg aDependentPackage;
            AbstractDependenciesPkg currentDependentPkg = aDependentPackage = iterator.next();
            returnedDependencies.add(currentDependentPkg);
            while (aDependentPackage.eContainer() instanceof InterfacePkg) {
                aDependentPackage = (AbstractDependenciesPkg)aDependentPackage.eContainer();
                returnedDependencies.add(aDependentPackage);
            }
        }
        return returnedDependencies;
    }

    public static boolean isInInterfacePkg(AbstractExchangeItem sourceElement) {
        EObject container = sourceElement.eContainer();
        while (container != null) {
            if (container instanceof InterfacePkg) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    public static boolean isPrimitiveDependency(InterfacePkg src, AbstractDependenciesPkg tar) {
        for (Interface anInterface : src.getOwnedInterfaces()) {
            if (!InterfaceExt.getInterfaceDependencies(anInterface).contains(tar)) continue;
            return true;
        }
        for (ExchangeItem anExchangeItem : src.getOwnedExchangeItems()) {
            if (!ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem).contains(tar)) continue;
            return true;
        }
        return false;
    }

    public static Collection<AbstractDependenciesPkg> getInterfacePkgDependenciesHierarchy(InterfacePkg interfacePkg) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        for (Interface anInterface : interfacePkg.getOwnedInterfaces()) {
            dependencies.addAll(InterfaceExt.getInterfaceDependencies(anInterface));
        }
        for (ExchangeItem anExchangeItem : interfacePkg.getOwnedExchangeItems()) {
            dependencies.addAll(ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem));
        }
        Iterator iterator = dependencies.iterator();
        block2: while (iterator.hasNext()) {
            AbstractDependenciesPkg aPackage;
            AbstractDependenciesPkg dependentPackage = aPackage = (AbstractDependenciesPkg)iterator.next();
            InterfacePkg currentPackage = interfacePkg;
            while (dependentPackage instanceof AbstractDependenciesPkg && !EcoreUtil.isAncestor((EObject)dependentPackage, (EObject)currentPackage) && !EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage)) {
                if (!(dependentPackage.eContainer() instanceof AbstractDependenciesPkg)) continue block2;
                dependencies.add(dependentPackage);
                dependentPackage = (AbstractDependenciesPkg)dependentPackage.eContainer();
            }
        }
        for (InterfacePkg aSubPkg : interfacePkg.getOwnedInterfacePkgs()) {
            dependencies.addAll(InterfacePkgExt.getInterfacePkgDependenciesHierarchy(aSubPkg));
        }
        return dependencies;
    }

    public static Collection<InterfacePkg> getAllInterfacePkgsInCurrentBlockArchitectures(EObject context) {
        HashSet<InterfacePkg> result = new HashSet<InterfacePkg>();
        BlockArchitecture aArchitecture = BlockArchitectureExt.getRootBlockArchitecture(context);
        for (EObject intefacePkg : EObjectExt.getAll((EObject)aArchitecture, (EClass)CsPackage.Literals.INTERFACE_PKG)) {
            result.add((InterfacePkg)intefacePkg);
        }
        return result;
    }
}

