/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Union;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.data.information.communication.Exception;
import org.polarsys.capella.core.data.information.communication.Message;
import org.polarsys.capella.core.data.information.communication.Signal;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.sharedmodel.SharedPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.ClassifierExt;
import org.polarsys.capella.core.model.helpers.CollectionExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.DataTypeExt;
import org.polarsys.capella.core.model.helpers.DataValueExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SignalExt;
import org.polarsys.capella.core.model.helpers.StructureExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.model.utils.ListExt;

public class DataPkgExt {
    private DataPkgExt() {
    }

    public static List<Class> getAllClasses(DataPkg dataPkg) {
        ArrayList<Class> list = new ArrayList<Class>();
        if (dataPkg != null) {
            list.addAll((Collection<Class>)dataPkg.getOwnedClasses());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllClasses(subDataPkg));
            }
        }
        return list;
    }

    public static Set<Association> getAllInvolvedAssociations(DataPkg dataPkg) {
        HashSet<Association> set = new HashSet<Association>();
        List<Class> allClasses = DataPkgExt.getAllClasses(dataPkg);
        for (Class clazz : allClasses) {
            set.addAll(ClassExt.getAllAssociations((Classifier)clazz));
        }
        return set;
    }

    public static List<Association> getAllAssociations(DataPkg dataPkg) {
        ArrayList<Association> list = new ArrayList<Association>();
        if (dataPkg != null) {
            list.addAll((Collection<Association>)dataPkg.getOwnedAssociations());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllAssociations(subDataPkg));
            }
        }
        return list;
    }

    public static List<EObject> getAllClassifierFromDataPkg(DataPkg dataPkg) {
        List<EObject> list = new ArrayList<EObject>();
        if (dataPkg != null) {
            list.addAll(DataPkgExt.getAllClasses(dataPkg));
            list.addAll(DataPkgExt.getAllMessages(dataPkg));
            list.addAll(DataPkgExt.getAllDataTypes(dataPkg));
            list.addAll(DataPkgExt.getAllExceptions(dataPkg));
            list = ListExt.removeDuplicates(list);
        }
        return list;
    }

    public static List<org.polarsys.capella.core.data.information.Collection> getAllCollections(DataPkg dataPkg) {
        ArrayList<org.polarsys.capella.core.data.information.Collection> list = new ArrayList<org.polarsys.capella.core.data.information.Collection>();
        if (dataPkg != null) {
            list.addAll((Collection<org.polarsys.capella.core.data.information.Collection>)dataPkg.getOwnedCollections());
            for (DataPkg subDataTypePkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllCollections(subDataTypePkg));
            }
        }
        return list;
    }

    public static boolean isAncestorPackage(DataPkg sourcePackage, DataPkg targetPackage) {
        boolean isAncestor = false;
        if (!sourcePackage.equals(targetPackage) && EcoreUtil.isAncestor((EObject)sourcePackage, (EObject)targetPackage)) {
            isAncestor = true;
        }
        return isAncestor;
    }

    public static Set<Generalization> getAllGeneralization(DataPkg dataPkg) {
        HashSet<Generalization> generalizations = new HashSet<Generalization>();
        if (dataPkg != null) {
            ArrayList classifiers = new ArrayList();
            classifiers.addAll(dataPkg.getOwnedClasses());
            classifiers.addAll(dataPkg.getOwnedCollections());
            classifiers.addAll(dataPkg.getOwnedDataTypes());
            for (GeneralizableElement generalizableElement : classifiers) {
                generalizations.addAll((Collection<Generalization>)generalizableElement.getOwnedGeneralizations());
            }
        }
        return generalizations;
    }

    public static List<DataPkg> getAllDataPkgs(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_DATA_PCK, (Object)context);
    }

    public static List<DataPkg> getAllDataPkgsInCurrentBlockArchitectures(EObject context) {
        ArrayList<DataPkg> returnedList = new ArrayList<DataPkg>();
        BlockArchitecture aArchitecture = BlockArchitectureExt.getRootBlockArchitecture(context);
        for (EObject aDataPkg : EObjectExt.getAll((EObject)aArchitecture, (EClass)InformationPackage.Literals.DATA_PKG)) {
            returnedList.add((DataPkg)aDataPkg);
        }
        return returnedList;
    }

    public static List<DataType> getAllDataTypes(DataPkg dataPkg) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        if (dataPkg != null) {
            list.addAll((Collection<DataType>)dataPkg.getOwnedDataTypes());
            for (DataPkg subDataTypePkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllDataTypes(subDataTypePkg));
            }
        }
        return list;
    }

    public static List<DataType> getAllDataTypesFromParent(DataPkg dataPkg) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        if (dataPkg != null) {
            SystemEngineering sysEng;
            DataPkg pkg;
            BlockArchitecture arch = StructureExt.getRootBlockArchitecture((Structure)dataPkg);
            if (arch != null && (pkg = DataPkgExt.getDataPkgOfBlockArchitecture(arch)) != null) {
                list.addAll(DataPkgExt.getAllDataTypes(pkg));
            }
            if ((sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)dataPkg)) != null) {
                for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((CapellaElement)dataPkg)) {
                    if (sharedPkg.getOwnedDataPkg() == null) continue;
                    list.addAll(DataPkgExt.getAllDataTypes(sharedPkg.getOwnedDataPkg()));
                }
            }
        }
        return list;
    }

    public static List<DataValue> getAllDataValues(DataPkg dataPkg) {
        ArrayList<DataValue> list = new ArrayList<DataValue>();
        if (dataPkg != null) {
            list.addAll((Collection<DataValue>)dataPkg.getOwnedDataValues());
            for (DataPkg subPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllDataValues(subPkg));
            }
        }
        return list;
    }

    public static List<DataValue> getAllDataValuesFromParent(DataPkg dataPkg) {
        ArrayList<DataValue> list = new ArrayList<DataValue>();
        if (dataPkg != null) {
            SystemEngineering sysEng;
            DataPkg pkg;
            BlockArchitecture arch = StructureExt.getRootBlockArchitecture((Structure)dataPkg);
            if (arch != null && (pkg = DataPkgExt.getDataPkgOfBlockArchitecture(arch)) != null) {
                list.addAll(DataPkgExt.getAllDataValues(pkg));
            }
            if ((sysEng = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)dataPkg)) != null) {
                for (SharedPkg sharedPkg : SystemEngineeringExt.getSharedPkgs((CapellaElement)dataPkg)) {
                    list.addAll(DataPkgExt.getAllDataValues(sharedPkg.getOwnedDataPkg()));
                }
            }
        }
        return list;
    }

    public static List<Exception> getAllExceptions(DataPkg dataPkg) {
        ArrayList<Exception> list = new ArrayList<Exception>();
        if (dataPkg != null) {
            list.addAll((Collection<Exception>)dataPkg.getOwnedExceptions());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllExceptions(subDataPkg));
            }
        }
        return list;
    }

    public static List<Message> getAllMessages(DataPkg dataPkg) {
        ArrayList<Message> list = new ArrayList<Message>();
        if (dataPkg != null) {
            list.addAll((Collection<Message>)dataPkg.getOwnedMessages());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllMessages(subDataPkg));
            }
        }
        return list;
    }

    public static List<Signal> getAllSignals(DataPkg dataPkg) {
        ArrayList<Signal> list = new ArrayList<Signal>();
        if (dataPkg != null) {
            list.addAll((Collection<Signal>)dataPkg.getOwnedSignals());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllSignals(subDataPkg));
            }
        }
        return list;
    }

    public static List<EObject> getAllTypesFromDataPkg(DataPkg dataPkg) {
        List<EObject> list = new ArrayList<EObject>();
        if (dataPkg != null) {
            list.addAll(DataPkgExt.getAllClasses(dataPkg));
            list.addAll(DataPkgExt.getAllCollections(dataPkg));
            list.addAll(DataPkgExt.getAllDataTypes(dataPkg));
            list = ListExt.removeDuplicates(list);
        }
        return list;
    }

    public static List<EObject> getAllTypesFromDataPkgForPropsNParams(DataPkg dataPkg) {
        List<EObject> list = new ArrayList<EObject>();
        if (dataPkg != null) {
            list.addAll(DataPkgExt.getAllClasses(dataPkg));
            list.addAll(DataPkgExt.getAllCollections(dataPkg));
            list.addAll(DataPkgExt.getAllDataTypes(dataPkg));
            list = ListExt.removeDuplicates(list);
        }
        return list;
    }

    public static List<Union> getAllUnions(DataPkg dataPkg) {
        ArrayList<Union> list = new ArrayList<Union>();
        if (dataPkg != null) {
            EList ownedClasses = dataPkg.getOwnedClasses();
            for (Class class1 : ownedClasses) {
                if (!(class1 instanceof Union)) continue;
                list.add((Union)class1);
            }
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllUnions(subDataPkg));
            }
        }
        return list;
    }

    public static List<Unit> getAllUnits(DataPkg dataPkg) {
        ArrayList<Unit> list = new ArrayList<Unit>();
        if (dataPkg != null) {
            list.addAll((Collection<Unit>)dataPkg.getOwnedUnits());
            for (DataPkg subDataPkg : dataPkg.getOwnedDataPkgs()) {
                list.addAll(DataPkgExt.getAllUnits(subDataPkg));
            }
        }
        return list;
    }

    private static List<Class> getClassesFromBlockArchitectureParent(BlockArchitecture compArch) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        EObject container = compArch.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            DataPkg dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromComponentParent((Component)container));
        } else if (container instanceof BlockArchitecture) {
            BlockArchitecture arch = (BlockArchitecture)container;
            DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(arch);
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromBlockArchitectureParent((BlockArchitecture)container));
        }
        return list;
    }

    private static List<Class> getClassesFromComponentArchitectureParent(ComponentArchitecture compArch) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        EObject container = compArch.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            DataPkg dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromComponentParent((Component)container));
        } else if (container instanceof ComponentArchitecture) {
            ComponentArchitecture arch = (ComponentArchitecture)container;
            DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(arch);
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromComponentArchitectureParent((ComponentArchitecture)container));
        }
        return list;
    }

    private static List<Class> getClassesFromComponentParent(Component component) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        EObject container = component.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            DataPkg dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromComponentParent((Component)container));
        } else if (container instanceof ComponentArchitecture) {
            ComponentArchitecture compArch = (ComponentArchitecture)container;
            DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllClasses(dataPkg));
            }
            list.addAll(DataPkgExt.getClassesFromComponentArchitectureParent((ComponentArchitecture)container));
        }
        return list;
    }

    public static List<Class> getClassesFromParentHierarchy(DataPkg classPkg) {
        ArrayList<Class> list = new ArrayList<Class>(1);
        if (classPkg != null) {
            Component parentComp;
            BlockArchitecture compArch = DataPkgExt.getRootBlockArchitecture((ModelElement)classPkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllClasses(dataPkg));
                }
                list.addAll(DataPkgExt.getClassesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = DataPkgExt.getRootComponent(classPkg)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllClasses(dataPkg));
                }
                list.addAll(DataPkgExt.getClassesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static Collection<AbstractDependenciesPkg> getDataPkgDependencies(DataPkg dataPkg) {
        HashSet<AbstractDependenciesPkg> returnedDependencies = new HashSet<AbstractDependenciesPkg>();
        if (dataPkg.eContainer() instanceof DataPkg) {
            return DataPkgExt.getDataPkgDependenciesHierarchy(dataPkg, 0);
        }
        for (AbstractDependenciesPkg aDependentPackage : DataPkgExt.getDataPkgDependenciesHierarchy(dataPkg, 0)) {
            returnedDependencies.add(aDependentPackage);
            while (aDependentPackage.eContainer() instanceof DataPkg) {
                aDependentPackage = (AbstractDependenciesPkg)aDependentPackage.eContainer();
                returnedDependencies.add(aDependentPackage);
            }
        }
        return returnedDependencies;
    }

    private static void addToResultMap(EObject tgt, Map<AbstractDependenciesPkg, Collection<EObject>> map, Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result) {
        if (map != null) {
            for (Map.Entry<AbstractDependenciesPkg, Collection<EObject>> entry : map.entrySet()) {
                if (!result.containsKey(entry.getKey())) {
                    result.put(entry.getKey(), new HashSet());
                }
                result.get(entry.getKey()).add((Couple<EObject, Collection<EObject>>)new Couple((Object)tgt, entry.getValue()));
            }
        }
    }

    public static Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> getDataPkgDependenciesHierarchy2(DataPkg dataPkg) {
        HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result = new HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>>();
        for (Class aClass : dataPkg.getOwnedClasses()) {
            DataPkgExt.addToResultMap((EObject)aClass, ClassExt.getClassDependencies2(aClass), result);
        }
        for (Signal aSignal : dataPkg.getOwnedSignals()) {
            DataPkgExt.addToResultMap((EObject)aSignal, SignalExt.getSignalDependencies2(aSignal), result);
        }
        for (DataType aDataType : dataPkg.getOwnedDataTypes()) {
            DataPkgExt.addToResultMap((EObject)aDataType, DataTypeExt.getDataTypeDependencies2(aDataType), result);
        }
        for (DataValue aDataValue : dataPkg.getOwnedDataValues()) {
            DataPkgExt.addToResultMap((EObject)aDataValue, DataValueExt.getDataValueDependencies2(aDataValue), result);
        }
        for (ExchangeItem anExchangeItem : dataPkg.getOwnedExchangeItems()) {
            DataPkgExt.addToResultMap((EObject)anExchangeItem, ExchangeItemExt.getExchangeItemDependencies2((AbstractExchangeItem)anExchangeItem), result);
        }
        for (org.polarsys.capella.core.data.information.Collection aCollection : dataPkg.getOwnedCollections()) {
            DataPkgExt.addToResultMap((EObject)aCollection, CollectionExt.getCollectionDependencies2(aCollection), result);
        }
        Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> tmp = null;
        for (DataPkg aSubPkg : dataPkg.getOwnedDataPkgs()) {
            tmp = DataPkgExt.getDataPkgDependenciesHierarchy2(aSubPkg);
            for (Map.Entry<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> entry : tmp.entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Collection)result.get(entry.getKey())).addAll(entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private static Collection<AbstractDependenciesPkg> getDataPkgDependenciesHierarchy(DataPkg dataPkg, int hierarchy) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        HashSet<AbstractDependenciesPkg> dependenciesHierarchy = new HashSet<AbstractDependenciesPkg>();
        for (Class aClass : dataPkg.getOwnedClasses()) {
            dependencies.addAll(ClassExt.getClassDependencies(aClass));
        }
        for (Signal aSignal : dataPkg.getOwnedSignals()) {
            dependencies.addAll(SignalExt.getSignalDependencies(aSignal));
        }
        for (DataType aDataType : dataPkg.getOwnedDataTypes()) {
            dependencies.addAll(DataTypeExt.getDataTypeDependencies(aDataType));
        }
        for (DataValue aDataValue : dataPkg.getOwnedDataValues()) {
            dependencies.addAll(DataValueExt.getDataValueDependencies(aDataValue));
        }
        for (ExchangeItem anExchangeItem : dataPkg.getOwnedExchangeItems()) {
            dependencies.addAll(ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem));
        }
        for (org.polarsys.capella.core.data.information.Collection aCollection : dataPkg.getOwnedCollections()) {
            dependencies.addAll(CollectionExt.getCollectionDependencies(aCollection));
        }
        for (AbstractDependenciesPkg aPackage : dependencies) {
            int i = hierarchy;
            AbstractDependenciesPkg dependentPackage = aPackage;
            DataPkg currentPackage = dataPkg;
            while (i > 0 && dependentPackage.eContainer() instanceof DataPkg && !EcoreUtil.isAncestor((EObject)dependentPackage.eContainer(), (EObject)currentPackage) && !EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage.eContainer())) {
                dependentPackage = (AbstractDependenciesPkg)dependentPackage.eContainer();
                currentPackage = (AbstractDependenciesPkg)currentPackage.eContainer();
                --i;
            }
            while (i > 0) {
                currentPackage = (AbstractDependenciesPkg)currentPackage.eContainer();
                --i;
            }
            if (EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage) || EcoreUtil.isAncestor((EObject)dependentPackage, (EObject)currentPackage) || currentPackage.equals(dependentPackage)) continue;
            dependenciesHierarchy.add(dependentPackage);
        }
        for (DataPkg aSubPkg : dataPkg.getOwnedDataPkgs()) {
            dependenciesHierarchy.addAll(DataPkgExt.getDataPkgDependenciesHierarchy(aSubPkg, hierarchy + 1));
        }
        return dependenciesHierarchy;
    }

    public static DataPkg getDataPkgOfBlockArchitecture(BlockArchitecture architecture) {
        if (architecture instanceof OperationalAnalysis) {
            return ((OperationalAnalysis)architecture).getOwnedDataPkg();
        }
        if (architecture instanceof SystemAnalysis) {
            return ((SystemAnalysis)architecture).getOwnedDataPkg();
        }
        if (architecture instanceof LogicalArchitecture) {
            return ((LogicalArchitecture)architecture).getOwnedDataPkg();
        }
        if (architecture instanceof PhysicalArchitecture) {
            return ((PhysicalArchitecture)architecture).getOwnedDataPkg();
        }
        if (architecture instanceof EPBSArchitecture) {
            return ((EPBSArchitecture)architecture).getOwnedDataPkg();
        }
        return null;
    }

    public static DataPkg getDataPkgOfComponentArchitecture(ComponentArchitecture componentArchitecture) {
        DataPkg dataPkg = null;
        if (componentArchitecture instanceof SystemEngineering) {
            SystemAnalysis ca = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)componentArchitecture);
            dataPkg = ca.getOwnedDataPkg();
        } else if (componentArchitecture instanceof SystemAnalysis) {
            dataPkg = ((SystemAnalysis)componentArchitecture).getOwnedDataPkg();
        } else if (componentArchitecture instanceof LogicalArchitecture) {
            dataPkg = ((LogicalArchitecture)componentArchitecture).getOwnedDataPkg();
        } else if (componentArchitecture instanceof PhysicalArchitecture) {
            dataPkg = ((PhysicalArchitecture)componentArchitecture).getOwnedDataPkg();
        } else if (componentArchitecture instanceof EPBSArchitecture) {
            dataPkg = ((EPBSArchitecture)componentArchitecture).getOwnedDataPkg();
        }
        return dataPkg;
    }

    public static List<DataPkg> getDataPkgsFromBlockArchitectureParent(BlockArchitecture blockArch) {
        DataPkg dataPkg;
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        EObject container = blockArch.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            list.addAll(DataPkgExt.getDataPkgsFromComponentParent((Component)container));
        }
        if (container instanceof BlockArchitecture) {
            BlockArchitecture compArch = (BlockArchitecture)container;
            dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
            list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent((BlockArchitecture)container));
        }
        return list;
    }

    public static List<DataPkg> getDataPkgsFromComponentArchitectureParent(ComponentArchitecture compArch) {
        DataPkg dataPkg;
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        EObject container = compArch.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            list.addAll(DataPkgExt.getDataPkgsFromComponentParent((Component)container));
        }
        if (container instanceof ComponentArchitecture) {
            ComponentArchitecture arch = (ComponentArchitecture)container;
            dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(arch);
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
            list.addAll(DataPkgExt.getDataPkgsFromComponentArchitectureParent((ComponentArchitecture)container));
        }
        return list;
    }

    public static List<DataPkg> getDataPkgsFromComponentParent(Component component) {
        DataPkg dataPkg;
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        EObject container = component.eContainer();
        if (container instanceof Component) {
            Component parentComp = (Component)container;
            dataPkg = parentComp.getOwnedDataPkg();
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            list.addAll(DataPkgExt.getDataPkgsFromComponentParent((Component)container));
        }
        if (container instanceof BlockArchitecture) {
            BlockArchitecture compArch = (BlockArchitecture)container;
            dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
            if (dataPkg != null) {
                list.add(dataPkg);
            }
            if (container instanceof SystemEngineering) {
                return list;
            }
            list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent((BlockArchitecture)container));
        }
        return list;
    }

    public static List<DataPkg> getDataPkgsFromParentHierarchy(DataPkg dataPkg) {
        ArrayList<DataPkg> list = new ArrayList<DataPkg>(1);
        if (dataPkg != null) {
            Component parentComp;
            BlockArchitecture blockArch = DataPkgExt.getRootBlockArchitecture((ModelElement)dataPkg);
            if (blockArch != null) {
                DataPkg pkg = DataPkgExt.getDataPkgOfBlockArchitecture(blockArch);
                if (pkg != null) {
                    list.add(pkg);
                }
                if (blockArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getDataPkgsFromBlockArchitectureParent(blockArch));
            }
            if ((parentComp = DataPkgExt.getRootComponent(dataPkg)) != null) {
                DataPkg pkg = parentComp.getOwnedDataPkg();
                if (pkg != null) {
                    list.add(pkg);
                }
                list.addAll(DataPkgExt.getDataPkgsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    private static List<Exception> getExceptionsFromBlockArchitectureParent(BlockArchitecture compArch) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        EObject container = compArch.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            DataPkg dataPkg = ((Component)container).getOwnedDataPkg();
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllExceptions(dataPkg));
            }
            list.addAll(DataPkgExt.getExceptionsFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof BlockArchitecture) {
                BlockArchitecture arch = (BlockArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(arch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                list.addAll(DataPkgExt.getExceptionsFromBlockArchitectureParent((BlockArchitecture)container));
            }
        }
        return list;
    }

    private static List<Exception> getExceptionsFromComponentArchitectureParent(ComponentArchitecture compArch) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        EObject container = compArch.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllExceptions(dataPkg));
            }
            list.addAll(DataPkgExt.getExceptionsFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof ComponentArchitecture) {
                ComponentArchitecture arch = (ComponentArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(arch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                list.addAll(DataPkgExt.getExceptionsFromComponentArchitectureParent((ComponentArchitecture)container));
            }
        }
        return list;
    }

    private static List<Exception> getExceptionsFromComponentParent(Component component) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        EObject container = component.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllExceptions(dataPkg));
            }
            list.addAll(DataPkgExt.getExceptionsFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof ComponentArchitecture) {
                ComponentArchitecture compArch = (ComponentArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                list.addAll(DataPkgExt.getExceptionsFromComponentArchitectureParent((ComponentArchitecture)container));
            }
        }
        return list;
    }

    public static List<Exception> getExceptionsFromParentHierarchy(DataPkg exceptionPkg) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        if (exceptionPkg != null) {
            Component parentComp;
            BlockArchitecture compArch = DataPkgExt.getRootBlockArchitecture((ModelElement)exceptionPkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getExceptionsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = DataPkgExt.getRootComponent(exceptionPkg)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                list.addAll(DataPkgExt.getExceptionsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Exception> getExceptionsFromParentHierarchy(InterfacePkg interfacePkg) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        if (interfacePkg != null) {
            Component parentComp;
            BlockArchitecture compArch = InterfacePkgExt.getRootBlockArchitecture((ModelElement)interfacePkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getExceptionsFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = InterfacePkgExt.getRootComponent(interfacePkg)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllExceptions(dataPkg));
                }
                list.addAll(DataPkgExt.getExceptionsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    private static List<Message> getMessagesFromBlockArchitectureParent(BlockArchitecture compArch) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        EObject container = compArch.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            DataPkg dataPkg = ((Component)container).getOwnedDataPkg();
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllMessages(dataPkg));
            }
            list.addAll(DataPkgExt.getMessagesFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof BlockArchitecture) {
                BlockArchitecture arch = (BlockArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(arch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                list.addAll(DataPkgExt.getMessagesFromBlockArchitectureParent((BlockArchitecture)container));
            }
        }
        return list;
    }

    private static List<Message> getMessagesFromComponentArchitectureParent(ComponentArchitecture compArch) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        EObject container = compArch.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllMessages(dataPkg));
            }
            list.addAll(DataPkgExt.getMessagesFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof ComponentArchitecture) {
                ComponentArchitecture arch = (ComponentArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(arch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                list.addAll(DataPkgExt.getMessagesFromComponentArchitectureParent((ComponentArchitecture)container));
            }
        }
        return list;
    }

    private static List<Message> getMessagesFromComponentParent(Component component) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        EObject container = component.eContainer();
        if (container instanceof System) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllMessages(dataPkg));
            }
            list.addAll(DataPkgExt.getMessagesFromComponentParent((Component)container));
        } else {
            if (container instanceof SystemEngineering) {
                return list;
            }
            if (container instanceof ComponentArchitecture) {
                ComponentArchitecture compArch = (ComponentArchitecture)container;
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                list.addAll(DataPkgExt.getMessagesFromComponentArchitectureParent((ComponentArchitecture)container));
            }
        }
        return list;
    }

    public static List<Message> getMessagesFromParentHierarchy(DataPkg messagePkg) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        if (messagePkg != null) {
            Component parentComp;
            BlockArchitecture compArch = DataPkgExt.getRootBlockArchitecture((ModelElement)messagePkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getMessagesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = DataPkgExt.getRootComponent(messagePkg)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                list.addAll(DataPkgExt.getMessagesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Message> getMessagesFromParentHierarchy(InterfacePkg interfacePkg) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        if (interfacePkg != null) {
            Component parentComp;
            BlockArchitecture compArch = InterfacePkgExt.getRootBlockArchitecture((ModelElement)interfacePkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfBlockArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getMessagesFromBlockArchitectureParent(compArch));
            }
            if ((parentComp = InterfacePkgExt.getRootComponent(interfacePkg)) != null) {
                DataPkg dataPkg = parentComp.getOwnedDataPkg();
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllMessages(dataPkg));
                }
                list.addAll(DataPkgExt.getMessagesFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<DataPkg> getRecursiveSubDataPkgs(DataPkg dataPkg) {
        ArrayList<DataPkg> returnedList = new ArrayList<DataPkg>();
        returnedList.addAll((Collection<DataPkg>)dataPkg.getOwnedDataPkgs());
        for (DataPkg aSubPkg : dataPkg.getOwnedDataPkgs()) {
            returnedList.addAll(DataPkgExt.getRecursiveSubDataPkgs(aSubPkg));
        }
        return returnedList;
    }

    public static BlockArchitecture getRootBlockArchitecture(ModelElement modelElement) {
        BlockArchitecture arch = null;
        if (modelElement != null) {
            EObject container = modelElement.eContainer();
            if (container instanceof BlockArchitecture) {
                return (BlockArchitecture)container;
            }
            if (container instanceof Component) {
                arch = ComponentExt.getRootBlockArchitecture((ModelElement)((Component)container));
            } else if (container instanceof Structure) {
                arch = StructureExt.getRootBlockArchitecture((Structure)container);
            } else if (container instanceof Classifier) {
                arch = ClassifierExt.getRootBlockArchitecture((ModelElement)((Classifier)container));
            } else {
                EObject container2 = container.eContainer();
                if (container2 != null) {
                    arch = DataPkgExt.getRootBlockArchitecture((ModelElement)container2);
                }
            }
        }
        return arch;
    }

    public static Component getRootComponent(DataPkg dataPkg) {
        Component comp = null;
        if (dataPkg != null) {
            EObject container = dataPkg.eContainer();
            if (container instanceof DataPkg) {
                comp = DataPkgExt.getRootComponent((DataPkg)container);
            } else if (container instanceof Structure) {
                comp = StructureExt.getRootComponent((Structure)container);
            } else if (container instanceof Component) {
                comp = (Component)container;
            }
        }
        return comp;
    }

    public static ComponentArchitecture getRootComponentArchitecture(DataPkg dataPkg) {
        ComponentArchitecture compArchitecture = null;
        if (dataPkg != null) {
            EObject container = dataPkg.eContainer();
            if (container instanceof ComponentArchitecture) {
                compArchitecture = (ComponentArchitecture)container;
            } else if (container instanceof DataPkg) {
                compArchitecture = DataPkgExt.getRootComponentArchitecture((DataPkg)container);
            } else if (container instanceof Structure) {
                compArchitecture = StructureExt.getRootComponentArchitecture((Structure)container);
            } else if (container instanceof Component) {
                compArchitecture = ComponentExt.getRootComponentArchitecture((Component)container);
            }
        }
        return compArchitecture;
    }

    public static DataPkg getRootDataPkg(DataPkg exceptionPkg) {
        DataPkg rootPkg = null;
        if (exceptionPkg != null) {
            EObject container = exceptionPkg.eContainer();
            if (container instanceof DataPkg) {
                rootPkg = DataPkgExt.getRootDataPkg((DataPkg)container);
            } else {
                return exceptionPkg;
            }
        }
        return rootPkg;
    }

    private static List<Signal> getSignalsFromComponentArchitectureParent(ComponentArchitecture compArch) {
        return DataPkgExt.getSignalsFromComponentArchitectureParent(compArch, false);
    }

    private static List<Signal> getSignalsFromComponentArchitectureParent(ComponentArchitecture compArch, boolean isLayerVisibilityRequired) {
        ArrayList<Signal> list = new ArrayList<Signal>(1);
        EObject container = compArch.eContainer();
        if (isLayerVisibilityRequired && (container instanceof System || container instanceof SystemEngineering)) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllSignals(dataPkg));
            }
            list.addAll(DataPkgExt.getSignalsFromComponentParent((Component)container, isLayerVisibilityRequired));
        } else if (container instanceof ComponentArchitecture) {
            ComponentArchitecture arch = (ComponentArchitecture)container;
            DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(arch);
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllSignals(dataPkg));
            }
            list.addAll(DataPkgExt.getSignalsFromComponentArchitectureParent((ComponentArchitecture)container, isLayerVisibilityRequired));
        }
        return list;
    }

    private static List<Signal> getSignalsFromComponentParent(Component component) {
        return DataPkgExt.getSignalsFromComponentParent(component, false);
    }

    private static List<Signal> getSignalsFromComponentParent(Component component, boolean isLayerVisibilityRequired) {
        ArrayList<Signal> list = new ArrayList<Signal>(1);
        EObject container = component.eContainer();
        if (isLayerVisibilityRequired && (container instanceof System || container instanceof SystemEngineering)) {
            return list;
        }
        if (container instanceof Component) {
            LogicalComponent parentComp;
            DataPkg dataPkg;
            if (container instanceof LogicalComponent && (dataPkg = (parentComp = (LogicalComponent)container).getOwnedDataPkg()) != null) {
                list.addAll(DataPkgExt.getAllSignals(dataPkg));
            }
            list.addAll(DataPkgExt.getSignalsFromComponentParent((Component)container, isLayerVisibilityRequired));
        } else if (container instanceof ComponentArchitecture) {
            ComponentArchitecture compArch = (ComponentArchitecture)container;
            DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
            if (dataPkg != null) {
                list.addAll(DataPkgExt.getAllSignals(dataPkg));
            }
            list.addAll(DataPkgExt.getSignalsFromComponentArchitectureParent((ComponentArchitecture)container, isLayerVisibilityRequired));
        }
        return list;
    }

    public static List<Signal> getSignalsFromParentHierarchy(DataPkg signalPkg) {
        ArrayList<Signal> list = new ArrayList<Signal>(1);
        if (signalPkg != null) {
            Component parentComp;
            ComponentArchitecture compArch = DataPkgExt.getRootComponentArchitecture(signalPkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllSignals(dataPkg));
                }
                list.addAll(DataPkgExt.getSignalsFromComponentArchitectureParent(compArch));
            }
            if ((parentComp = DataPkgExt.getRootComponent(signalPkg)) != null) {
                DataPkg dataPkg;
                if (parentComp instanceof LogicalComponent && (dataPkg = ((LogicalComponent)parentComp).getOwnedDataPkg()) != null) {
                    list.addAll(DataPkgExt.getAllSignals(dataPkg));
                }
                list.addAll(DataPkgExt.getSignalsFromComponentParent(parentComp));
            }
        }
        return list;
    }

    public static List<Signal> getSignalsFromParentHierarchy(InterfacePkg interfacePkg) {
        ArrayList<Signal> list = new ArrayList<Signal>(1);
        if (interfacePkg != null) {
            Component parentComp;
            ComponentArchitecture compArch = InterfacePkgExt.getRootComponentArchitecture(interfacePkg);
            if (compArch != null) {
                DataPkg dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch);
                if (dataPkg != null) {
                    list.addAll(DataPkgExt.getAllSignals(dataPkg));
                }
                if (compArch instanceof SystemEngineering) {
                    return list;
                }
                list.addAll(DataPkgExt.getSignalsFromComponentArchitectureParent(compArch, true));
            }
            if ((parentComp = InterfacePkgExt.getRootComponent(interfacePkg)) != null) {
                DataPkg dataPkg;
                if (parentComp instanceof LogicalComponent && (dataPkg = ((LogicalComponent)parentComp).getOwnedDataPkg()) != null) {
                    list.addAll(DataPkgExt.getAllSignals(dataPkg));
                }
                list.addAll(DataPkgExt.getSignalsFromComponentParent(parentComp, true));
            }
        }
        return list;
    }

    public static boolean isBelongToSameDataPkgLayer(ModelElement elt1, ModelElement elt2) {
        return elt1 instanceof CapellaElement && elt2 instanceof CapellaElement && EcoreUtil2.isContainedBy((EObject)elt2, (EClass)InformationPackage.Literals.DATA_PKG) && CapellaLayerCheckingExt.getLayersName((CapellaElement)elt1) == CapellaLayerCheckingExt.getLayersName((CapellaElement)elt2);
    }

    public static DataPkg getParentDataPkg(CapellaElement capellaElement) {
        if (capellaElement != null) {
            if (capellaElement instanceof DataPkg) {
                return (DataPkg)capellaElement;
            }
            EObject eContainer = capellaElement.eContainer();
            if (eContainer instanceof CapellaElement) {
                return DataPkgExt.getParentDataPkg((CapellaElement)eContainer);
            }
        }
        return null;
    }

    public static DataPkg getFirstDataPkgOfRootBlockArchitecture(EObject eObject) {
        if (eObject != null) {
            BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture(eObject);
            DataPkgExt.getDataPkgOfBlockArchitecture(arch);
        }
        return null;
    }

    @Deprecated
    public static List<DataValue> getDataValues(List<DataPkg> listPackages) {
        ArrayList<DataValue> result = new ArrayList<DataValue>(1);
        for (DataPkg dataPkg : listPackages) {
            Iterator itDataValue = dataPkg.getOwnedDataValues().iterator();
            while (itDataValue.hasNext()) {
                result.add((DataValue)itDataValue.next());
            }
            for (DataType dataType : dataPkg.getOwnedDataTypes()) {
                result.addAll(DataTypeExt.getAllDataValuesFromDataType(dataType));
            }
        }
        return result;
    }

    public static List<DataValue> getDataValues(EObject semanticsObject) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_DATA_VALUES, (Object)semanticsObject);
    }

    public static boolean isPredefinedDataType(EObject element) {
        EObject parentDataPkg = EcoreUtil2.getFirstContainer((EObject)element, (EClass)InformationPackage.Literals.DATA_PKG);
        return parentDataPkg != null && ((DataPkg)parentDataPkg).getName().equals(NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name);
    }

    public static boolean isPrimitiveDependency(DataPkg src, AbstractDependenciesPkg tar) {
        for (Class aClass : src.getOwnedClasses()) {
            if (!ClassExt.getClassDependencies(aClass).contains(tar)) continue;
            return true;
        }
        for (Signal aSignal : src.getOwnedSignals()) {
            if (!SignalExt.getSignalDependencies(aSignal).contains(tar)) continue;
            return true;
        }
        for (DataType aDataType : src.getOwnedDataTypes()) {
            if (!DataTypeExt.getDataTypeDependencies(aDataType).contains(tar)) continue;
            return true;
        }
        for (DataValue aDataValue : src.getOwnedDataValues()) {
            if (!DataValueExt.getDataValueDependencies(aDataValue).contains(tar)) continue;
            return true;
        }
        for (ExchangeItem anExchangeItem : src.getOwnedExchangeItems()) {
            if (!ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem).contains(tar)) continue;
            return true;
        }
        for (org.polarsys.capella.core.data.information.Collection aCollection : src.getOwnedCollections()) {
            if (!CollectionExt.getCollectionDependencies(aCollection).contains(tar)) continue;
            return true;
        }
        return false;
    }

    public static Collection<AbstractDependenciesPkg> getDataPkgDependenciesHierarchy(DataPkg dataPkg) {
        HashSet<AbstractDependenciesPkg> dependencies = new HashSet<AbstractDependenciesPkg>();
        for (Class aClass : dataPkg.getOwnedClasses()) {
            dependencies.addAll(ClassExt.getClassDependencies(aClass));
        }
        for (Signal aSignal : dataPkg.getOwnedSignals()) {
            dependencies.addAll(SignalExt.getSignalDependencies(aSignal));
        }
        for (DataType aDataType : dataPkg.getOwnedDataTypes()) {
            dependencies.addAll(DataTypeExt.getDataTypeDependencies(aDataType));
        }
        for (DataValue aDataValue : dataPkg.getOwnedDataValues()) {
            dependencies.addAll(DataValueExt.getDataValueDependencies(aDataValue));
        }
        for (ExchangeItem anExchangeItem : dataPkg.getOwnedExchangeItems()) {
            dependencies.addAll(ExchangeItemExt.getExchangeItemDependencies((AbstractExchangeItem)anExchangeItem));
        }
        for (org.polarsys.capella.core.data.information.Collection aCollection : dataPkg.getOwnedCollections()) {
            dependencies.addAll(CollectionExt.getCollectionDependencies(aCollection));
        }
        HashSet currentDependencies = new HashSet(dependencies);
        Iterator iterator = currentDependencies.iterator();
        block6: while (iterator.hasNext()) {
            AbstractDependenciesPkg aPackage;
            AbstractDependenciesPkg dependentPackage = aPackage = (AbstractDependenciesPkg)iterator.next();
            DataPkg currentPackage = dataPkg;
            while (dependentPackage instanceof AbstractDependenciesPkg && !EcoreUtil.isAncestor((EObject)dependentPackage, (EObject)currentPackage) && !EcoreUtil.isAncestor((EObject)currentPackage, (EObject)dependentPackage)) {
                if (!(dependentPackage.eContainer() instanceof AbstractDependenciesPkg)) continue block6;
                dependencies.add(dependentPackage);
                dependentPackage = (AbstractDependenciesPkg)dependentPackage.eContainer();
            }
        }
        for (DataPkg aSubPkg : dataPkg.getOwnedDataPkgs()) {
            dependencies.addAll(DataPkgExt.getDataPkgDependenciesHierarchy(aSubPkg));
        }
        return dependencies;
    }
}

