/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;

public class ConstraintExt {
    public static final String OPAQUE_EXPRESSION_LINKED_TEXT = "capella:linkedText";

    public static String getBody(OpaqueExpression expression, String language) {
        if (!expression.getLanguages().contains((Object)language)) {
            return null;
        }
        int position = expression.getLanguages().indexOf((Object)language);
        if (position < expression.getBodies().size()) {
            return (String)expression.getBodies().get(position);
        }
        return null;
    }

    public Couple<String, String> getFirstOpaqueExpressionElement(EObject eObject) {
        if (!(eObject instanceof OpaqueExpression)) {
            return null;
        }
        OpaqueExpression oe = (OpaqueExpression)eObject;
        if (oe.getLanguages().isEmpty() || oe.getBodies().isEmpty()) {
            return null;
        }
        return new Couple((Object)((String)oe.getLanguages().get(0)), (Object)((String)oe.getBodies().get(0)));
    }

    public static boolean hasBodies(OpaqueExpression expression) {
        if (expression == null) {
            return false;
        }
        return !expression.getBodies().isEmpty();
    }

    public static boolean hasPrimaryLinkedText(OpaqueExpression expression) {
        if (expression == null) {
            return false;
        }
        if (expression.getLanguages().isEmpty()) {
            return false;
        }
        return OPAQUE_EXPRESSION_LINKED_TEXT.equals(expression.getLanguages().get(0));
    }

    public static String getPrimaryBody(OpaqueExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.getBodies().isEmpty()) {
            return null;
        }
        return (String)expression.getBodies().get(0);
    }

    public static void setBody(OpaqueExpression expression, String language, String body) {
        if (expression == null) {
            return;
        }
        if (!expression.getLanguages().contains((Object)language)) {
            expression.getLanguages().add((Object)language);
        }
        int position = expression.getLanguages().indexOf((Object)language);
        while (expression.getBodies().size() < position) {
            expression.getBodies().add((Object)"");
        }
        expression.getBodies().set(position, (Object)body);
    }
}

