/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UncategorizedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnmatchedTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnsubmittedTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.AbstractRetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskScheduleContentProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskDropListener;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.ui.PlatformUI;

public class TaskListDropAdapter
extends ViewerDropAdapter {
    private boolean fileTransfer;
    private boolean localTransfer;

    public TaskListDropAdapter(Viewer viewer) {
        super(viewer);
        this.setFeedbackEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean performDrop(Object data) {
        ArrayList<ITask> tasksToMove = new ArrayList<ITask>();
        if (this.localTransfer) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            List<ITask> list = TasksUiInternal.getTasksFromSelection(selection);
            tasksToMove.addAll(list);
        } else if (!this.fileTransfer && data instanceof String) {
            void var4_7;
            String text = (String)data;
            AbstractTask abstractTask = this.createTaskFromUrl(text);
            if (abstractTask == null) {
                LocalTask localTask = TasksUiInternal.createNewLocalTask(text);
            }
            if (var4_7 != null) {
                tasksToMove.add((ITask)var4_7);
                void newTask = var4_7;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable((ITask)newTask){
                    private final /* synthetic */ ITask val$newTask;
                    {
                        this.val$newTask = iTask;
                    }

                    @Override
                    public void run() {
                        TasksUiUtil.openTask(this.val$newTask);
                    }
                });
            }
        }
        Object currentTarget = this.getCurrentTarget();
        if (currentTarget instanceof LocalTask && this.areAllLocalTasks(tasksToMove) && this.getCurrentLocation() == 3) {
            for (ITask iTask : tasksToMove) {
                if (((AbstractTask)iTask).contains(((LocalTask)currentTarget).getHandleIdentifier())) continue;
                TasksUiInternal.getTaskList().addTask(iTask, (AbstractTaskContainer)((LocalTask)currentTarget));
            }
        } else if (currentTarget instanceof ITask && this.getCurrentLocation() == 3 && this.getCurrentOperation() != 2) {
            TasksUiInternal.getTaskDropHandler().loadTaskDropListeners();
            TaskDropListener.Operation operation = this.getCurrentOperation() == 1 ? TaskDropListener.Operation.COPY : TaskDropListener.Operation.LINK;
            TasksUiInternal.getTaskDropHandler().fireTaskDropped(tasksToMove, (ITask)currentTarget, operation);
        } else {
            for (ITask iTask : tasksToMove) {
                if (currentTarget instanceof UncategorizedTaskContainer) {
                    this.moveTask(iTask, (AbstractTaskContainer)((UncategorizedTaskContainer)currentTarget));
                    continue;
                }
                if (currentTarget instanceof TaskCategory) {
                    this.moveTask(iTask, (AbstractTaskContainer)((TaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof UnmatchedTaskContainer) {
                    if (!((UnmatchedTaskContainer)currentTarget).getRepositoryUrl().equals(iTask.getRepositoryUrl())) continue;
                    this.moveTask(iTask, (AbstractTaskContainer)((AbstractTaskCategory)currentTarget));
                    continue;
                }
                if (currentTarget instanceof ITask) {
                    ITask targetTask = (ITask)currentTarget;
                    TaskListView view = TaskListView.getFromActivePerspective();
                    if ((this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2) && view != null && view.isScheduledPresentation()) {
                        if (!(targetTask instanceof AbstractTask)) continue;
                        DateRange targetDate = ((AbstractTask)targetTask).getScheduledForDate();
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)iTask, targetDate);
                        continue;
                    }
                    AbstractTaskCategory targetCategory = null;
                    AbstractTaskCategory container = TaskCategory.getParentTaskCategory((ITask)targetTask);
                    if (container instanceof TaskCategory || container instanceof UncategorizedTaskContainer) {
                        targetCategory = container;
                    } else if (container instanceof UnmatchedTaskContainer && ((UnmatchedTaskContainer)container).getRepositoryUrl().equals(iTask.getRepositoryUrl())) {
                        targetCategory = container;
                    }
                    if (targetCategory == null) continue;
                    this.moveTask(iTask, (AbstractTaskContainer)targetCategory);
                    continue;
                }
                if (currentTarget instanceof ScheduledTaskContainer) {
                    ScheduledTaskContainer container = (ScheduledTaskContainer)currentTarget;
                    if (container instanceof TaskScheduleContentProvider.Unscheduled) {
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)iTask, null);
                        continue;
                    }
                    if (!this.isValidTarget(container)) continue;
                    TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)iTask, container.getDateRange());
                    continue;
                }
                if (currentTarget != null) continue;
                this.moveTask(iTask, (AbstractTaskContainer)TasksUiPlugin.getTaskList().getDefaultCategory());
            }
        }
        if (tasksToMove.size() == 1) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(tasksToMove.get(0)));
        }
        return true;
    }

    private boolean isValidTarget(ScheduledTaskContainer container) {
        return container instanceof TaskScheduleContentProvider.Unscheduled || !(container instanceof TaskScheduleContentProvider.StateTaskContainer);
    }

    private void moveTask(ITask task, AbstractTaskContainer container) {
        if (!this.isUnsubmittedTask(task)) {
            TasksUiInternal.getTaskList().addTask(task, container);
        }
    }

    private boolean isUnsubmittedTask(ITask task) {
        if (task instanceof AbstractTask) {
            for (AbstractTaskContainer parent : ((AbstractTask)task).getParentContainers()) {
                if (!(parent instanceof UnsubmittedTaskContainer)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areAllLocalTasks(List<ITask> tasksToMove) {
        for (ITask task : tasksToMove) {
            if (task instanceof LocalTask && !this.isUnsubmittedTask(task)) continue;
            return false;
        }
        return true;
    }

    private AbstractTask createTaskFromUrl(String data) {
        if (!data.startsWith("http://") && !data.startsWith("https://")) {
            return null;
        }
        String[] urlTransfer = data.split("\n");
        if (urlTransfer.length > 0) {
            String url = urlTransfer[0];
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url);
            if (connector != null) {
                String taskId;
                String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
                AbstractTask task = TasksUiInternal.getTask(repositoryUrl, taskId = connector.getTaskIdFromTaskUrl(url), url);
                if (task != null) {
                    return task;
                }
                if (repositoryUrl != null && taskId != null) {
                    TasksUiInternal.openRepositoryTask(connector.getConnectorKind(), repositoryUrl, taskId, null, 0L);
                }
            } else {
                final String summary = Messages.TaskListDropAdapter__retrieving_from_URL_;
                final LocalTask newTask = TasksUiInternal.createNewLocalTask(summary);
                newTask.setUrl(url);
                AbstractRetrieveTitleFromUrlJob job = new AbstractRetrieveTitleFromUrlJob(url){

                    @Override
                    protected void titleRetrieved(String pageTitle) {
                        if (newTask.getSummary().equals(summary)) {
                            newTask.setSummary(pageTitle);
                            TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)newTask);
                        }
                    }
                };
                job.schedule();
                return newTask;
            }
        }
        return null;
    }

    public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
        this.fileTransfer = false;
        this.localTransfer = false;
        if (FileTransfer.getInstance().isSupportedType(transferType)) {
            this.fileTransfer = true;
            return false;
        }
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            this.localTransfer = true;
            Object target = this.getCurrentTarget();
            if (target instanceof UncategorizedTaskContainer || target instanceof TaskCategory || target instanceof UnmatchedTaskContainer || target instanceof ScheduledTaskContainer && this.isValidTarget((ScheduledTaskContainer)target)) {
                return true;
            }
            if (target instanceof ITaskContainer && (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1)) {
                return true;
            }
            if (target instanceof LocalTask && this.getCurrentLocation() == 3) {
                return true;
            }
            return target instanceof ITask && this.getCurrentLocation() == 3 && this.getCurrentOperation() != 2;
        }
        if (URLTransfer.getInstance().isSupportedType(transferType)) {
            return true;
        }
        return TextTransfer.getInstance().isSupportedType(transferType);
    }
}

