/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.interaction.services;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityExtend;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityGeneralization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;

public class AbstractCapabilityExt {
    public static void addExtendedCapability(AbstractCapability capability, AbstractCapability extendedCapability) {
        if (capability != null && extendedCapability != null && !capability.getExtendedAbstractCapabilities().contains((Object)extendedCapability)) {
            AbstractCapabilityExtend extend = InteractionFactory.eINSTANCE.createAbstractCapabilityExtend();
            capability.getExtends().add((Object)extend);
            extend.setExtended(extendedCapability);
        }
    }

    public static void addIncludedCapability(AbstractCapability capability, AbstractCapability includedCapability) {
        if (capability != null && includedCapability != null && !capability.getIncludedAbstractCapabilities().contains((Object)includedCapability)) {
            AbstractCapabilityInclude include = InteractionFactory.eINSTANCE.createAbstractCapabilityInclude();
            capability.getIncludes().add((Object)include);
            include.setIncluded(includedCapability);
        }
    }

    public static void addSuperCapability(AbstractCapability capability, AbstractCapability superCapability) {
        if (capability != null && superCapability != null && !capability.getSuper().contains((Object)superCapability)) {
            AbstractCapabilityGeneralization generalization = InteractionFactory.eINSTANCE.createAbstractCapabilityGeneralization();
            capability.getSuperGeneralizations().add((Object)generalization);
            generalization.setSuper(superCapability);
        }
    }

    @Deprecated
    public static List<AbstractCapability> getExtendedCapabilities(AbstractCapability capability) {
        return capability.getExtendedAbstractCapabilities();
    }

    public static List<AbstractCapability> getExtendHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        for (AbstractCapabilityExtend extend : currentCapability.getExtends()) {
            AbstractCapability extCap = extend.getExtended();
            if (extCap == null || extCap.equals(currentCapability) || capabilityList.contains(extCap)) continue;
            capabilityList.add(extCap);
            capabilityList.addAll(AbstractCapabilityExt.getExtendHierarchy(extCap));
        }
        return capabilityList;
    }

    @Deprecated
    public static List<AbstractCapability> getIncludedCapabilities(AbstractCapability capability) {
        return capability.getIncludedAbstractCapabilities();
    }

    private static void getIncludedCapabilitiesRecursively(List<AbstractCapability> capabilityList, AbstractCapability currentCapability) {
        EList including = currentCapability.getIncludes();
        for (AbstractCapabilityInclude cap : including) {
            AbstractCapability inclusionCap = cap.getIncluded();
            if (inclusionCap == null || inclusionCap.equals(currentCapability) || capabilityList.contains(inclusionCap)) continue;
            capabilityList.add(inclusionCap);
            AbstractCapabilityExt.getIncludingCapabilitiesRecursively(capabilityList, inclusionCap);
        }
    }

    public static List<AbstractCapability> getIncludedHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        AbstractCapabilityExt.getIncludedCapabilitiesRecursively(capabilityList, currentCapability);
        return capabilityList;
    }

    private static void getIncludingCapabilitiesRecursively(List<AbstractCapability> capabilityList, AbstractCapability currentCapability) {
        EList including = currentCapability.getIncluding();
        for (AbstractCapabilityInclude cap : including) {
            AbstractCapability inclusionCap = cap.getInclusion();
            if (inclusionCap == null || inclusionCap.equals(currentCapability) || capabilityList.contains(inclusionCap)) continue;
            capabilityList.add(inclusionCap);
            AbstractCapabilityExt.getIncludingCapabilitiesRecursively(capabilityList, inclusionCap);
        }
    }

    public static List<AbstractCapability> getIncludingHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        AbstractCapabilityExt.getIncludingCapabilitiesRecursively(capabilityList, currentCapability);
        return capabilityList;
    }

    public static List<AbstractCapability> getInheritanceHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        AbstractCapabilityExt.getInheritanceHierarchyRecursively(capabilityList, currentCapability);
        return capabilityList;
    }

    private static void getInheritanceHierarchyRecursively(List<AbstractCapability> capabilityList, AbstractCapability currentCapability) {
        for (AbstractCapabilityGeneralization generalization : currentCapability.getSuperGeneralizations()) {
            AbstractCapability superCap = generalization.getSuper();
            if (superCap == null || superCap.equals(currentCapability) || capabilityList.contains(superCap)) continue;
            capabilityList.add(superCap);
            AbstractCapabilityExt.getInheritanceHierarchyRecursively(capabilityList, superCap);
        }
    }

    @Deprecated
    public static List<Scenario> getRelatedScenarios(AbstractCapability capability) {
        return capability.getOwnedScenarios();
    }

    public static List<AbstractCapability> getSuperHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        capabilityList.addAll(AbstractCapabilityExt.getInheritanceHierarchy(currentCapability));
        return capabilityList;
    }

    public static List<AbstractCapability> getSubInheritanceHierarchy(AbstractCapability currentCapability) {
        ArrayList<AbstractCapability> capabilityList = new ArrayList<AbstractCapability>();
        AbstractCapabilityExt.getSubInheritanceHierarchyRecursively(capabilityList, currentCapability);
        return capabilityList;
    }

    private static void getSubInheritanceHierarchyRecursively(List<AbstractCapability> capabilityList, AbstractCapability currentCapability) {
        for (AbstractCapabilityGeneralization generalization : currentCapability.getSubGeneralizations()) {
            AbstractCapability subCap = generalization.getSub();
            if (subCap == null || subCap.equals(currentCapability) || capabilityList.contains(subCap)) continue;
            capabilityList.add(subCap);
            AbstractCapabilityExt.getSubInheritanceHierarchyRecursively(capabilityList, subCap);
        }
    }

    public static boolean isIncluded(AbstractCapability capability, Mission mission) {
        boolean isIncluded = false;
        for (CapabilityExploitation capabilityExploitation : mission.getOwnedCapabilityExploitations()) {
            if (!capabilityExploitation.getCapability().equals(capability)) continue;
            isIncluded = true;
            break;
        }
        return isIncluded;
    }

    public static boolean isSuperCapability(AbstractCapability currentCapability, AbstractCapability capability) {
        return AbstractCapabilityExt.getSuperHierarchy(currentCapability).contains(capability);
    }

    public static void removeExtendedCapability(AbstractCapability capability, AbstractCapability extendedCapability) {
        AbstractCapabilityExtend extend = null;
        ListIterator it = capability.getExtends().listIterator();
        while (it.hasNext()) {
            AbstractCapabilityExtend ext = (AbstractCapabilityExtend)it.next();
            if (!ext.getExtended().equals(extendedCapability)) continue;
            extend = ext;
        }
        if (extend != null) {
            capability.getExtends().remove(extend);
            extend.destroy();
        }
    }

    public static void removeIncludedCapability(AbstractCapability capability, AbstractCapability includedCapability) {
        AbstractCapabilityInclude include = null;
        ListIterator it = capability.getIncludes().listIterator();
        while (it.hasNext()) {
            AbstractCapabilityInclude inc = (AbstractCapabilityInclude)it.next();
            if (!inc.getIncluded().equals(includedCapability)) continue;
            include = inc;
        }
        if (include != null) {
            capability.getIncludes().remove(include);
            include.destroy();
        }
    }

    public static void removeSuperCapability(AbstractCapability capability, AbstractCapability superCapability) {
        AbstractCapabilityGeneralization generalization = null;
        ListIterator it = capability.getSuperGeneralizations().listIterator();
        while (it.hasNext()) {
            AbstractCapabilityGeneralization gen = (AbstractCapabilityGeneralization)it.next();
            if (!gen.getSuper().equals(superCapability)) continue;
            generalization = gen;
        }
        if (generalization != null) {
            capability.getSuperGeneralizations().remove(generalization);
            generalization.destroy();
        }
    }
}

