/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.polarsys.capella.core.data.helpers.cache.Couple;

public class Cache {
    private Map<Object, Object> cachedResult = new ConcurrentHashMap<Object, Object>();

    public <P, R> R get(Function<P, R> function, P parameter) {
        Couple<Function<P, R>, P> key = new Couple<Function<P, R>, P>(function, parameter);
        Object resultObject = this.cachedResult.get(key);
        if (resultObject == null) {
            R result = function.apply(parameter);
            Optional<Object> encapsulatedResult = result instanceof List ? Optional.of(Collections.unmodifiableList((List)result)) : (result instanceof Set ? Optional.of(Collections.unmodifiableSet((Set)result)) : (result instanceof Map ? Optional.of(Collections.unmodifiableMap((Map)result)) : Optional.ofNullable(result)));
            this.cachedResult.put(key, encapsulatedResult);
            return result;
        }
        Optional result = (Optional)resultObject;
        return result.orElse(null);
    }

    public void clearCache() {
        this.cachedResult.clear();
    }
}

