/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.tags.SingleFolderTagSource;

public class MultiFolderTagSource
extends SingleFolderTagSource {
    private final ICVSFolder[] folders;

    MultiFolderTagSource(ICVSFolder[] folders) {
        super(folders[0]);
        this.folders = folders;
    }

    @Override
    public String getShortDescription() {
        return NLS.bind((String)CVSUIMessages.MultiFolderTagSource_0, (Object[])new String[]{Integer.toString(this.folders.length)});
    }

    @Override
    public CVSTag[] getTags(int type) {
        if (type == 0 || type == -1) {
            return super.getTags(type);
        }
        HashSet<CVSTag> tags = new HashSet<CVSTag>();
        ICVSFolder[] iCVSFolderArray = this.folders;
        int n = this.folders.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSFolder folder = iCVSFolderArray[n2];
            tags.addAll(Arrays.asList(MultiFolderTagSource.getTags(folder, type)));
            ++n2;
        }
        return tags.toArray(new CVSTag[tags.size()]);
    }

    @Override
    public CVSTag[] refresh(boolean bestEffort, IProgressMonitor monitor) throws TeamException {
        monitor.beginTask("", this.folders.length);
        HashSet<CVSTag> result = new HashSet<CVSTag>();
        ICVSFolder[] iCVSFolderArray = this.folders;
        int n = this.folders.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSFolder folder = iCVSFolderArray[n2];
            CVSTag[] tags = CVSUIPlugin.getPlugin().getRepositoryManager().refreshDefinedTags(folder, bestEffort, true, Policy.subMonitorFor((IProgressMonitor)monitor, (int)1));
            result.addAll(Arrays.asList(tags));
            ++n2;
        }
        monitor.done();
        this.fireChange();
        return result.toArray(new CVSTag[result.size()]);
    }

    @Override
    public ICVSResource[] getCVSResources() {
        return this.folders;
    }

    public ICVSFolder[] getFolders() {
        return this.folders;
    }

    @Override
    public void commit(CVSTag[] tags, boolean replace, IProgressMonitor monitor) throws CVSException {
        try {
            RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
            manager.run(monitor1 -> {
                try {
                    ICVSFolder[] folders;
                    ICVSFolder[] iCVSFolderArray = folders = this.getFolders();
                    int n = folders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICVSFolder folder = iCVSFolderArray[n2];
                        if (replace) {
                            CVSTag[] oldTags = manager.getKnownTags(folder);
                            manager.removeTags(folder, oldTags);
                        }
                        manager.addTags((ICVSResource)folder, tags);
                        ++n2;
                    }
                }
                catch (CVSException e) {
                    throw new InvocationTargetException(e);
                }
            }, monitor);
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
        this.fireChange();
    }
}

