/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSDecoratorConfiguration;
import org.eclipse.team.internal.ccvs.ui.CVSPreferencesPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.console.CVSOutputConsole;
import org.eclipse.team.internal.ccvs.ui.model.CVSAdapterFactory;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class CVSUIPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.eclipse.team.cvs.ui";
    public static final String DECORATOR_ID = "org.eclipse.team.cvs.ui.decorator";
    public static final String P_DECORATORS_CHANGED = "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED";
    private ServiceRegistration debugRegistration;
    private Hashtable imageDescriptors = new Hashtable(20);
    private static List propertyChangeListeners = new ArrayList(5);
    private static CVSUIPlugin plugin;
    private CVSOutputConsole console;
    private RepositoryManager repositoryManager;
    public static final int PERFORM_SYNC_EXEC = 1;
    public static final int LOG_TEAM_EXCEPTIONS = 2;
    public static final int LOG_NONTEAM_CORE_EXCEPTIONS = 4;
    public static final int LOG_OTHER_EXCEPTIONS = 8;
    public static final int LOG_CORE_EXCEPTIONS = 6;
    public static final int LOG_NONTEAM_EXCEPTIONS = 12;

    public CVSUIPlugin() {
        plugin = this;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected void createImageDescriptor(String id) {
        URL url = FileLocator.find((Bundle)CVSUIPlugin.getPlugin().getBundle(), (IPath)new Path("$nl$/icons/full/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.imageDescriptors.put(id, desc);
    }

    public static IWorkbenchPage getActivePage() {
        return TeamUIPlugin.getActivePage();
    }

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    public static void runWithRefresh(Shell parent, IResource[] resources, IRunnableWithProgress runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        InvocationTargetException e2;
        block11: {
            boolean firstTime = true;
            while (true) {
                try {
                    runnable.run(monitor);
                    return;
                }
                catch (InvocationTargetException e2) {
                    if (!firstTime) {
                        throw e2;
                    }
                    IStatus status = null;
                    if (e2.getTargetException() instanceof CoreException) {
                        status = ((CoreException)e2.getTargetException()).getStatus();
                    } else if (e2.getTargetException() instanceof TeamException) {
                        status = ((TeamException)e2.getTargetException()).getStatus();
                    } else {
                        throw e2;
                    }
                    if (status.getCode() != 274) break block11;
                    if (!CVSUIPlugin.promptToRefresh(parent, resources, status)) break;
                    try {
                        IResource[] iResourceArray = resources;
                        int n = resources.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource resource = iResourceArray[n2];
                            resource.refreshLocal(2, null);
                            ++n2;
                        }
                    }
                    catch (CoreException coreEx) {
                        CVSUIPlugin.log(coreEx);
                        throw e2;
                    }
                }
                firstTime = false;
            }
            throw new InterruptedException();
        }
        throw e2;
    }

    private static boolean promptToRefresh(Shell shell, IResource[] resources, IStatus status) {
        boolean[] result = new boolean[1];
        Runnable runnable = () -> {
            Shell shellToUse = shell;
            if (shell == null) {
                shellToUse = new Shell(Display.getCurrent());
            }
            String question = resources.length == 1 ? NLS.bind((String)CVSUIMessages.CVSUIPlugin_refreshQuestion, (Object[])new String[]{status.getMessage(), resources[0].getFullPath().toString()}) : NLS.bind((String)CVSUIMessages.CVSUIPlugin_refreshMultipleQuestion, (Object[])new String[]{status.getMessage()});
            blArray[0] = MessageDialog.openQuestion((Shell)shellToUse, (String)CVSUIMessages.CVSUIPlugin_refreshTitle, (String)question);
        };
        Display.getDefault().syncExec(runnable);
        return result[0];
    }

    public static void runWithProgress(Shell parent, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Utils.runWithProgress((Shell)parent, (boolean)cancelable, (IRunnableWithProgress)runnable);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return (ImageDescriptor)this.imageDescriptors.get(id);
    }

    public static CVSUIPlugin getPlugin() {
        return plugin;
    }

    public synchronized RepositoryManager getRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = new RepositoryManager();
            this.repositoryManager.startup();
        }
        return this.repositoryManager;
    }

    private void initializeImages() {
        this.createImageDescriptor("obj16/repository_rep.gif");
        this.createImageDescriptor("elcl16/refresh.gif");
        this.createImageDescriptor("elcl16/refresh.gif");
        this.createImageDescriptor("dlcl16/refresh.gif");
        this.createImageDescriptor("elcl16/synced.gif");
        this.createImageDescriptor("elcl16/synced.gif");
        this.createImageDescriptor("elcl16/collapseall.gif");
        this.createImageDescriptor("elcl16/collapseall.gif");
        this.createImageDescriptor("etool16/newlocation_wiz.gif");
        this.createImageDescriptor("etool16/newconnect_wiz.gif");
        this.createImageDescriptor("obj16/tag.gif");
        this.createImageDescriptor("obj16/module_rep.gif");
        this.createImageDescriptor("elcl16/clear_co.gif");
        this.createImageDescriptor("elcl16/clear_co.gif");
        this.createImageDescriptor("dlcl16/clear_co.gif");
        this.createImageDescriptor("obj16/branches_rep.gif");
        this.createImageDescriptor("obj16/versions_rep.gif");
        this.createImageDescriptor("obj16/dates.gif");
        this.createImageDescriptor("obj16/prjversions_rep.gif");
        this.createImageDescriptor("wizban/mergestream_wizban.png");
        this.createImageDescriptor("wizban/newconnect_wizban.png");
        this.createImageDescriptor("wizban/createpatch_wizban.png");
        this.createImageDescriptor("wizban/keywordsub_wizban.png");
        this.createImageDescriptor("wizban/newlocation_wizban.png");
        this.createImageDescriptor("wizban/import_wiz.png");
        this.createImageDescriptor("ovr16/confauto_ov.gif");
        this.createImageDescriptor("ovr16/question_ov.gif");
        this.createImageDescriptor("ovr16/merged_ov.gif");
        this.createImageDescriptor("ovr16/edited_ov.gif");
        this.createImageDescriptor("ovr16/no_remotedir_ov.gif");
        this.createImageDescriptor("eview16/console_view.gif");
        this.createImageDescriptor("obj16/date.gif");
        this.createImageDescriptor("obj16/changelog_obj.gif");
        this.createImageDescriptor("elcl16/filter_history.png");
        this.createImageDescriptor("elcl16/local_history_mode.gif");
        this.createImageDescriptor("elcl16/all_history_mode.gif");
        this.createImageDescriptor("elcl16/remote_history_mode.gif");
        this.createImageDescriptor("dlcl16/local_history_mode.gif");
        this.createImageDescriptor("dlcl16/all_history_mode.gif");
        this.createImageDescriptor("dlcl16/remote_history_mode.gif");
        this.createImageDescriptor("obj16/local_entry_tbl.gif");
        this.createImageDescriptor("obj16/remote_entry_tbl.gif");
        this.createImageDescriptor("eview16/compare_view.gif");
        this.createImageDescriptor("glyphs/glyph1.gif");
        this.createImageDescriptor("glyphs/glyph2.gif");
        this.createImageDescriptor("glyphs/glyph3.gif");
        this.createImageDescriptor("glyphs/glyph4.gif");
        this.createImageDescriptor("glyphs/glyph5.gif");
        this.createImageDescriptor("glyphs/glyph6.gif");
        this.createImageDescriptor("glyphs/glyph7.gif");
        this.createImageDescriptor("glyphs/glyph8.gif");
    }

    public static void log(IStatus status) {
        CVSUIPlugin.getPlugin().getLog().log(status);
    }

    public static void log(CoreException e) {
        CVSUIPlugin.log(e.getStatus().getSeverity(), CVSUIMessages.simpleInternal, e);
    }

    public static void log(int severity, String message, Throwable e) {
        CVSUIPlugin.log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static IStatus openError(Shell shell, String title, String message, Throwable exception) {
        return CVSUIPlugin.openError(shell, title, message, exception, 8);
    }

    public static IStatus openError(Shell providedShell, String title, String message, Throwable exception, int flags) {
        if (exception instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)exception).getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            return CVSUIPlugin.openError(providedShell, title, message, target, flags);
        }
        IStatus status = null;
        boolean log = false;
        if (exception instanceof TeamException) {
            status = ((TeamException)exception).getStatus();
            log = (flags & 2) > 0;
        } else if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
            log = (flags & 4) > 0;
        } else {
            if (exception instanceof InterruptedException) {
                return new CVSStatus(0, CVSUIMessages.ok);
            }
            if (exception != null) {
                status = new CVSStatus(4, CVSUIMessages.internal, exception);
                boolean bl = log = (flags & 8) > 0;
                if (title == null) {
                    title = CVSUIMessages.internal;
                }
            }
        }
        if (status.getCode() == 75) {
            message = CVSUIMessages.buildError;
            log = true;
        }
        if (status.isMultiStatus() && status.getChildren().length == 1) {
            status = status.getChildren()[0];
        }
        if (status.isOK()) {
            return status;
        }
        if (log) {
            CVSUIPlugin.log(status.getSeverity(), status.getMessage(), exception);
        }
        return CVSUIPlugin.openDialog(providedShell, title, message, status, flags);
    }

    public static IStatus openError(Shell providedShell, String title, String message, IStatus status, int flags) {
        boolean log = false;
        if (status.getCode() == 75) {
            message = CVSUIMessages.buildError;
            log = true;
        }
        if (status.isMultiStatus() && status.getChildren().length == 1) {
            status = status.getChildren()[0];
        }
        if (status.isOK()) {
            return status;
        }
        if (log) {
            CVSUIPlugin.log(status);
        }
        return CVSUIPlugin.openDialog(providedShell, title, message, status, flags);
    }

    private static IStatus openDialog(Shell providedShell, String title, String message, IStatus status, int flags) {
        IOpenableInShell openable = shell -> {
            if (status.getSeverity() == 1 && !status.isMultiStatus()) {
                MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.information, (String)status.getMessage());
            } else {
                ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
            }
        };
        CVSUIPlugin.openDialog(providedShell, openable, flags);
        return status;
    }

    public static void openDialog(Shell providedShell, IOpenableInShell openable, int flags) {
        IWorkbenchWindow window;
        if (providedShell == null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            providedShell = window.getShell();
            flags |= 1;
        }
        Shell shell = providedShell;
        Runnable outerRunnable = () -> {
            Shell displayShell;
            if (shell == null) {
                Display display = Display.getCurrent();
                displayShell = new Shell(display);
            } else {
                displayShell = shell;
            }
            openable.open(displayShell);
            if (shell == null) {
                displayShell.dispose();
            }
        };
        if (shell == null || (flags & 1) > 0) {
            Display display;
            if (shell == null) {
                display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
            } else {
                display = shell.getDisplay();
            }
            display.syncExec(outerRunnable);
        } else {
            outerRunnable.run();
        }
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        Preferences corePrefs = CVSProviderPlugin.getPlugin().getPluginPreferences();
        store.setDefault("pref_repositories_are_binary", false);
        store.setDefault("pref_show_comments", true);
        store.setDefault("pref_wrap_comments", true);
        store.setDefault("pref_show_tags", true);
        store.setDefault("pref_show_search", false);
        store.setDefault("pref_revision_mode", 0);
        store.setDefault("pref_groupbydate_mode", true);
        store.setDefault("pref_history_view_linking", false);
        store.setDefault("pref_prune_empty_directories", true);
        store.setDefault("pref_timeout", 60);
        store.setDefault("pref_consider_contents", true);
        store.setDefault("pref_syncview_regex_filter_pattern", "");
        store.setDefault("pref_compression_level", 0);
        store.setDefault("pref_text_ksubst", CVSProviderPlugin.DEFAULT_TEXT_KSUBST_OPTION.toMode());
        store.setDefault("pref_lineend", true);
        store.setDefault("pref_replace_unmanaged", true);
        store.setDefault("pref_cvs_rsh", "ssh");
        store.setDefault("pref_cvs_rsh_parameters", "-l {user} {host}");
        store.setDefault("pref_cvs_server", "cvs");
        store.setDefault("pref_ext_connection_method_proxy", "ext");
        store.setDefault("pref_prompt_on_change_granularity", true);
        store.setDefault("pref_determine_server_version", true);
        store.setDefault("pref_confirm_move_tag", true);
        store.setDefault("pref_debug_protocol", false);
        store.setDefault("pref_remember_merges", true);
        store.setDefault("pref_show_compare_revision_in_dialog", false);
        store.setDefault("pref_enable_commit_sets", false);
        store.setDefault("pref_auto_refresh_tags_in_tag_selection_dialog", false);
        store.setDefault("pref_auto_share_on_import", true);
        store.setDefault("pref_enable_watch_on_edit", false);
        store.setDefault("pref_use_project_name_on_checkout", false);
        store.setDefault("pref_commit_files_display_threshold", 1000);
        store.setDefault("pref_commit_comments_max_history", 10);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_command_color", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_message_color", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"pref_console_error_color", (RGB)new RGB(255, 0, 0));
        store.setDefault("pref_console_show_on_message", false);
        store.setDefault("pref_console_limit_output", true);
        store.setDefault("pref_console_high_water_mark", 500000);
        store.setDefault("pref_console_wrap", false);
        store.setDefault("pref_console_width", 80);
        store.setDefault("pref_filetext_decoration", CVSDecoratorConfiguration.DEFAULT_FILETEXTFORMAT);
        store.setDefault("pref_foldertext_decoration", CVSDecoratorConfiguration.DEFAULT_FOLDERTEXTFORMAT);
        store.setDefault("pref_projecttext_decoration", CVSDecoratorConfiguration.DEFAULT_PROJECTTEXTFORMAT);
        store.setDefault("pref_first_startup", true);
        store.setDefault("pref_added_flag", CVSDecoratorConfiguration.DEFAULT_ADDED_FLAG);
        store.setDefault("pref_dirty_flag", CVSDecoratorConfiguration.DEFAULT_DIRTY_FLAG);
        store.setDefault("pref_show_added", true);
        store.setDefault("pref_show_hasremote", true);
        store.setDefault("pref_show_overlaydirty", false);
        store.setDefault("pref_show_newresource", true);
        store.setDefault("pref_calculate_dirty", true);
        store.setDefault("pref_use_font_decorators", false);
        store.setDefault("pref_prompt_on_mixed_tags", true);
        store.setDefault("pref_prompt_on_saving_in_sync", true);
        store.setDefault("pref_save_dirty_editors", 2);
        store.setDefault("pref_annotate_promptforbinary", "prompt");
        store.setDefault("pref_allow_empty_commit_comment", "prompt");
        store.setDefault("pref_include_change_sets", "never");
        store.setDefault("pref_commit_with_warning", "always");
        store.setDefault("pref_commit_with_errors", "prompt");
        store.setDefault("pref_team_update_handling", "traditionalUpdate");
        store.setDefault("pref_update_preview", "syncView");
        store.setDefault("enableModelSync", true);
        store.setDefault("openCompareEditorForSingleFile", true);
        store.setDefault("pref_checkout_read_only", corePrefs.getDefaultBoolean("cvs.read.only"));
        store.setDefault("pref_edit_action", "editInBackground");
        store.setDefault("pref_edit_prompt", "only");
        store.setDefault("pref_update_prompt", "never");
        store.setValue("pref_checkout_read_only", corePrefs.getBoolean("cvs.read.only"));
        CVSProviderPlugin.getPlugin().setPruneEmptyDirectories(store.getBoolean("pref_prune_empty_directories"));
        CVSProviderPlugin.getPlugin().setTimeout(store.getInt("pref_timeout"));
        CVSProviderPlugin.getPlugin().setCvsRshCommand(store.getString("pref_cvs_rsh"));
        CVSProviderPlugin.getPlugin().setCvsRshParameters(store.getString("pref_cvs_rsh_parameters"));
        CVSProviderPlugin.getPlugin().setCvsServer(store.getString("pref_cvs_server"));
        CVSRepositoryLocation.setExtConnectionMethodProxy((String)store.getString("pref_ext_connection_method_proxy"));
        CVSProviderPlugin.getPlugin().setQuietness(CVSPreferencesPage.getQuietnessOptionFor(store.getInt("pref_quietness")));
        CVSProviderPlugin.getPlugin().setCompressionLevel(store.getInt("pref_compression_level"));
        CVSProviderPlugin.getPlugin().setReplaceUnmanaged(store.getBoolean("pref_replace_unmanaged"));
        CVSProviderPlugin.getPlugin().setDefaultTextKSubstOption(Command.KSubstOption.fromMode((String)store.getString("pref_text_ksubst")));
        CVSProviderPlugin.getPlugin().setUsePlatformLineend(store.getBoolean("pref_lineend"));
        CVSProviderPlugin.getPlugin().setRepositoriesAreBinary(store.getBoolean("pref_repositories_are_binary"));
        CVSProviderPlugin.getPlugin().setDetermineVersionEnabled(store.getBoolean("pref_determine_server_version"));
        CVSProviderPlugin.getPlugin().setDebugProtocol(CVSProviderPlugin.getPlugin().isDebugProtocol() || store.getBoolean("pref_debug_protocol"));
        CVSProviderPlugin.getPlugin().setAutoshareOnImport(store.getBoolean("pref_auto_share_on_import"));
        if (store.getBoolean("pref_show_author_in_editor")) {
            store.setValue("pref_show_author_in_editor", false);
            IPreferenceStore teamStore = TeamUIPlugin.getPlugin().getPreferenceStore();
            if (teamStore.isDefault("org.eclipse.team.ui.show_author_in_compare_editor")) {
                teamStore.setValue("org.eclipse.team.ui.show_author_in_compare_editor", true);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.DEBUG_OPTIONS_LISTENER, properties);
        this.initializeImages();
        CVSAdapterFactory factory = new CVSAdapterFactory();
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ICVSRemoteFile.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ICVSRemoteFolder.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, ICVSRepositoryLocation.class);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, RepositoryRoot.class);
        try {
            this.console = new CVSOutputConsole();
        }
        catch (RuntimeException e) {
            CVSUIPlugin.log(4, "Errors occurred starting the CVS console", e);
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean("pref_first_startup")) {
            PlatformUI.getWorkbench().getDecoratorManager().setEnabled(DECORATOR_ID, true);
            store.setValue("pref_first_startup", false);
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.debugRegistration.unregister();
            this.debugRegistration = null;
            try {
                if (this.repositoryManager != null) {
                    this.repositoryManager.shutdown();
                }
            }
            catch (TeamException e) {
                throw new CoreException(e.getStatus());
            }
            if (this.console != null) {
                this.console.shutdown();
            }
        }
        finally {
            super.stop(context);
        }
    }

    public CVSOutputConsole getConsole() {
        return this.console;
    }

    public IEditorPart openEditor(ICVSRemoteFile file, IProgressMonitor monitor) throws InvocationTargetException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            return Utils.openEditor((IWorkbenchPage)page, (IFileRevision)((IFileRevision)file.getAdapter(IFileRevision.class)), (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    public boolean isUseProjectNameOnCheckout() {
        return this.getPreferenceStore().getBoolean("pref_use_project_name_on_checkout");
    }

    public ActiveChangeSetManager getChangeSetManager() {
        return CVSProviderPlugin.getPlugin().getChangeSetManager();
    }

    public org.osgi.service.prefs.Preferences getInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public static interface IOpenableInShell {
        public void open(Shell var1);
    }
}

