/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.provider;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.capella.core.data.capellamodeller.provider.CapellaModellerEditPlugin;
import org.polarsys.capella.core.data.gen.edit.decorators.ItemProviderAdapterDecorator;
import org.polarsys.capella.core.data.interaction.ArmTimerEvent;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;

public class SequenceMessageItemProviderDecorator
extends ItemProviderAdapterDecorator
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static final String FULL_OBJ16_SEQUENCE_MESSAGE = "full/obj16/SequenceMessage";

    public SequenceMessageItemProviderDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    public Object getImage(Object object) {
        String imagePath;
        MessageKind kind = ((SequenceMessage)object).getKind();
        switch (kind) {
            case REPLY: {
                imagePath = "full/obj16/SequenceMessageReply";
                break;
            }
            case CREATE: {
                imagePath = "full/obj16/SequenceMessageCreate";
                break;
            }
            case DELETE: {
                imagePath = "full/obj16/SequenceMessageDelete";
                break;
            }
            case TIMER: {
                MessageEnd receivingEnd = ((SequenceMessage)object).getReceivingEnd();
                MessageEnd sendingEnd = ((SequenceMessage)object).getSendingEnd();
                if (receivingEnd == null && sendingEnd == null) {
                    imagePath = FULL_OBJ16_SEQUENCE_MESSAGE;
                    break;
                }
                if (receivingEnd != null && receivingEnd.getEvent() instanceof ArmTimerEvent || sendingEnd != null && sendingEnd.getEvent() instanceof ArmTimerEvent) {
                    imagePath = "full/obj16/SequenceMessageArmTimer";
                    break;
                }
                imagePath = "full/obj16/SequenceMessageCancelTimer";
                break;
            }
            case ASYNCHRONOUS_CALL: {
                MessageEnd receivingEnd1 = ((SequenceMessage)object).getReceivingEnd();
                MessageEnd sendingEnd1 = ((SequenceMessage)object).getSendingEnd();
                if (receivingEnd1 == null && sendingEnd1 != null) {
                    imagePath = "full/obj16/LostMessage";
                    break;
                }
                if (sendingEnd1 == null && receivingEnd1 != null) {
                    imagePath = "full/obj16/FoundMessage";
                    break;
                }
                imagePath = FULL_OBJ16_SEQUENCE_MESSAGE;
                break;
            }
            default: {
                imagePath = FULL_OBJ16_SEQUENCE_MESSAGE;
            }
        }
        return this.overlayImage(object, CapellaModellerEditPlugin.INSTANCE.getImage(imagePath));
    }
}

