/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.exchanges;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.sirius.common.tools.api.util.SiriusCrossReferenceAdapter;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.projection.exchanges.DefaultExchangesCreator;

public class PhysicalLinksCreator
extends DefaultExchangesCreator {
    private Part part = null;

    public PhysicalLinksCreator(Component component, Part part) {
        super(component);
        this.part = part;
    }

    @Override
    public void createExchanges() {
        if (this.isValidBound(this._component)) {
            this.createPhysicalLinksFromCExchanges(this._component);
        }
    }

    @Override
    protected boolean isValidCreation(AbstractEventOperation fe, Component component, Component allocating) {
        return this.isValidBound(component) && this.isValidBound(allocating);
    }

    protected void createPhysicalLinksFromCExchanges(Component container) {
        if (container != null) {
            if (container instanceof PhysicalComponent) {
                EList deployments = this.part.getDeploymentLinks();
                for (AbstractDeploymentLink deployment : deployments) {
                    if (!(deployment instanceof PartDeploymentLink)) continue;
                    PartDeploymentLink deploymentLink = (PartDeploymentLink)deployment;
                    DeployableElement deployedElement = deploymentLink.getDeployedElement();
                    if (deployedElement instanceof Part) {
                        Type containedPC = ((Part)deployedElement).getType();
                        if (!(containedPC instanceof PhysicalComponent)) continue;
                        this.createPhysicalLinksFromCExchanges(container, (Component)((PhysicalComponent)containedPC));
                        continue;
                    }
                    if (!(deployedElement instanceof PhysicalComponent)) continue;
                    this.createPhysicalLinksFromCExchanges(container, (Component)((PhysicalComponent)deployedElement));
                }
            }
            if (!this.isContainedByALogicalNonActorComponent(container)) {
                this.createPLsFromCEDiffLevels(container);
                this.createPLsFromCESameLevel(container);
            }
        }
    }

    protected void createPLsFromCEDiffLevels(Component container) {
        List subComponents = ComponentExt.getSubDefinedComponents((Component)container);
        if (!subComponents.isEmpty()) {
            subComponents.stream().filter(c -> ComponentExt.isActor((Component)c)).forEach(actor -> this.createPhysicalLinksFromCExchanges(container, (Component)actor));
        }
    }

    protected void createPLsFromCESameLevel(Component container) {
        if (!(container instanceof PhysicalComponent) || ComponentExt.isActor((Component)container) || ((PhysicalComponent)container).getNature() != PhysicalComponentNature.NODE) {
            this.createPhysicalLinksFromCExchanges(container, container);
        }
    }

    protected void createPhysicalLinksFromCExchanges(Component sourceContainer, Component sourceContained) {
        if (this.isValidBound(sourceContained)) {
            for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)sourceContained)) {
                for (ComponentExchange componentExchange : port.getComponentExchanges()) {
                    this.processComponentExchange(sourceContainer, sourceContained, port, componentExchange);
                }
            }
        }
    }

    private boolean isContainedByALogicalNonActorComponent(Component component) {
        if (!(component instanceof LogicalComponent)) {
            return false;
        }
        EObject container = component.eContainer();
        if (container instanceof LogicalComponent) {
            return !ComponentExt.isActor((EObject)container) || this.isContainedByALogicalNonActorComponent((Component)container);
        }
        return false;
    }

    private void processComponentExchange(Component sourceContainer, Component sourceContained, ComponentPort port, ComponentExchange componentExchange) {
        if (componentExchange.getKind() == ComponentExchangeKind.DELEGATION || componentExchange.getKind() == ComponentExchangeKind.UNSET || this.doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(sourceContainer, componentExchange)) {
            return;
        }
        Component targetContained = this.findTheTargetComponent(componentExchange, port);
        if (targetContained != null) {
            Component targetContainer;
            PhysicalComponent targetContainerPC;
            if (targetContained instanceof PhysicalComponent && (targetContainerPC = this.findDeployingComponent((PhysicalComponent)targetContained)) != null) {
                this.doCreatePhysicalLink(componentExchange, sourceContainer, (Component)targetContainerPC, port);
            }
            if (sourceContainer.equals(sourceContained) && (ComponentExt.isActor((Component)sourceContained) || this.isSystemOrLogicalSystem(sourceContained))) {
                if (!this.isContainedByALogicalNonActorComponent(targetContained)) {
                    this.doCreatePhysicalLink(componentExchange, sourceContainer, targetContained, port);
                }
            } else if (ComponentExt.isActor((Component)targetContained) && targetContained.eContainer() instanceof Component && !this.isContainedByALogicalNonActorComponent(targetContainer = (Component)targetContained.eContainer())) {
                this.doCreatePhysicalLink(componentExchange, sourceContainer, targetContainer, port);
            }
        }
    }

    private Component findTheTargetComponent(ComponentExchange componentExchange, ComponentPort port) {
        InformationsExchanger target = FunctionalExt.getOtherBound((ExchangeSpecification)componentExchange, (InformationsExchanger)port);
        if (!(target instanceof ComponentPort)) {
            return null;
        }
        EObject targetContained = target.eContainer();
        if (!(targetContained instanceof Component) || !this.isValidBound((Component)targetContained)) {
            return null;
        }
        if (targetContained instanceof LogicalComponent && !ComponentExt.isActor((EObject)targetContained) && !this.isSystemOrLogicalSystem((Component)targetContained)) {
            return null;
        }
        return (Component)targetContained;
    }

    private boolean isSystemOrLogicalSystem(Component component) {
        if (component instanceof PhysicalComponent || component instanceof Entity) {
            return false;
        }
        BlockArchitecture architecture = ComponentExt.getRootBlockArchitecture((ModelElement)component);
        return architecture.getSystem().equals(component);
    }

    private PhysicalComponent findDeployingComponent(PhysicalComponent targetContained) {
        for (Part partition : targetContained.getRepresentingParts()) {
            for (DeploymentTarget deploying : (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)partition)) {
                Part deployingPart;
                if (!(deploying instanceof Part) || !((deployingPart = (Part)deploying).getAbstractType() instanceof PhysicalComponent)) continue;
                return (PhysicalComponent)deployingPart.getAbstractType();
            }
        }
        return null;
    }

    private void doCreatePhysicalLink(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput, ComponentPort sourcePort) {
        if (componentExchange.getSource().equals(sourcePort)) {
            this.doCreatePhysicalLink(componentExchange, exchangeOutput, exchangeInput);
        } else {
            this.doCreatePhysicalLink(componentExchange, exchangeInput, exchangeOutput);
        }
    }

    protected void doCreatePhysicalLink(ComponentExchange componentExchange, Component exchangeOutput, Component exchangeInput) {
        if (exchangeOutput == exchangeInput) {
            return;
        }
        PhysicalLink physicalLink = CsFactory.eINSTANCE.createPhysicalLink(componentExchange.getLabel());
        PhysicalPort outP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getSource().getLabel());
        PhysicalPort inP = CsFactory.eINSTANCE.createPhysicalPort(componentExchange.getTarget().getLabel());
        physicalLink.getLinkEnds().add((Object)outP);
        physicalLink.getLinkEnds().add((Object)inP);
        exchangeInput.getOwnedFeatures().add((Object)inP);
        exchangeOutput.getOwnedFeatures().add((Object)outP);
        CapellaElementExt.creationService((EObject)inP);
        CapellaElementExt.creationService((EObject)outP);
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
        CapellaElementExt.creationService((EObject)physicalLink);
        ComponentExchangeAllocation cea = FaFactory.eINSTANCE.createComponentExchangeAllocation();
        cea.setSourceElement((TraceableElement)physicalLink);
        cea.setTargetElement((TraceableElement)componentExchange);
        physicalLink.getOwnedComponentExchangeAllocations().add((Object)cea);
        CapellaElementExt.creationService((EObject)cea);
        InformationsExchanger target = componentExchange.getTarget();
        this.createComponentPortAllocation(target, inP);
        InformationsExchanger source = componentExchange.getSource();
        this.createComponentPortAllocation(source, outP);
        exchangeInput.getOwnedPhysicalLinks().add((Object)physicalLink);
        exchangeOutput.getOwnedPhysicalLinks().add((Object)physicalLink);
    }

    private ComponentPortAllocation createComponentPortAllocation(InformationsExchanger informationExchange, PhysicalPort physicalPort) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)physicalPort);
        allocation.setTargetElement((TraceableElement)informationExchange);
        physicalPort.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
        return allocation;
    }

    protected boolean doesNodeAlreadyHaveAPhysicalLinkForComponentExchange(Component physicalComponent, ComponentExchange componentExchange) {
        boolean result = false;
        SemanticEditingDomainFactory.SemanticEditingDomain editingDomain = (SemanticEditingDomainFactory.SemanticEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)componentExchange);
        SiriusCrossReferenceAdapter crossReferencer = editingDomain.getCrossReferencer();
        Collection inverseReferences = crossReferencer.getInverseReferences((EObject)componentExchange, true);
        for (EStructuralFeature.Setting setting : inverseReferences) {
            if (!(setting.getEObject() instanceof ComponentExchangeAllocation)) continue;
            result = true;
            break;
        }
        return result;
    }
}

