/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.polarsys.capella.core.sirius.ui.Messages;

public class AirdFileCreationWizardPage
extends WizardNewFileCreationPage {
    private final String _fileExtension;
    private IFile _selectedFile;

    public AirdFileCreationWizardPage(String pageName_p, IStructuredSelection selection_p, String fileExtension_p) {
        super(pageName_p, selection_p);
        this.setTitle(Messages.SiriusCreationWizardPage_Title);
        this.setDescription(Messages.SiriusCreationWizardPage_Description);
        this._fileExtension = fileExtension_p;
        if (selection_p.getFirstElement() instanceof IFile) {
            this._selectedFile = (IFile)selection_p.getFirstElement();
        }
    }

    protected String getExtension() {
        return this._fileExtension;
    }

    public URI getURI() {
        return URI.createPlatformResourceURI((String)this.getFilePath().toString(), (boolean)true);
    }

    protected IPath getFilePath() {
        String fileName;
        IPath path = this.getContainerFullPath();
        if (path == null) {
            path = new Path("");
        }
        if ((fileName = this.getFileName()) != null) {
            path = path.append(fileName);
        }
        return path;
    }

    public String getDefaultFileName() {
        if (this._selectedFile != null && this._selectedFile.getFullPath().removeFileExtension().lastSegment() != null) {
            String name = this._selectedFile.getFullPath().removeFileExtension().lastSegment();
            return name;
        }
        return "newDiagrams";
    }

    public void createControl(Composite parent_p) {
        super.createControl(parent_p);
        this.setFileName(String.valueOf(this.getDefaultFileName()) + '.' + this.getExtension());
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        boolean result = true;
        if (!super.validatePage()) {
            return false;
        }
        String extension = this.getExtension();
        if (extension != null && !this.getFilePath().toString().endsWith(String.valueOf('.') + extension)) {
            this.setErrorMessage("The file extension is wrong.");
            result = false;
        }
        return result;
    }
}

