/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.polarsys.capella.core.sirius.ui.helper.ResourceHelper;
import org.polarsys.capella.core.sirius.ui.refactoring.WorkspaceImagePathChange;

public class CapellaRenameParticipant
extends RenameParticipant {
    private IContainer container;

    protected boolean initialize(Object element) {
        if (element instanceof IContainer) {
            this.container = (IContainer)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Capella Rename Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        if (this.container.isAccessible()) {
            return new RefactoringStatus();
        }
        return RefactoringStatus.createErrorStatus((String)"Unable to update Workspace Image paths because container is not accessible !");
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException {
        if (this.container instanceof IProject || this.getArguments().getUpdateReferences() && !ResourceHelper.collectImageFiles(this.container).isEmpty()) {
            return this.doCreateChange(pm);
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    private Change doCreateChange(IProgressMonitor pm) {
        return new WorkspaceImagePathChange(this.container, this.getArguments());
    }
}

