/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.ui.quickfix.resolver;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.ui.quickfix.resolver.DWF_I_21_Resolver;
import org.polarsys.capella.core.data.cs.validation.interface_.ExchangeItemAllocationProtocol;
import org.polarsys.capella.core.data.helpers.information.services.LinkCompatibilityDefinition;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.ScenarioExt;

public class DWF_I_22_Resolver
extends DWF_I_21_Resolver {
    public DWF_I_22_Resolver(CommunicationLinkProtocol protocol, boolean isSender) {
        super(protocol, isSender);
    }

    @Override
    protected boolean canResolve(IMarker marker) {
        List objects = MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
        boolean canResolve = false;
        if (objects.size() > 0 && objects.get(0) instanceof ExchangeItemAllocation) {
            ExchangeItemAllocation allocation = (ExchangeItemAllocation)objects.get(0);
            Diagnostic diagnostic = (Diagnostic)marker.getAdapter(Diagnostic.class);
            if (diagnostic instanceof ConstraintStatusDiagnostic) {
                for (SequenceMessage message : allocation.getInvokingSequenceMessages()) {
                    if (message.getKind() == MessageKind.REPLY) continue;
                    boolean hasReply = ScenarioExt.hasReply((SequenceMessage)message);
                    ExchangeMechanism mechanism = allocation.getAllocatedItem().getExchangeMechanism();
                    if (this.isSender && ExchangeItemAllocationProtocol.isSenderAllocation((IStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus())) {
                        canResolve = canResolve || LinkCompatibilityDefinition.INSTANCE.getCompatibleProtocols(true, mechanism, message.getKind(), hasReply).contains(this.protocol);
                        continue;
                    }
                    if (this.isSender || !ExchangeItemAllocationProtocol.isReceiverAllocation((IStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus())) continue;
                    boolean bl = canResolve = canResolve || LinkCompatibilityDefinition.INSTANCE.getCompatibleProtocols(false, mechanism, message.getKind(), hasReply).contains(this.protocol);
                }
            }
        }
        return canResolve;
    }

    @Override
    protected String[] getResolvableRuleIds() {
        return new String[]{"DWF_I_22"};
    }

    @Override
    protected boolean quickFixAllSimilarEnabled(Collection<IMarker> markers) {
        return true;
    }
}

