/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;

public class CheckedTreeSelectionWithUndefinedElementsDialog
extends CheckedTreeSelectionDialog {
    private ITreeContentProvider contentProvider;
    private Object input;
    private List<Object> checkedElements = null;
    private List<Object> uncheckedElements = null;
    private List<Object> initialCheckedElements = null;
    private List<Object> undefinedElements = null;

    public List<Object> getCheckedElements() {
        return this.checkedElements;
    }

    public List<Object> getUnCheckedElements() {
        return this.uncheckedElements;
    }

    public void setUndefinedElements(List<Object> undefinedElements) {
        this.undefinedElements = undefinedElements;
    }

    public List<Object> getUndefinedElements() {
        return this.undefinedElements;
    }

    public CheckedTreeSelectionWithUndefinedElementsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.contentProvider = contentProvider;
        this.checkedElements = new ArrayList<Object>();
        this.uncheckedElements = new ArrayList<Object>();
        this.initialCheckedElements = new ArrayList<Object>();
        this.undefinedElements = new ArrayList<Object>();
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.input = input;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.initialCheckedElements = this.getInitialElementSelections();
        this.getTreeViewer().setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return CheckedTreeSelectionWithUndefinedElementsDialog.this.undefinedElements.contains(element);
            }

            public boolean isChecked(Object element) {
                return CheckedTreeSelectionWithUndefinedElementsDialog.this.initialCheckedElements.contains(element);
            }
        });
        this.getTreeViewer().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().getGrayed(event.getElement())) {
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setGrayed(event.getElement(), false);
                }
                if (event.getChecked()) {
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.checkedElements.add(event.getElement());
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.uncheckedElements.remove(event.getElement());
                } else {
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.checkedElements.remove(event.getElement());
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.uncheckedElements.add(event.getElement());
                }
            }
        });
        return result;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        buttonComposite.setLayoutData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, Messages.selectAll, false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements;
                Object[] objectArray = viewerElements = CheckedTreeSelectionWithUndefinedElementsDialog.this.contentProvider.getElements(CheckedTreeSelectionWithUndefinedElementsDialog.this.input);
                int n = viewerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object viewerElement = objectArray[n2];
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setSubtreeChecked(viewerElement, true);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.checkedElements.add(viewerElement);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.uncheckedElements.remove(viewerElement);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setGrayed(viewerElement, false);
                    ++n2;
                }
                CheckedTreeSelectionWithUndefinedElementsDialog.this.updateOKStatus();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Messages.deselectAll, false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements;
                CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setCheckedElements(new Object[0]);
                Object[] objectArray = viewerElements = CheckedTreeSelectionWithUndefinedElementsDialog.this.contentProvider.getElements(CheckedTreeSelectionWithUndefinedElementsDialog.this.input);
                int n = viewerElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object viewerElement = objectArray[n2];
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setSubtreeChecked(viewerElement, false);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.checkedElements.remove(viewerElement);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.uncheckedElements.add(viewerElement);
                    CheckedTreeSelectionWithUndefinedElementsDialog.this.getTreeViewer().setGrayed(viewerElement, false);
                    ++n2;
                }
                CheckedTreeSelectionWithUndefinedElementsDialog.this.updateOKStatus();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }
}

