/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ui.providers.MDEAdapterFactoryLabelProvider;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractViewerDialog;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.common.ui.toolkit.viewers.RegExpCheckboxTreeViewer;

public class CheckboxTreeDialog<T extends EObject, U extends EObject>
extends AbstractViewerDialog {
    public static final String CHECKBOX_TREE_DIALOG = "org.polarsys.capella.common.ui.toolkit.dialogs.checkboxTree";
    private RegExpCheckboxTreeViewer _checkboxTreeViewer;
    private Map<T, Collection<U>> _results;
    private List<ElementNode> _rootNodes;

    public CheckboxTreeDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, message, Messages.CheckboxTreeDialog_Window_Title);
    }

    private void checkInitialSelection(CheckboxTreeViewer viewer, List<ElementNode> rootNodes) {
        ArrayList<TreeNode> checkedElements = new ArrayList<TreeNode>(0);
        for (ElementNode rootNode : rootNodes) {
            TreeNode[] treeNodeArray = rootNode.getChildren();
            int n = treeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode childNode = treeNodeArray[n2];
                if (((ElementNode)childNode).isInitialCheckedState()) {
                    checkedElements.add(childNode);
                }
                ++n2;
            }
        }
        viewer.setCheckedElements(checkedElements.toArray());
    }

    protected RegExpCheckboxTreeViewer createCheckboxTreeViewer(Composite dialogAreaComposite) {
        return new RegExpCheckboxTreeViewer(dialogAreaComposite){

            @Override
            public String getContextMenuLocation() {
                return CheckboxTreeDialog.CHECKBOX_TREE_DIALOG;
            }
        };
    }

    @Override
    protected void doCreateDialogArea(Composite parent) {
        this._checkboxTreeViewer = this.createCheckboxTreeViewer(parent);
        CheckboxTreeViewer viewer = this._checkboxTreeViewer.getClientViewer();
        viewer.setSorter(new ViewerSorter());
        viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setInput((Object)this._rootNodes.toArray(new TreeNode[this._rootNodes.size()]));
        this.checkInitialSelection(viewer, this._rootNodes);
        this.constrainViewer((TreeViewer)viewer, this.getViewerHeighthint());
    }

    @Override
    public Map<T, Collection<U>> getResult() {
        return this._results;
    }

    protected List<ElementNode> getRootNodes(Map<T, Collection<U>> allElements, Map<T, Collection<U>> initialCheckedElements) {
        ArrayList<ElementNode> nodes = new ArrayList<ElementNode>();
        for (Map.Entry<T, Collection<U>> entry : allElements.entrySet()) {
            EObject semanticKey = (EObject)entry.getKey();
            boolean isKeyChecked = initialCheckedElements.containsKey(semanticKey);
            Collection<U> checkedElementsForKey = null;
            if (isKeyChecked) {
                checkedElementsForKey = initialCheckedElements.get(semanticKey);
            }
            ElementNode node = new ElementNode(semanticKey);
            for (EObject semanticChild : entry.getValue()) {
                ElementNode childNode = new ElementNode(semanticChild);
                node.addChild(childNode);
                if (!isKeyChecked) continue;
                childNode.setInitialCheckedState(checkedElementsForKey.contains(semanticChild));
            }
            nodes.add(node);
        }
        return nodes;
    }

    protected void okPressed() {
        Object[] checkedElements;
        this._results = new HashMap<T, Collection<U>>(0);
        Object[] objectArray = checkedElements = this._checkboxTreeViewer.getClientViewer().getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            ElementNode elementNode = (ElementNode)((Object)object);
            ElementNode parentNode = elementNode.getParent();
            if (parentNode != null) {
                Collection<U> collection = this._results.get(parentNode.getValue());
                if (collection == null) {
                    collection = new ArrayList<U>(1);
                    this._results.put((EObject)parentNode.getValue(), collection);
                }
                collection.add((EObject)elementNode.getValue());
            }
            ++n2;
        }
        super.okPressed();
    }

    public void setInput(Map<T, Collection<U>> selectableElements, Map<T, Collection<U>> checkedElements) {
        this._rootNodes = this.getRootNodes(selectableElements, checkedElements);
    }

    class ElementNode
    extends TreeNode {
        private Collection<ElementNode> _children;
        private boolean _initialCheckedState;

        ElementNode(Object value) {
            super(value);
        }

        void addChild(ElementNode child) {
            if (this._children == null) {
                this._children = new ArrayList<ElementNode>(1);
            }
            if (!this._children.contains((Object)child)) {
                this._children.add(child);
                child.setParent(this);
            }
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)object;
                result = Util.equals((Object)this.value, (Object)treeNode.getValue());
                result = result ? Util.equals((Object)((Object)this.getParent()), (Object)treeNode.getParent()) : false;
            }
            return result;
        }

        public TreeNode[] getChildren() {
            return this._children != null ? this._children.toArray(new TreeNode[this._children.size()]) : null;
        }

        public ElementNode getParent() {
            return (ElementNode)super.getParent();
        }

        public boolean hasChildren() {
            return this._children != null;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + Util.hashCode((Object)this.value);
            if (this.getParent() != null) {
                result = 37 * result + Util.hashCode((Object)this.getParent().value);
            }
            return result;
        }

        boolean isInitialCheckedState() {
            return this._initialCheckedState;
        }

        void removeChild(ElementNode child) {
            if (this._children != null) {
                this._children.remove((Object)child);
            }
        }

        void setInitialCheckedState(boolean initialCheckState) {
            this._initialCheckedState = initialCheckState;
        }

        void setParent(ElementNode parent) {
            ElementNode previousParent = this.getParent();
            if (previousParent != null) {
                previousParent.removeChild(this);
            }
            super.setParent((TreeNode)parent);
            if (parent != null) {
                parent.addChild(this);
            }
        }
    }

    class LabelProvider
    extends MDEAdapterFactoryLabelProvider {
        LabelProvider() {
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return super.getColumnImage(((TreeNode)object).getValue(), columnIndex);
        }

        public String getColumnText(Object object, int columnIndex) {
            return super.getColumnText(((TreeNode)object).getValue(), columnIndex);
        }

        @Override
        public Image getImage(Object object) {
            return super.getImage(((TreeNode)object).getValue());
        }

        @Override
        public String getText(Object object) {
            return super.getText(((TreeNode)object).getValue());
        }
    }
}

