/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.AbstractCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.InterfaceCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.LinkCommunication;
import org.polarsys.capella.core.data.interaction.properties.dialogs.sequenceMessage.model.communications.UndefinedCommunication;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ExchangeItemExt;

public class SelectionAlgorithms {
    public static List<InterfaceCommunication> getInterfaceCommunications(Component c1, Component c2) {
        ArrayList<InterfaceCommunication> res = new ArrayList<InterfaceCommunication>();
        ArrayList usedInterfaces = new ArrayList();
        ArrayList implementedInterfaces = new ArrayList();
        usedInterfaces.addAll(ComponentExt.getAllUsedAndRequiredInterfaces((Component)c1));
        implementedInterfaces.addAll(ComponentExt.getAllImplementedAndProvidedInterfaces((Component)c2));
        for (Interface interface_ : usedInterfaces) {
            boolean partial = !implementedInterfaces.contains(interface_);
            for (ExchangeItemAllocation allocation : interface_.getOwnedExchangeItemAllocations()) {
                res.add(new InterfaceCommunication(allocation, interface_, partial));
            }
        }
        implementedInterfaces.removeAll(usedInterfaces);
        for (Interface interface_ : implementedInterfaces) {
            for (ExchangeItemAllocation allocation : interface_.getOwnedExchangeItemAllocations()) {
                res.add(new InterfaceCommunication(allocation, interface_, true));
            }
        }
        return res;
    }

    public static List<LinkCommunication> getLinkCommunications(Component c1, Component c2) {
        ArrayList<ExchangeItem> itemsToProcess = new ArrayList<ExchangeItem>();
        Hashtable<ExchangeItem, ArrayList<CommunicationLink>> item2receivers = new Hashtable<ExchangeItem, ArrayList<CommunicationLink>>();
        for (CommunicationLink link : CommunicationLinkExt.getAllReceiverCommunicationLink((Component)c2)) {
            ArrayList<CommunicationLink> targetingLinks;
            ExchangeItem item = link.getExchangeItem();
            if (item == null) continue;
            if (!itemsToProcess.contains(item)) {
                itemsToProcess.add(item);
            }
            if ((targetingLinks = (ArrayList<CommunicationLink>)item2receivers.get(item)) == null) {
                targetingLinks = new ArrayList<CommunicationLink>();
                item2receivers.put(item, targetingLinks);
            }
            targetingLinks.add(link);
        }
        ArrayList<LinkCommunication> res = new ArrayList<LinkCommunication>();
        for (CommunicationLink senderLink : CommunicationLinkExt.getAllSenderCommunicationLink((Component)c1)) {
            ExchangeItem item = senderLink.getExchangeItem();
            if (item == null) continue;
            itemsToProcess.remove(item);
            if (item2receivers.containsKey(item)) {
                for (CommunicationLink receiverLink : (List)item2receivers.get(item)) {
                    res.add(new LinkCommunication(senderLink, item, receiverLink));
                }
                continue;
            }
            res.add(new LinkCommunication(senderLink, item, null));
        }
        for (ExchangeItem item : itemsToProcess) {
            for (CommunicationLink receiverLink : (List)item2receivers.get(item)) {
                res.add(new LinkCommunication(null, item, receiverLink));
            }
        }
        return res;
    }

    public static List<UndefinedCommunication> getUndefinedCommunications(Component c1, Component c2, List<AbstractCommunication> existingCommunications) {
        ArrayList<ExchangeItem> items = new ArrayList<ExchangeItem>();
        items.addAll(SelectionAlgorithms.getExchangeItemsVisibleIn(c1));
        for (ExchangeItem item : SelectionAlgorithms.getExchangeItemsVisibleIn(c2)) {
            if (items.contains(item)) continue;
            items.add(item);
        }
        for (AbstractCommunication communication : existingCommunications) {
            items.remove(communication.exchangeItem);
        }
        ArrayList<UndefinedCommunication> res = new ArrayList<UndefinedCommunication>();
        for (ExchangeItem item : items) {
            res.add(new UndefinedCommunication(item));
        }
        return res;
    }

    public static Collection<ExchangeItem> getExchangeItemsVisibleIn(Component component) {
        ArrayList<ExchangeItem> items = new ArrayList<ExchangeItem>();
        for (AbstractExchangeItem item : ExchangeItemExt.getAllExchangeItems((EObject)component)) {
            if (!(item instanceof ExchangeItem)) continue;
            items.add((ExchangeItem)item);
        }
        return items;
    }

    public static MessageKind getDefaultMessageKind(boolean withReturn) {
        if (withReturn) {
            return MessageKind.SYNCHRONOUS_CALL;
        }
        return MessageKind.ASYNCHRONOUS_CALL;
    }

    public static Interface getTechnicalInterface(Component source, Component target) {
        ArrayList interfacesByCom = new ArrayList(source.getUsedInterfaces());
        interfacesByCom.retainAll((Collection<?>)target.getImplementedInterfaces());
        for (Interface interface_ : interfacesByCom) {
            if (interface_.isStructural()) continue;
            return interface_;
        }
        return null;
    }
}

