/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.helpers.operations.ILongRunningListener;
import org.polarsys.capella.core.model.handler.command.BasicCapellaDeleteCommand;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;

public class ExplorerLongRunningOperationsListener
implements ILongRunningListener {
    public boolean isListenerFor(Class<?> longRunningOperationClass) {
        return !BasicCapellaDeleteCommand.class.equals(longRunningOperationClass);
    }

    protected CapellaCommonNavigator getCapellaExplorerView() {
        IViewReference[] viewReferences;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = viewReferences = workbench.getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if ("capella.project.explorer".equals(viewReference.getId())) {
                try {
                    return (CapellaCommonNavigator)CapellaCommonNavigator.class.cast(viewReference.getView(false));
                }
                catch (Exception e) {
                    return null;
                }
            }
            ++n2;
        }
        return null;
    }

    public void operationAborted(Class<?> operationClass) {
        NotificationEnabler enableNotifications = new NotificationEnabler(true);
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)enableNotifications);
        } else {
            enableNotifications.run();
        }
    }

    public void operationEnded(Class<?> operationClass) {
        NotificationEnabler enableNotificationsAndRefresh = new NotificationEnabler(this, true){

            @Override
            public void run() {
                super.run();
                if (this.view != null) {
                    this.view.getCommonViewer().refresh();
                }
            }
        };
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)enableNotificationsAndRefresh);
        } else {
            enableNotificationsAndRefresh.run();
        }
    }

    public void operationStarting(Class<?> operationClass) {
        NotificationEnabler disableNotifications = new NotificationEnabler(false);
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)disableNotifications);
        } else {
            disableNotifications.run();
        }
    }

    private class NotificationEnabler
    implements Runnable {
        private final boolean enableNotifications;
        protected CapellaCommonNavigator view;

        public NotificationEnabler(boolean enable) {
            this.enableNotifications = enable;
        }

        @Override
        public void run() {
            this.view = ExplorerLongRunningOperationsListener.this.getCapellaExplorerView();
            if (this.view != null) {
                if (this.enableNotifications) {
                    this.view.enableContentNotifications();
                } else {
                    this.view.disableContentNotifications();
                }
            }
        }
    }
}

