/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaDeleteCommand;

public class DeallocateExchangeItemCommand
extends RecordingCommand {
    protected boolean cancelled = false;
    final ExchangeItem exchangeItem;
    final Collection<? extends EObject> targets;
    protected final ExecutionManager manager;

    public DeallocateExchangeItemCommand(TransactionalEditingDomain domain, ExchangeItem exchangeItem, Collection<? extends EObject> targets) {
        super(domain);
        this.manager = ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)domain);
        this.targets = targets;
        this.exchangeItem = exchangeItem;
    }

    protected void doExecute() {
        ArrayList<ExchangeItemAllocation> allocationsToDelete = new ArrayList<ExchangeItemAllocation>();
        for (EObject eObject : this.targets) {
            if (eObject instanceof FunctionalExchange) {
                ((FunctionalExchange)eObject).getExchangedItems().remove((Object)this.exchangeItem);
                continue;
            }
            if (eObject instanceof ComponentExchange) {
                ((ComponentExchange)eObject).getConvoyedInformations().remove((Object)this.exchangeItem);
                continue;
            }
            if (!(eObject instanceof Interface)) continue;
            for (EObject allocation : EObjectExt.getReferencers((EObject)this.exchangeItem, (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM)) {
                if (((ExchangeItemAllocation)allocation).getAllocatingInterface() != eObject) continue;
                allocationsToDelete.add((ExchangeItemAllocation)allocation);
            }
        }
        this.deleteAllocations(allocationsToDelete);
    }

    protected void deleteAllocations(Collection<ExchangeItemAllocation> allocationsToDelete) {
        CapellaDeleteCommand command;
        if (allocationsToDelete.isEmpty()) {
            return;
        }
        boolean confirmDeletion = CapellaDeleteCommand.confirmDeletion((ExecutionManager)this.manager, allocationsToDelete);
        if (confirmDeletion) {
            command = new CapellaDeleteCommand(this.manager, allocationsToDelete, false, false, true);
            if (!command.canExecute()) {
                this.cancelled = true;
                throw new OperationCanceledException();
            }
        } else {
            this.cancelled = true;
            throw new OperationCanceledException();
        }
        command.execute();
    }

    public Collection<?> getResult() {
        if (this.cancelled) {
            return Collections.singleton(Status.CANCEL_STATUS);
        }
        return super.getResult();
    }
}

