/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.la.ui.quickfix.resolver;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentRealization;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ProjectExt;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class LogicalComponentRealizedSystemComponentsResolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        final List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty()) {
            TransactionHelper.getExecutionManager((Collection)modelElements).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    SystemComponent systemComponent = null;
                    LogicalComponent logicalComponent = null;
                    Project project = ProjectExt.getProject((EObject)((EObject)modelElements.get(0)));
                    BlockArchitecture architecture = BlockArchitectureExt.getBlockArchitecture((EClass)CtxPackage.Literals.SYSTEM_ANALYSIS, (Project)project);
                    if (architecture != null) {
                        systemComponent = (SystemComponent)architecture.getSystem();
                        for (EObject obj : modelElements) {
                            if (!(obj instanceof LogicalComponent)) continue;
                            logicalComponent = (LogicalComponent)obj;
                        }
                        if (logicalComponent != null) {
                            EList componentRealizationList = logicalComponent.getOwnedComponentRealizations();
                            ComponentRealization cr = null;
                            if (!componentRealizationList.isEmpty()) {
                                cr = (ComponentRealization)componentRealizationList.get(0);
                                if (cr.getSourceElement() != logicalComponent) {
                                    cr.setSourceElement((TraceableElement)logicalComponent);
                                }
                                if (cr.getTargetElement() != systemComponent) {
                                    cr.setTargetElement((TraceableElement)systemComponent);
                                }
                            } else {
                                cr = CsFactory.eINSTANCE.createComponentRealization();
                                cr.setSourceElement((TraceableElement)logicalComponent);
                                cr.setTargetElement((TraceableElement)systemComponent);
                                logicalComponent.getOwnedComponentRealizations().add((Object)cr);
                            }
                        }
                    }
                }
            });
        }
        this.deleteMarker(marker);
    }

    public boolean enabled(Collection<IMarker> markers) {
        for (IMarker iMarker : markers) {
            List modelElements = this.getModelElements(iMarker);
            if (modelElements.isEmpty()) continue;
            Project project = ProjectExt.getProject((EObject)((EObject)modelElements.get(0)));
            BlockArchitecture architecture = BlockArchitectureExt.getBlockArchitecture((EClass)CtxPackage.Literals.SYSTEM_ANALYSIS, (Project)project);
            if (architecture == null) {
                return false;
            }
            Component cpkg = architecture.getSystem();
            if (cpkg != null) continue;
            return false;
        }
        return super.enabled(markers);
    }
}

