/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.image.Base64ImageHelper;
import org.eclipse.sirius.business.api.image.ImageManager;
import org.eclipse.sirius.business.api.image.ImageManagerProvider;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.RecordingCommandWithCustomUndo;

public class UpdateBase64ImageEncodingPreCommitListener
extends ResourceSetListenerImpl {
    private final DAnalysisSessionImpl dAnalysisSessionImpl;

    UpdateBase64ImageEncodingPreCommitListener(DAnalysisSessionImpl dAnalysisSessionImpl) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List notifications = event.getNotifications();
        final List<Notification> notificationToCreatedFiles = this.getNotificationToCreatedFiles(notifications);
        if (notificationToCreatedFiles.size() > 0) {
            RecordingCommandWithCustomUndo changeIdRecordingCommand = new RecordingCommandWithCustomUndo(this.dAnalysisSessionImpl.getTransactionalEditingDomain()){
                private Map<String, String> allCreatedFiles;
                {
                    super($anonymous0);
                    this.allCreatedFiles = new LinkedHashMap<String, String>();
                }

                @Override
                protected void doExecute() {
                    for (Notification notification : notificationToCreatedFiles) {
                        Map<String, String> createdFileAndUpdatedAttribute = new Base64ImageHelper().createFileAndUpdateAttribute((EObject)notification.getNotifier(), (EAttribute)notification.getFeature());
                        this.allCreatedFiles.putAll(createdFileAndUpdatedAttribute);
                    }
                }

                @Override
                public void undo() {
                    ImageManager imageManager = ImageManagerProvider.getImageManager();
                    imageManager.undoCreatedFiles(UpdateBase64ImageEncodingPreCommitListener.this.dAnalysisSessionImpl, this.allCreatedFiles);
                    super.undo();
                }

                @Override
                public void redo() {
                    ImageManager imageManager = ImageManagerProvider.getImageManager();
                    imageManager.redoCreateFiles(UpdateBase64ImageEncodingPreCommitListener.this.dAnalysisSessionImpl, this.allCreatedFiles);
                    super.redo();
                }
            };
            return changeIdRecordingCommand;
        }
        return null;
    }

    private List<Notification> getNotificationToCreatedFiles(List<Notification> notifications) {
        ArrayList<Notification> notificationToKeep = new ArrayList<Notification>();
        for (Notification notification : notifications) {
            Object featureObj = notification.getFeature();
            Object newValue = notification.getNewValue();
            Object notifierObj = notification.getNotifier();
            Set<EAttribute> eAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
            if (!eAttributes.contains(featureObj) || !(newValue instanceof String) || !(notifierObj instanceof EObject)) continue;
            String stringValue = (String)newValue;
            Pattern pattern = Pattern.compile("\"data:image/([a-zA-Z]{3,4});base64,(.*?)\"");
            Matcher matcher = pattern.matcher(stringValue);
            if (!matcher.find()) continue;
            notificationToKeep.add(notification);
        }
        return notificationToKeep;
    }
}

