/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions.decorators;

import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaActionsActivator;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.kitalpha.emde.model.Element;

public class ProtectedElementsDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    public static String ID = ProtectedElementsDecorator.class.getCanonicalName();
    LocalResourceManager manager;
    Collection<?> elements;

    public ProtectedElementsDecorator() {
        this(null);
    }

    public ProtectedElementsDecorator(Collection<?> elements) {
        this.elements = elements;
    }

    public static boolean isEnabled() {
        return PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider(ID) != null;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.isProtected(element)) {
            decoration.addOverlay(CapellaActionsActivator.getDefault().getImageDescriptor("lock.png"));
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private boolean isProtected(Object element) {
        if (element instanceof Element && CapellaDeleteAction.isElementProtected((Element)element)) {
            return this.elements == null || this.elements.contains(element);
        }
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        if (this.isProtected(element)) {
            if (this.manager == null) {
                this.manager = new LocalResourceManager(JFaceResources.getResources((Display)PlatformUI.getWorkbench().getDisplay()));
            }
            ImageDescriptor overlay = CapellaActionsActivator.getDefault().getImageDescriptor("lock.png");
            DecorationOverlayIcon icon = new DecorationOverlayIcon(image, overlay, 2);
            return this.manager.createImage((ImageDescriptor)icon);
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

