/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadOnlyCommand;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.helper.MiscHelper;
import org.polarsys.capella.common.ui.actions.AbstractTigAction;
import org.polarsys.capella.common.ui.toolkit.dialogs.TransferTreeListDialog;
import org.polarsys.capella.core.business.queries.capellacore.CapellaElement_OutgoingRequirement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Namespace;
import org.polarsys.capella.core.data.requirement.RequirementFactory;
import org.polarsys.capella.core.data.requirement.RequirementsTrace;
import org.polarsys.capella.core.platform.sirius.ui.actions.Messages;

public class RequirementManagerWizardAction
extends AbstractTigAction {
    protected CapellaElement getSelectedElement() {
        return (CapellaElement)super.getSelectedElement();
    }

    void handleChanges(CapellaElement selectedCapellaElement, List<Object> selectedElements) {
        ArrayList<AbstractTrace> eltsToDestroy = new ArrayList<AbstractTrace>(0);
        for (AbstractTrace trace : selectedCapellaElement.getOutgoingTraces()) {
            if (!(trace instanceof RequirementsTrace) || selectedElements.contains(trace.getTargetElement())) continue;
            eltsToDestroy.add(trace);
        }
        for (AbstractTrace trace : eltsToDestroy) {
            trace.destroy();
        }
        for (Object currentElement : selectedElements) {
            boolean alreadyTraced = false;
            for (AbstractTrace trace : selectedCapellaElement.getOutgoingTraces()) {
                if (!(trace instanceof RequirementsTrace) || trace.getTargetElement() != currentElement) continue;
                alreadyTraced = true;
            }
            if (alreadyTraced) continue;
            Namespace ns = null;
            ns = selectedCapellaElement instanceof Namespace ? (Namespace)selectedCapellaElement : (Namespace)EcoreUtil2.getFirstContainer((EObject)selectedCapellaElement, (EClass)CapellacorePackage.Literals.NAMESPACE);
            if (ns == null) continue;
            RequirementsTrace trace = RequirementFactory.eINSTANCE.createRequirementsTrace();
            trace.setSourceElement((TraceableElement)selectedCapellaElement);
            trace.setTargetElement((TraceableElement)currentElement);
            ns.getOwnedTraces().add((Object)trace);
        }
    }

    public void run(IAction action) {
        final CapellaElement selectedCapellaElement = this.getSelectedElement();
        final ArrayList availableElements = new ArrayList(0);
        final ArrayList currentElements = new ArrayList(0);
        AbstractReadOnlyCommand collectElementsCommand = new AbstractReadOnlyCommand(){

            public void run() {
                CapellaElement_OutgoingRequirement query = new CapellaElement_OutgoingRequirement();
                availableElements.addAll(query.getAvailableElements((EObject)selectedCapellaElement));
                currentElements.addAll(query.getCurrentElements((EObject)selectedCapellaElement, false));
            }
        };
        this.getExecutionManager().execute((ICommand)collectElementsCommand);
        TransferTreeListDialog dialog = new TransferTreeListDialog(this.getActiveShell(), Messages.RequirementManagerWizardAction_Title, Messages.RequirementManagerWizardAction_Message);
        dialog.setLeftInput(availableElements, null);
        dialog.setRightInput(currentElements, null);
        if (dialog.open() == 0) {
            final List selectedElements = MiscHelper.asList((Object[])dialog.getResult());
            AbstractReadWriteCommand performedChangesCommand = new AbstractReadWriteCommand(){

                public String getName() {
                    return Messages.RequirementManagerWizardAction_Command_Label;
                }

                public void run() {
                    RequirementManagerWizardAction.this.handleChanges(selectedCapellaElement, selectedElements);
                }
            };
            this.getExecutionManager().execute((ICommand)performedChangesCommand);
        }
    }
}

