/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.TraceUtil;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.CapellaModelFilter;

public class TraceTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private Text _statusBarText;
    private TraceableElement _currentElement;
    private CapellaModelFilter filter = new CapellaModelFilter();
    private boolean _isNewTrace = false;
    private int viewerExpandLevel;
    ISelectionStatusValidator _validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection_p) {
            if (selection_p.length == 1) {
                if (selection_p[0] instanceof NamedElement && (TraceTreeSelectionDialog.this._currentElement.equals(selection_p[0]) || !TraceTreeSelectionDialog.this._isNewTrace && TraceUtil.containsTraceElement(TraceTreeSelectionDialog.this._currentElement, (TraceableElement)((NamedElement)selection_p[0])))) {
                    Status status = new Status(2, "org.polarsys.capella.core.platform.eclipse.ui.trace", 2, Messages.getString("AddTraceWizard.warning_element_already_exists"), null);
                    TraceTreeSelectionDialog.this.updateStatus((IStatus)status);
                    return status;
                }
            } else if (selection_p.length == 0) {
                return new Status(2, "org.polarsys.capella.core.platform.eclipse.ui.trace", 2, Messages.getString("AddTraceWizard.warning_named_element"), null);
            }
            return new Status(0, "org.polarsys.capella.core.platform.eclipse.ui.trace", 0, "", null);
        }
    };

    public TraceTreeSelectionDialog(Shell parent_p, ILabelProvider labelProvider_p, ITreeContentProvider contentProvider_p, TraceableElement currentElement_p, boolean isNewTrace_p) {
        super(parent_p, labelProvider_p, contentProvider_p);
        this._currentElement = currentElement_p;
        this._isNewTrace = isNewTrace_p;
    }

    protected Control createDialogArea(Composite parent_p) {
        Composite composite = (Composite)super.createDialogArea(parent_p);
        this._statusBarText = new Text(composite, 2056);
        this._statusBarText.setEditable(false);
        this._statusBarText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.setValidator(this._validator);
        return composite;
    }

    protected TreeViewer createTreeViewer(Composite parent_p) {
        Group group = new Group(parent_p, 0x1000000);
        group.setText(Messages.getString("MdeElementTreeSelectionDialog.group_text"));
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label((Composite)group, 16384);
        label.setLayoutData((Object)new GridData(4, 0, true, false));
        label.setText(Messages.getString("MdeElementTreeSelectionDialog.filter_char"));
        Text text = new Text((Composite)group, 2048);
        text.setLayoutData((Object)new GridData(4, 0, true, false));
        text.addModifyListener((ModifyListener)this.filter);
        TreeViewer treeViewer = super.createTreeViewer(parent_p);
        treeViewer.addFilter((ViewerFilter)this.filter);
        treeViewer.expandToLevel(this.viewerExpandLevel);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection selection = event_p.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    TraceTreeSelectionDialog.this.updateStatusBar(elem);
                    if (elem instanceof TraceableElement) {
                        TraceTreeSelectionDialog.this.updateButtons(selection);
                    }
                }
            }
        });
        return treeViewer;
    }

    protected void updateButtons(ISelection selection) {
        boolean isOkEnabled = this.isOkToClose(selection);
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(isOkEnabled);
        }
    }

    protected boolean isOkToClose(ISelection selection) {
        boolean isOkEnabled = false;
        if (selection != null && !selection.isEmpty()) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (this._currentElement.equals(elem) || !this._isNewTrace && TraceUtil.containsTraceElement(this._currentElement, (TraceableElement)elem)) {
                this.updateStatus((IStatus)new Status(2, "org.polarsys.capella.core.platform.eclipse.ui.trace", 2, Messages.getString("AddTraceWizard.warning_element_already_exists"), null));
                isOkEnabled = false;
            } else {
                this.updateStatus((IStatus)new Status(0, "org.polarsys.capella.core.platform.eclipse.ui.trace", 0, "", null));
                isOkEnabled = true;
            }
        }
        return isOkEnabled;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4) && !status.matches(2));
        }
    }

    public String getElementPath(Object object_p) {
        if (object_p instanceof NamedElement) {
            NamedElement element = (NamedElement)object_p;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
            return this.getPath(systemEngineering, element);
        }
        return "";
    }

    public String getPath(SystemEngineering sysEng_p, NamedElement target_p) {
        StringBuffer path = new StringBuffer(target_p.getName());
        EObject container = target_p.eContainer();
        if (container instanceof NamedElement) {
            NamedElement parent = (NamedElement)target_p.eContainer();
            if (parent != sysEng_p) {
                path.insert(path.indexOf(path.toString()), String.valueOf(this.getPath(sysEng_p, parent)) + "::");
            } else {
                path.insert(path.indexOf(path.toString()), String.valueOf(parent.getName()) + "::");
            }
        }
        return path.toString();
    }

    private void updateStatusBar(Object element_p) {
        if (element_p == null) {
            this._statusBarText.setText("");
            return;
        }
        this._statusBarText.setText(this.getElementPath(element_p));
    }

    public void setViewerExpandLevel(int value) {
        this.viewerExpandLevel = value;
    }
}

