/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.lib.IdGenerator;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.platform.sirius.clipboard.Messages;
import org.polarsys.capella.core.platform.sirius.clipboard.util.BusinessHelper;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;

public final class MiscUtil {
    private MiscUtil() {
    }

    public static boolean transactionallyExecute(Collection<? extends EObject> selection, ICommand cmd) {
        boolean result = true;
        try {
            ExecutionManager em = TransactionHelper.getExecutionManager(selection);
            em.execute(cmd);
        }
        catch (Exception e) {
            String message = Messages.CapellaDiagramPasteAction_Failure;
            if (e.getMessage() != null) {
                message = e.getMessage();
            }
            StatusManager.getManager().handle((IStatus)new Status(2, "org.polarsys.capella.core.platform.sirius.clipboard", message, (Throwable)e));
            result = false;
        }
        return result;
    }

    public static ECrossReferenceAdapter getGlobalReferencer(EObject objectInSession) {
        Session session;
        ECrossReferenceAdapter result = null;
        EObject semanticElement = LayerUtil.toSemanticLevel(objectInSession);
        if (semanticElement != null && (session = SessionManager.INSTANCE.getSession(semanticElement)) != null) {
            result = session.getSemanticCrossReferencer();
        }
        return result;
    }

    public static ECrossReferenceAdapter getSemanticReferencer(EObject eobject) {
        TransactionalEditingDomain editingDomain = TransactionHelper.getEditingDomain((EObject)eobject);
        if (editingDomain instanceof SemanticEditingDomainFactory.SemanticEditingDomain) {
            return ((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain).getCrossReferencer();
        }
        return null;
    }

    public static Set<EObject> getOpposites(EObject element, EReference ref) {
        assert (ref != null);
        HashSet<EObject> result = new HashSet<EObject>();
        ECrossReferenceAdapter referencer = MiscUtil.getGlobalReferencer(element);
        if (referencer != null) {
            Collection settings = referencer.getNonNavigableInverseReferences(element);
            for (EStructuralFeature.Setting setting : settings) {
                if (!ref.equals(setting.getEStructuralFeature())) continue;
                result.add(setting.getEObject());
            }
        }
        return result;
    }

    public static EObject getOpposite(EObject element, EReference ref) {
        assert (ref != null);
        EObject result = null;
        Set<EObject> opposites = MiscUtil.getOpposites(element, ref);
        if (!opposites.isEmpty()) {
            result = opposites.iterator().next();
        }
        return result;
    }

    public static List<EStructuralFeature.Setting> getExternalSettingsForAddition(EObject element, Collection<EObject> internals) {
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        ECrossReferenceAdapter referencer = MiscUtil.getSemanticReferencer(element);
        if (referencer != null) {
            Collection settings = referencer.getInverseReferences(element);
            for (EStructuralFeature.Setting setting : settings) {
                EReference ref;
                if (!(setting.getEStructuralFeature() instanceof EReference) || (ref = (EReference)setting.getEStructuralFeature()).isContainer() || ref.isContainment() || !MiscUtil.supportsAddition(ref) || !BusinessHelper.getInstance().updateWithDuplicatedValues(ref) || EcoreUtil.isAncestor(internals, (EObject)setting.getEObject())) continue;
                result.add(setting);
            }
        }
        return result;
    }

    public static boolean supportsAddition(EReference reference) {
        return reference != null && reference.isMany() && !reference.isDerived() && reference.isChangeable();
    }

    public static <T> List<T> filter(Iterable<?> elements, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object current : elements) {
            if (!type.isInstance(current)) continue;
            result.add(type.cast(current));
        }
        return result;
    }

    public static <T extends EObject> List<T> getRoots(Collection<? extends T> elements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        HashSet<T> elts = new HashSet<T>(elements);
        for (EObject element : elts) {
            if (result.contains(element) || !MiscUtil.isRootAmong(element, elts)) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean isRootAmong(EObject element, Collection<? extends EObject> elements) {
        ArrayList<? extends EObject> filtered = new ArrayList<EObject>(elements);
        filtered.remove(element);
        return !EcoreUtil.isAncestor(filtered, (EObject)element);
    }

    public static EObject getCommonAncestor(Collection<? extends EObject> elements, boolean acceptSelf) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        Iterator<? extends EObject> it = elements.iterator();
        List<EObject> commonHierarchy = MiscUtil.getAncestors(it.next());
        while (it.hasNext()) {
            List<EObject> currentHierarchy = MiscUtil.getAncestors(it.next());
            commonHierarchy.retainAll(currentHierarchy);
        }
        if (!acceptSelf) {
            commonHierarchy.removeAll(elements);
        }
        if (commonHierarchy.isEmpty()) {
            return null;
        }
        return commonHierarchy.get(commonHierarchy.size() - 1);
    }

    public static EObject getCommonAncestor(EObject first, EObject second) {
        if (first == null || second == null) {
            return null;
        }
        return MiscUtil.getCommonAncestor(Arrays.asList(first, second), true);
    }

    private static List<EObject> getAncestors(EObject element) {
        if (element == null) {
            return new ArrayList<EObject>();
        }
        List<EObject> containerList = MiscUtil.getAncestors(element.eContainer());
        containerList.add(element);
        return containerList;
    }

    public static EObject getCorrespondingInStructure(EObject originRoot, EObject origin, EObject targetRoot, Filter filter) {
        assert (originRoot != null && origin != null && targetRoot != null);
        List<Object> path = MiscUtil.getContainmentPath(originRoot, origin, filter);
        EObject result = MiscUtil.getFromPath(targetRoot, path, filter);
        return result;
    }

    public static EObject getCorrespondingInStructure(EObject originRoot, EObject origin, EObject targetRoot) {
        return MiscUtil.getCorrespondingInStructure(originRoot, origin, targetRoot, null);
    }

    public static EObject getCorrespondingInStructure(List<? extends EObject> originRoots, EObject origin, List<? extends EObject> targetRoots, Filter filter) {
        assert (originRoots != null && origin != null && targetRoots != null);
        List<? extends EObject> filteredOriginRoots = filter == null ? originRoots : filter.filter(originRoots);
        List<? extends EObject> filteredTargetRoots = filter == null ? targetRoots : filter.filter(targetRoots);
        int max = Math.min(filteredOriginRoots.size(), filteredTargetRoots.size());
        int i = 0;
        while (i < max) {
            if (EcoreUtil.isAncestor((EObject)filteredOriginRoots.get(i), (EObject)origin)) {
                EObject found = MiscUtil.getCorrespondingInStructure(filteredOriginRoots.get(i), origin, filteredTargetRoots.get(i), filter);
                return found;
            }
            ++i;
        }
        return null;
    }

    public static EObject getCorrespondingInStructure(List<? extends EObject> originRoots, EObject origin, List<? extends EObject> targetRoots) {
        return MiscUtil.getCorrespondingInStructure(originRoots, origin, targetRoots, null);
    }

    public static void deleteRec(EObject elt) {
        EList contents = elt.eContents();
        for (EObject child : contents) {
            MiscUtil.deleteRec(child);
        }
        EcoreUtil.delete((EObject)elt);
    }

    public static UniqueEList<EObject> getContentSet(Collection<? extends EObject> elts) {
        UniqueEList result = new UniqueEList();
        for (EObject eObject : elts) {
            result.add((Object)eObject);
            TreeIterator iter = eObject.eAllContents();
            while (iter.hasNext()) {
                EObject current = (EObject)iter.next();
                result.add((Object)current);
            }
        }
        return result;
    }

    private static List<Object> getContainmentPath(EObject root, EObject child, Filter filter) {
        LinkedList<Object> result = new LinkedList<Object>();
        boolean success = MiscUtil.getContainmentPathRec(root, child, result, filter);
        if (success) {
            return result;
        }
        return null;
    }

    private static boolean getContainmentPathRec(EObject root, EObject child, LinkedList<Object> path, Filter filter) {
        if (root != child) {
            EObject parent = child.eContainer();
            if (parent != null) {
                EReference ref = child.eContainmentFeature();
                if (ref.isMany()) {
                    List values = (List)parent.eGet((EStructuralFeature)ref);
                    List filteredValues = filter == null ? values : filter.filter(values);
                    int index = filteredValues.indexOf(child);
                    path.addFirst(index);
                }
                path.addFirst(ref);
                return MiscUtil.getContainmentPathRec(root, parent, path, filter);
            }
            path.clear();
            return false;
        }
        return true;
    }

    private static EObject getFromPath(EObject root, List<Object> path, Filter filter) {
        if (path == null) {
            return null;
        }
        Iterator<Object> it = path.iterator();
        EObject current = root;
        while (it.hasNext() && current != null) {
            try {
                EReference ref = (EReference)it.next();
                if (ref.isMany()) {
                    Integer index = (Integer)it.next();
                    List values = (List)current.eGet((EStructuralFeature)ref);
                    List filteredValues = filter == null ? values : filter.filter(values);
                    current = (EObject)filteredValues.get(index);
                    continue;
                }
                current = (EObject)current.eGet((EStructuralFeature)ref);
            }
            catch (RuntimeException e) {
                current = null;
            }
        }
        return current;
    }

    public static void setNewId(EObject elt) {
        try {
            EcoreUtil.setID((EObject)elt, (String)IdGenerator.createId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static abstract class Filter {
        public abstract boolean qualifies(EObject var1);

        public final <T extends EObject> List<T> filter(Collection<T> collection) {
            ArrayList<EObject> result = new ArrayList<EObject>();
            for (EObject current : collection) {
                if (!this.qualifies(current)) continue;
                result.add(current);
            }
            return result;
        }
    }
}

