/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commandline.core;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.tools.report.config.persistence.ConfigurationInstance;
import org.polarsys.capella.common.tools.report.config.persistence.LogLevel;
import org.polarsys.capella.common.tools.report.config.persistence.OutputConfiguration;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.application.appstart.AbstractApplication;
import org.polarsys.capella.core.commandline.core.CommandLineArgumentHelper;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.ICommandLine;
import org.polarsys.capella.core.commandline.core.Messages;

public class CommandLineApp
extends AbstractApplication {
    private static final String POINT = "org.polarsys.capella.core.commandline.core.commandline";
    public static final String PLUGIN_ID = "org.polarsys.capella.core.commandline.core";
    private Logger __logger;

    public Object start(IApplicationContext context) throws Exception {
        super.start(context);
        String[] args = CommandLineArgumentHelper.parseContext(context);
        CommandLineArgumentHelper.getInstance().parseArgs(args);
        this.configureReportManagerForCommandLine();
        this.__logger = ReportManagerRegistry.getInstance().subscribe("Default");
        String appToLaunch = CommandLineArgumentHelper.getInstance().getAppid();
        if (appToLaunch == null) {
            String loggerMessage = String.valueOf(Messages.no_app_found) + CommandLineArgumentHelper.getInstance().getAppid();
            this.__logger.warn((Object)loggerMessage, (Throwable)new CommandLineException(loggerMessage));
            return IApplication.EXIT_RELAUNCH;
        }
        IConfigurationElement[] configElt = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT);
        ICommandLine app = this.geInstanceFromId(appToLaunch, configElt);
        if (app == null) {
            String loggerMessage = NLS.bind((String)Messages.unable_load_extension, (Object[])new String[]{appToLaunch, POINT});
            this.__logger.warn((Object)loggerMessage, (Throwable)new CommandLineException(loggerMessage));
            return IApplication.EXIT_RELAUNCH;
        }
        return this.launchApp(app, context);
    }

    private void configureReportManagerForCommandLine() {
        Collection configurationInstances = ReportManagerRegistry.getInstance().getConfigurations().values();
        for (ConfigurationInstance confInstance : configurationInstances) {
            List outputConfigurations = confInstance.getOutputConfiguration();
            for (OutputConfiguration outputConfiguration : outputConfigurations) {
                if (outputConfiguration.getOutputName() == "File" || outputConfiguration.getOutputName() == "Console") {
                    for (LogLevel ll : outputConfiguration.getLogLevel()) {
                        if (ll.getName() == "DEBUG") continue;
                        ll.setValue(true);
                    }
                    continue;
                }
                for (LogLevel ll : outputConfiguration.getLogLevel()) {
                    ll.setValue(false);
                }
            }
        }
    }

    private void isWorkspaceInUse() throws CommandLineException {
        try {
            if (!Platform.getInstanceLocation().lock()) {
                throw new CommandLineException(Messages.workspace_in_use);
            }
        }
        catch (IOException exception) {
            String loggerMessage = exception.getMessage();
            this.__logger.error((Object)loggerMessage, (Throwable)exception);
        }
    }

    private Integer launchApp(ICommandLine app, IApplicationContext context) {
        Integer status = IApplication.EXIT_OK;
        try {
            this.isWorkspaceInUse();
            app.parseContext(context);
            if (this.helpNeeded()) {
                app.printHelp();
                return status;
            }
            app.prepare(context);
            app.checkArgs(context);
            app.execute(context);
            app.postExecute(context);
        }
        catch (CommandLineException exception) {
            this.__logger.error((Object)exception.getMessage());
            status = IApplication.EXIT_RELAUNCH;
        }
        return status;
    }

    private boolean helpNeeded() {
        return CommandLineArgumentHelper.getInstance().isHelpNeeded();
    }

    private ICommandLine geInstanceFromId(String id, IConfigurationElement[] inputConfigElt) {
        IConfigurationElement[] iConfigurationElementArray = inputConfigElt;
        int n = inputConfigElt.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElt = iConfigurationElementArray[n2];
            String eltId = configElt.getAttribute("id");
            if (eltId != null && eltId.equals(id)) {
                try {
                    ICommandLine obj = (ICommandLine)configElt.createExecutableExtension("class");
                    return obj;
                }
                catch (CoreException exception) {
                    StringBuilder loggerMessage = new StringBuilder(Messages.could_not_create_exec);
                    this.__logger.error((Object)loggerMessage);
                }
            }
            ++n2;
        }
        return null;
    }

    public void stop() {
        super.stop();
    }
}

