/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.information.CollectionValue;
import org.polarsys.capella.core.data.information.datavalue.BinaryExpression;
import org.polarsys.capella.core.data.information.datavalue.ComplexValue;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.information.datavalue.UnaryExpression;
import org.polarsys.capella.core.data.information.datavalue.ValuePart;
import org.polarsys.capella.docgen.util.CapellaPropertyServices;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaDataValueServices {
    public static String getDataValueInformation(DataValue dataValue_p, String projectName, String outputFolder) {
        return CapellaDataValueServices.getDataValueInformation(dataValue_p, projectName, outputFolder, true);
    }

    private static String getDataValueInformation(DataValue dataValue_p, String projectName, String outputFolder, boolean displayType) {
        String unitString;
        String valueString;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<div id=\"" + CapellaServices.getAnchorId((EObject)dataValue_p) + "\">");
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)dataValue_p, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        buffer.append(dataValue_p.getName() != null && !dataValue_p.getName().trim().isEmpty() ? dataValue_p.getName() : "<i>[No Name]</i>");
        buffer.append("</b>");
        AbstractType abstractType = dataValue_p.getAbstractType();
        if (displayType && abstractType != null) {
            buffer.append(" : ");
            buffer.append(String.valueOf(CapellaServices.getHyperlinkFromElement((EObject)abstractType)) + " ");
        }
        if (!(valueString = CapellaDataValueServices.getValueOfDataValue(dataValue_p)).equals("")) {
            buffer.append(" = ");
            buffer.append(valueString);
        }
        if (dataValue_p instanceof NumericValue && ((NumericValue)dataValue_p).getUnit() != null && !(unitString = CapellaDataValueServices.getUnitOfNumericValue((NumericValue)dataValue_p)).equals("")) {
            buffer.append(" ");
            buffer.append(unitString);
        }
        if (dataValue_p.getSummary() != null) {
            buffer.append(" - ");
            buffer.append(dataValue_p.getSummary());
        }
        if (dataValue_p.getDescription() != null) {
            buffer.append("<p>");
            buffer.append(StringUtil.transformAREFString((EObject)dataValue_p, dataValue_p.getDescription(), projectName, outputFolder));
            buffer.append("</p>");
        }
        if (dataValue_p instanceof ComplexValue) {
            ArrayList<String> valuesPart = new ArrayList<String>();
            ComplexValue complexValue = (ComplexValue)dataValue_p;
            for (ValuePart currentValuePart : complexValue.getOwnedParts()) {
                String dataValueInformation;
                String valuePartInformation = CapellaPropertyServices.getValuePartInformation(currentValuePart, projectName, outputFolder);
                DataValue ownedValue = currentValuePart.getOwnedValue();
                if (ownedValue != null && !(dataValueInformation = CapellaDataValueServices.getDataValueInformation(ownedValue, projectName, outputFolder)).isEmpty()) {
                    valuePartInformation = String.valueOf(valuePartInformation) + "<br/>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "<ul class=\"generatedListWithBorder\">";
                    valuePartInformation = String.valueOf(valuePartInformation) + "<li>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "<span class=\"label\">";
                    valuePartInformation = String.valueOf(valuePartInformation) + "Owned value";
                    valuePartInformation = String.valueOf(valuePartInformation) + "</span>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "<ul class=\"generatedList\">";
                    valuePartInformation = String.valueOf(valuePartInformation) + "<li>";
                    valuePartInformation = String.valueOf(valuePartInformation) + dataValueInformation;
                    valuePartInformation = String.valueOf(valuePartInformation) + "</li>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "</ul>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "</li>";
                    valuePartInformation = String.valueOf(valuePartInformation) + "</ul>";
                }
                valuesPart.add(valuePartInformation);
            }
            if (valuesPart.size() > 0) {
                buffer.append("<ul class=\"generatedListWithBorder\">");
                buffer.append("<li>");
                buffer.append("<span class=\"label\">");
                buffer.append("Value Parts");
                buffer.append("</span>");
                buffer.append(StringUtil.stringListToBulette(valuesPart));
                buffer.append("</li>");
                buffer.append("</ul>");
            }
        }
        ArrayList<String> propertiesValues = new ArrayList<String>();
        for (AbstractPropertyValue currentAbstractPropertyValue : dataValue_p.getOwnedPropertyValues()) {
            propertiesValues.add(CapellaPropertyServices.getPropertyValueInformation(currentAbstractPropertyValue, projectName, outputFolder));
        }
        if (propertiesValues.size() > 0) {
            buffer.append("<ul class=\"generatedList\">");
            buffer.append("<li>");
            buffer.append("Property-values");
            buffer.append(StringUtil.stringListToBulette(propertiesValues));
            buffer.append("</li>");
            buffer.append("</ul>");
        }
        String ownedDataValueInformation = CapellaDataValueServices.getOwnedDataValueInformation(dataValue_p, projectName, outputFolder, displayType);
        buffer.append(ownedDataValueInformation);
        buffer.append("<br />");
        buffer.append("</div>");
        return buffer.toString();
    }

    private static String getOwnedDataValueInformation(DataValue dataValue_p, String projectName, String outputFolder, boolean displayType) {
        String result;
        EnumerationLiteral el_dataValue_p;
        DataValue domainValue;
        String subDataValueInformation;
        String subDataValueInformation2;
        UnaryExpression ue_dataValue_p;
        DataValue ownedOperand;
        StringBuffer buffer = new StringBuffer();
        if (dataValue_p instanceof UnaryExpression && (ownedOperand = (ue_dataValue_p = (UnaryExpression)dataValue_p).getOwnedOperand()) != null && !(subDataValueInformation2 = CapellaDataValueServices.getSubDataValueInformation(ownedOperand, projectName, outputFolder, displayType)).isEmpty()) {
            buffer.append(subDataValueInformation2);
        }
        if (dataValue_p instanceof BinaryExpression) {
            DataValue rightOperand;
            ue_dataValue_p = (BinaryExpression)dataValue_p;
            DataValue leftOperand = ue_dataValue_p.getOwnedLeftOperand();
            if (leftOperand != null && !(subDataValueInformation2 = CapellaDataValueServices.getSubDataValueInformation(leftOperand, projectName, outputFolder, displayType)).isEmpty()) {
                buffer.append(subDataValueInformation2);
            }
            if ((rightOperand = ue_dataValue_p.getOwnedRightOperand()) != null && !(subDataValueInformation = CapellaDataValueServices.getSubDataValueInformation(rightOperand, projectName, outputFolder, displayType)).isEmpty()) {
                buffer.append(subDataValueInformation);
            }
        }
        if (dataValue_p instanceof EnumerationLiteral && (domainValue = (el_dataValue_p = (EnumerationLiteral)dataValue_p).getDomainValue()) != null && !(subDataValueInformation2 = CapellaDataValueServices.getSubDataValueInformation("Domain value", domainValue, projectName, outputFolder, displayType)).isEmpty()) {
            buffer.append(subDataValueInformation2);
        }
        if (dataValue_p instanceof CollectionValue) {
            EList ownedElements;
            CollectionValue cv_dataValue_p = (CollectionValue)dataValue_p;
            DataValue ownedDefaultElement = cv_dataValue_p.getOwnedDefaultElement();
            if (ownedDefaultElement != null && !(subDataValueInformation2 = CapellaDataValueServices.getSubDataValueInformation("Defaut Element", ownedDefaultElement, projectName, outputFolder, displayType)).isEmpty()) {
                buffer.append(subDataValueInformation2);
            }
            if (!(ownedElements = cv_dataValue_p.getOwnedElements()).isEmpty() && !(subDataValueInformation = CapellaDataValueServices.getSubDataValueInformation("Owned Elements", (EList<DataValue>)ownedElements, projectName, outputFolder, displayType)).isEmpty()) {
                buffer.append(subDataValueInformation);
            }
        }
        if (!(result = buffer.toString()).trim().isEmpty()) {
            result = "<ul class=\"generatedListWithBorder\">" + result + "</ul>";
        }
        return result;
    }

    private static String getSubDataValueInformation(DataValue dataValue_p, String projectName, String outputFolder, boolean displayType) {
        return CapellaDataValueServices.getSubDataValueInformation(null, dataValue_p, projectName, outputFolder, displayType);
    }

    private static String getSubDataValueInformation(String sectionName, DataValue dataValue_p, String projectName, String outputFolder, boolean displayType) {
        StringBuffer buffer = new StringBuffer();
        if (sectionName != null && !sectionName.trim().isEmpty()) {
            buffer.append("<li>");
            buffer.append("<span class=\"label\">");
            buffer.append(String.valueOf(sectionName) + ": ");
            buffer.append("</span>");
            buffer.append("<ul class=\"generatedList\">");
        }
        buffer.append("<li>");
        String ownedDefaultElementHtml = CapellaDataValueServices.getDataValueInformation(dataValue_p, projectName, outputFolder, displayType);
        buffer.append(ownedDefaultElementHtml);
        buffer.append("</li>");
        if (sectionName != null && !sectionName.trim().isEmpty()) {
            buffer.append("</ul>");
            buffer.append("</li>");
        }
        return buffer.toString();
    }

    private static String getSubDataValueInformation(String sectionName, EList<DataValue> dataValues_p, String projectName, String outputFolder, boolean displayType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<li>");
        buffer.append("<span class=\"label\">");
        buffer.append(String.valueOf(sectionName) + ": ");
        buffer.append("</span>");
        buffer.append("<ul class=\"generatedList\">");
        for (DataValue dataValue : dataValues_p) {
            String ownedElementHtml = CapellaDataValueServices.getDataValueInformation(dataValue, projectName, outputFolder, displayType);
            buffer.append("<li>");
            buffer.append(ownedElementHtml);
            buffer.append("</li>");
        }
        buffer.append("</ul>");
        buffer.append("</li>");
        return buffer.toString();
    }

    public static String getUnitOfNumericValue(NumericValue numericValue_p) {
        return CapellaServices.getHyperlinkFromElement((EObject)numericValue_p.getUnit());
    }

    public static String getDataValueLiteralInformation(DataValue dataValue_p, String projectName, String outputFolder) {
        return CapellaDataValueServices.getDataValueInformation(dataValue_p, projectName, outputFolder, false);
    }

    public static String getValueOfDataValue(DataValue dataValue_p) {
        return CapellaDataValueServices.getValueOfDataValue(dataValue_p, false);
    }

    private static String getValueOfDataValue(DataValue dataValue_p, boolean simple) {
        if (dataValue_p instanceof LiteralNumericValue) {
            return ((LiteralNumericValue)dataValue_p).getValue();
        }
        if (dataValue_p instanceof BinaryExpression) {
            return ((BinaryExpression)dataValue_p).getExpression();
        }
        if (dataValue_p instanceof UnaryExpression) {
            return ((UnaryExpression)dataValue_p).getExpression();
        }
        if (dataValue_p instanceof LiteralBooleanValue) {
            return String.valueOf(((LiteralBooleanValue)dataValue_p).isValue());
        }
        if (dataValue_p instanceof LiteralStringValue) {
            String value = ((LiteralStringValue)dataValue_p).getValue();
            if (value == null) {
                value = "&lt;undefined&gt;";
            } else if (value.trim().isEmpty()) {
                value = "\"" + value + "\"";
            }
            return value;
        }
        if (dataValue_p instanceof CollectionValue) {
            Type type;
            CollectionValue collectionValue = (CollectionValue)dataValue_p;
            String collectionName = collectionValue.getName();
            if (collectionName == null || collectionName != null && collectionName.isEmpty()) {
                collectionName = String.valueOf(collectionName) + "<i>[No Name]</i>";
            }
            if ((type = collectionValue.getType()) != null) {
                collectionName = String.valueOf(collectionName) + " : " + CapellaServices.getFullDataPkgHierarchyLink((EObject)type);
            }
            return collectionName;
        }
        EObject referencedValue = CapellaDataValueServices.getReferencedValue(dataValue_p);
        if (referencedValue instanceof NamedElement) {
            if (simple) {
                String name = ((NamedElement)referencedValue).getName();
                if (name != null && name.length() > 0) {
                    return CapellaServices.getHyperlinkFromElement(referencedValue, name);
                }
                return CapellaServices.getHyperlinkFromElement(referencedValue);
            }
            return CapellaServices.getFullDataPkgHierarchyLink(referencedValue);
        }
        return "";
    }

    public static String getSimpleValueOfDataValue(DataValue dataValue_p) {
        return CapellaDataValueServices.getValueOfDataValue(dataValue_p, true);
    }

    public static EObject getReferencedValue(DataValue dataValue) {
        try {
            Method methodGetReferencedValue = dataValue.getClass().getMethod("getReferencedValue", new Class[0]);
            Object result = methodGetReferencedValue.invoke((Object)dataValue, new Object[0]);
            if (result instanceof EObject) {
                return (EObject)result;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

