/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.menu.dynamic.services;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.menu.dynamic.util.INamePrefixService;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class NamePrefixService
implements INamePrefixService {
    private Map<EClass, Function<EObject, String>> prefixes = new HashMap<EClass, Function<EObject, String>>();

    public NamePrefixService() {
        this.prefixes.put(OaPackage.Literals.ENTITY, o -> ComponentExt.isActor((EObject)o) ? "OA" : "OE");
        this.prefixes.put(CtxPackage.Literals.SYSTEM_COMPONENT, o -> ComponentExt.isActor((EObject)o) ? "SA" : "SC");
        this.prefixes.put(LaPackage.Literals.LOGICAL_COMPONENT, o -> ComponentExt.isActor((EObject)o) ? "LA" : "LC");
        this.prefixes.put(PaPackage.Literals.PHYSICAL_COMPONENT, o -> ComponentExt.isActor((EObject)o) ? "PA" : "PC");
    }

    public String getPrefix(EObject object) {
        EClass objectClass = object.eClass();
        Function<EObject, String> customNamePrefixFunction = this.prefixes.get(objectClass);
        if (customNamePrefixFunction != null) {
            return customNamePrefixFunction.apply(object);
        }
        return objectClass.getName();
    }
}

