/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.egf.genchain.diagram.javaaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainPackage;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.eclipse.egf.portfolio.genchain.tools.ui.wizards.Node;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.polarsys.kitalpha.egf.genchain.diagram.javaaction.AbstractExternalJavaAction;
import org.polarsys.kitalpha.egf.genchain.diagram.ui.dialog.ReorderDialog;

public class ReorderAction
extends AbstractExternalJavaAction {
    private static final String ID = "id";

    @Override
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EObject o = selections.iterator().next();
        if (o instanceof DSemanticDecorator) {
            o = ((DSemanticDecorator)o).getTarget();
        }
        if (o instanceof GenerationChain) {
            GenerationChain gc = (GenerationChain)o;
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ArrayList<Node> nodes = new ArrayList<Node>(50);
            HashMap<String, GenerationElement> elements = new HashMap<String, GenerationElement>();
            for (GenerationElement elem : gc.getElements()) {
                String id = "" + elem.hashCode();
                Node node = new Node(0);
                nodes.add(node);
                node.setName(elem.getName());
                node.getProperties().put(ID, id);
                elements.put(id, elem);
            }
            ReorderDialog dialog = new ReorderDialog(shell, nodes);
            if (dialog.open() == 0) {
                ArrayList<EObject> newList = new ArrayList<EObject>();
                for (Node node : dialog.getModels()) {
                    String id = (String)node.getProperties().get(ID);
                    newList.add((EObject)elements.get(id));
                }
                ReorderingCommand reorderingCommand = new ReorderingCommand(editingDomain, (GenerationElement)gc, newList);
                editingDomain.getCommandStack().execute((Command)reorderingCommand);
            }
        }
    }

    private static class ReorderingCommand
    extends RecordingCommand {
        private GenerationElement generationElement;
        private List<EObject> newList;

        public ReorderingCommand(TransactionalEditingDomain domain, GenerationElement generationElement, List<EObject> newList) {
            super(domain);
            this.generationElement = generationElement;
            this.newList = newList;
        }

        protected void doExecute() {
            this.generationElement.eSet((EStructuralFeature)GenerationChainPackage.Literals.GENERATION_CHAIN__ELEMENTS, this.newList);
        }
    }
}

