/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.EclipseSystemReader;
import org.eclipse.egit.core.internal.ReportingTypedConfigGetter;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.TypedConfigGetter;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.egit.core";
    private static Activator plugin;

    public static Activator getDefault() {
        return plugin;
    }

    public static IStatus error(String message, Throwable thr) {
        return new Status(4, PLUGIN_ID, 0, message, thr);
    }

    public static IStatus cancel(String message, Throwable thr) {
        return new Status(8, PLUGIN_ID, 0, message, thr);
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log(Activator.error(message, thr));
    }

    public static void logInfo(String message) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
    }

    public static IStatus warning(String message, Throwable thr) {
        return new Status(2, PLUGIN_ID, 0, message, thr);
    }

    public static void logWarning(String message, Throwable thr) {
        Activator.getDefault().getLog().log(Activator.warning(message, thr));
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        FS.FileStoreAttributes.setBackground((boolean)true);
        SystemReader.setInstance((SystemReader)new EclipseSystemReader(SystemReader.getInstance()));
        Config.setTypedConfigGetter((TypedConfigGetter)new ReportingTypedConfigGetter());
        try {
            WindowCacheConfig c = new WindowCacheConfig();
            c.setExposeStatsViaJmx(false);
            c.install();
        }
        catch (ExceptionInInitializerError | RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        Config.setTypedConfigGetter(null);
        SystemReader.setInstance(null);
        super.stop(context);
        plugin = null;
    }

    public static boolean autoStageDeletion() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "core_auto_stage_deletion", false, null);
    }

    public static boolean autoStageMoves() {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, "core_auto_stage_moves", false, null);
    }
}

