/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.re.project.diffmerge;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.scopes.ITreeDataScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.LibrariesPackage;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.KeyValue;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.StringType;
import org.polarsys.capella.core.data.information.datavalue.BinaryExpression;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class SkeletonMatchPolicy
implements IMatchPolicy<EObject> {
    private final Map<Object, String> matchIDs = new HashMap<Object, String>();

    public SkeletonMatchPolicy() {
        Enum k;
        List<ENamedElement> uniqueKeys = Arrays.asList(CapellamodellerPackage.Literals.PROJECT, CapellamodellerPackage.Literals.LIBRARY, OaPackage.Literals.OPERATIONAL_ANALYSIS, OaPackage.Literals.OPERATIONAL_ANALYSIS__OWNED_CONCEPT_PKG, OaPackage.Literals.OPERATIONAL_ANALYSIS__OWNED_ENTITY_PKG, OaPackage.Literals.OPERATIONAL_ANALYSIS__OWNED_ROLE_PKG, CtxPackage.Literals.SYSTEM_ANALYSIS, CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_MISSION_PKG, CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM_COMPONENT_PKG, CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_OPERATIONAL_ANALYSIS_REALIZATIONS, LaPackage.Literals.LOGICAL_ARCHITECTURE, LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT_PKG, LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_SYSTEM_ANALYSIS_REALIZATIONS, PaPackage.Literals.PHYSICAL_ARCHITECTURE, PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_LOGICAL_ARCHITECTURE_REALIZATIONS, PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT_PKG, EpbsPackage.Literals.EPBS_ARCHITECTURE, EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_CONFIGURATION_ITEM_PKG, EpbsPackage.Literals.EPBS_ARCHITECTURE__OWNED_PHYSICAL_ARCHITECTURE_REALIZATIONS, CapellamodellerPackage.Literals.PROJECT__OWNED_MODEL_ROOTS, LibrariesPackage.Literals.MODEL_INFORMATION);
        for (ENamedElement o : uniqueKeys) {
            this.matchIDs.put(o, EcoreUtil.getURI((EObject)o).toString());
        }
        List<EClass> allBlockArchitectures = Arrays.asList(OaPackage.Literals.OPERATIONAL_ANALYSIS, CtxPackage.Literals.SYSTEM_ANALYSIS, LaPackage.Literals.LOGICAL_ARCHITECTURE, PaPackage.Literals.PHYSICAL_ARCHITECTURE, EpbsPackage.Literals.EPBS_ARCHITECTURE);
        for (EClass c : allBlockArchitectures) {
            Key key = new Key(c, (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_ABSTRACT_CAPABILITY_PKG);
            this.matchIDs.put(key, key.toString());
            key = new Key(c, (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_DATA_PKG);
            this.matchIDs.put(key, key.toString());
            key = new Key(c, (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_INTERFACE_PKG);
            this.matchIDs.put(key, key.toString());
            key = new Key(c, (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__OWNED_REQUIREMENT_PKGS);
            this.matchIDs.put(key, key.toString());
            key = new Key(c, (EStructuralFeature)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE__OWNED_FUNCTION_PKG);
            this.matchIDs.put(key, key.toString());
            key = new Key(c, (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__SYSTEM);
            this.matchIDs.put(key, key.toString());
        }
        Enum[] enumArray = RootFunction.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            k = enumArray[n2];
            this.matchIDs.put(k, k.toString());
            ++n2;
        }
        enumArray = PredefinedType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            k = enumArray[n2];
            this.matchIDs.put(k, k.toString());
            ++n2;
        }
    }

    public String getMatchID(EObject element_p, ITreeDataScope<EObject> scope_p) {
        String result = null;
        if (element_p instanceof AbstractTrace && ((AbstractTrace)element_p).getSourceElement() != null && ((AbstractTrace)element_p).getTargetElement() != null) {
            result = String.format("t[(%s)%s=>%s]", element_p.eClass().getName(), this.getMatchID((EObject)((AbstractTrace)element_p).getSourceElement(), scope_p), this.getMatchID((EObject)((AbstractTrace)element_p).getTargetElement(), scope_p));
        }
        if (result == null) {
            result = this.matchIDs.get(element_p.eClass());
        }
        if (result == null) {
            result = this.matchIDs.get(element_p.eContainingFeature());
        }
        if (result == null && element_p.eContainer() != null) {
            result = this.matchIDs.get(new Key(element_p.eContainer().eClass(), element_p.eContainingFeature()));
        }
        if (result == null) {
            result = this.matchIDs.get((Object)RootFunction.getRootFunctionKey(element_p));
        }
        if (result == null) {
            result = this.matchIDs.get((Object)PredefinedType.getPredefinedType(element_p));
        }
        if (element_p instanceof Component && element_p.equals(BlockArchitectureExt.getRootBlockArchitecture((EObject)element_p).getSystem())) {
            result = this.matchIDs.get(new Key(BlockArchitectureExt.getRootBlockArchitecture((EObject)element_p).eClass(), (EStructuralFeature)CsPackage.Literals.BLOCK_ARCHITECTURE__SYSTEM));
        }
        if (result == null && element_p.eContainer() != null) {
            String typeMatchId;
            Type type;
            String parentMatch;
            if (element_p instanceof LiteralBooleanValue && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + element_p.eContainingFeature().getName() + "@boolean:" + ((LiteralBooleanValue)element_p).getName();
            }
            if (element_p instanceof LiteralStringValue && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + element_p.eContainingFeature().getName() + ";string:" + ((LiteralStringValue)element_p).getName();
            }
            if (element_p instanceof LiteralNumericValue && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + element_p.eContainingFeature().getName() + ";numeric: " + ((LiteralNumericValue)element_p).getValue();
            }
            if (element_p instanceof BinaryExpression && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + ((InternalEObject)element_p.eContainer()).eURIFragmentSegment(element_p.eContainingFeature(), element_p);
            }
            if (element_p instanceof EnumerationPropertyLiteral && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + ((EnumerationPropertyLiteral)element_p).getName();
            }
            if (element_p instanceof EnumerationPropertyType && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + ((EnumerationPropertyType)element_p).getName();
            }
            if (element_p instanceof KeyValue && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";" + element_p.eContainingFeature().getName() + ";" + ((KeyValue)element_p).getKey();
            }
            if (element_p instanceof Part && (type = ((Part)element_p).getType()) != null && type.getTypedElements().size() == 1 && (typeMatchId = this.matchIDs.get(type.eContainingFeature())) != null) {
                result = String.valueOf(typeMatchId) + "Part";
            }
            if (element_p instanceof StateMachine && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";stateMachine:" + ((StateMachine)element_p).getName();
            }
            if (element_p instanceof Region && (parentMatch = this.getMatchID(element_p.eContainer(), scope_p)) != null) {
                result = String.valueOf(parentMatch) + ";region:" + ((Region)element_p).getName();
            }
        }
        if (result == null) {
            result = "UNMATCHABLE-ELEMENT-" + EcoreUtil.getID((EObject)element_p);
        }
        return result;
    }

    public Comparator<?> getMatchIDComparator() {
        return null;
    }

    public boolean keepMatchIDs() {
        return true;
    }

    private static final class Key {
        private final EClass eContainerClass;
        private final EStructuralFeature eContainingFeature;

        private Key(EClass eContainerClass, EStructuralFeature eContainingFeature) {
            this.eContainerClass = eContainerClass;
            this.eContainingFeature = eContainingFeature;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.eContainerClass, this.eContainingFeature});
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj.getClass() == Key.class) {
                result = this.eContainerClass == ((Key)obj).eContainerClass && this.eContainingFeature == ((Key)obj).eContainingFeature;
            }
            return result;
        }

        public String toString() {
            return EcoreUtil.getURI((EObject)this.eContainerClass) + ";" + EcoreUtil.getURI((EObject)this.eContainingFeature);
        }
    }

    private static enum PredefinedType {
        PREDEFINED_DATA_PKG(NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name, InformationPackage.Literals.DATA_PKG),
        PREDEFINED_BOOLEAN(NamingConstants.PredefinedTypesCmd_boolean_name, DatatypePackage.Literals.BOOLEAN_TYPE),
        PREDEFINED_BYTE(NamingConstants.PredefinedTypesCmd_byte_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_CHAR(NamingConstants.PredefinedTypesCmd_char_name, DatatypePackage.Literals.STRING_TYPE),
        PREDEFINED_DOUBLE(NamingConstants.PredefinedTypesCmd_double_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_FLOAT(NamingConstants.PredefinedTypesCmd_float_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_HEXADECIMAL(NamingConstants.PredefinedTypesCmd_hexadecimal_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_INTEGER(NamingConstants.PredefinedTypesCmd_integer_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_LONG(NamingConstants.PredefinedTypesCmd_long_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_LONGLONG(NamingConstants.PredefinedTypesCmd_longLong_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_SHORT(NamingConstants.PredefinedTypesCmd_short_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_STRING(NamingConstants.PredefinedTypesCmd_string_name, DatatypePackage.Literals.STRING_TYPE),
        PREDEFINED_UNSIGNED_INTEGER(NamingConstants.PredefinedTypesCmd_unsignedInteger_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_UNSIGNED_SHORT(NamingConstants.PredefinedTypesCmd_unsignedShort_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_UNSIGNED_LONG_LONG(NamingConstants.PredefinedTypesCmd_unsignedLongLong_name, DatatypePackage.Literals.NUMERIC_TYPE),
        PREDEFINED_UNSIGNED_LONG(NamingConstants.PredefinedTypesCmd_unsignedLong_name, DatatypePackage.Literals.NUMERIC_TYPE);

        private final String name;
        private final EClass type;

        private PredefinedType(String name, EClass type) {
            this.name = name;
            this.type = type;
        }

        static PredefinedType getPredefinedType(EObject e) {
            PredefinedType result = null;
            if (e instanceof DataPkg && PredefinedType.PREDEFINED_DATA_PKG.name.equals(((DataPkg)e).getName()) && EcoreUtil2.getFirstContainer((EObject)e, (EClass)CtxPackage.Literals.SYSTEM_ANALYSIS) != null) {
                result = PREDEFINED_DATA_PKG;
            }
            if (result == null && (e instanceof NumericType || e instanceof StringType || e instanceof BooleanType)) {
                PredefinedType[] predefinedTypeArray = PredefinedType.values();
                int n = predefinedTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PredefinedType key = predefinedTypeArray[n2];
                    if (key.name.equals(((NamedElement)e).getName()) && key.type.isInstance((Object)e) && PredefinedType.getPredefinedType(e.eContainer()) == PREDEFINED_DATA_PKG) {
                        result = key;
                    }
                    ++n2;
                }
            }
            return result;
        }
    }

    private static enum RootFunction {
        ROOT_OPERATIONAL_ACTIVITY,
        ROOT_SYSTEM_FUNCTION,
        ROOT_LOGICAL_FUNCTION,
        ROOT_PHYSICAL_FUNCTION;


        static RootFunction getRootFunctionKey(EObject e) {
            if (RootFunction.isRootFunction(e)) {
                if (e instanceof OperationalActivity) {
                    return ROOT_OPERATIONAL_ACTIVITY;
                }
                if (e instanceof SystemFunction) {
                    return ROOT_SYSTEM_FUNCTION;
                }
                if (e instanceof LogicalFunction) {
                    return ROOT_LOGICAL_FUNCTION;
                }
                if (e instanceof PhysicalFunction) {
                    return ROOT_PHYSICAL_FUNCTION;
                }
            }
            return null;
        }

        private static boolean isRootFunction(EObject eObject) {
            return eObject instanceof AbstractFunction && EcoreUtil2.getFirstContainer((EObject)eObject, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION) == null;
        }
    }
}

