/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.diagram.ui.internal.quickfix.ImageMarkerResolution;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class ImagePathResolver
extends AbstractCapellaMarkerResolution {
    protected Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");

    public void run(IMarker marker_p) {
        List modelElements = this.getModelElements(marker_p);
        if (modelElements.size() < 1) {
            return;
        }
        EObject target = (EObject)modelElements.get(0);
        Optional sessionOpt = Session.of((EObject)target);
        Diagnostic diagnostic = MarkerViewHelper.getDiagnostic((IMarker)marker_p);
        ImagePathWrappingStatus imagePathStatus = null;
        if (diagnostic instanceof ConstraintStatusDiagnostic && ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus() instanceof ImagePathWrappingStatus) {
            imagePathStatus = (ImagePathWrappingStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus();
        }
        if (imagePathStatus != null && sessionOpt.isPresent()) {
            TransactionalEditingDomain ted = ((Session)sessionOpt.get()).getTransactionalEditingDomain();
            String notReachableImagePath = imagePathStatus.getNotReachableImagePath();
            boolean fixSucceeded = FileProvider.getDefault().exists((IPath)new Path(notReachableImagePath));
            if (!fixSucceeded) {
                DRepresentation dRepresentation;
                ImagePathWrappingStatus.ImagePathTarget imagePathTarget = imagePathStatus.getImagePathTarget();
                EAttribute eAttribute = imagePathStatus.getEAttribute();
                if (ImagePathWrappingStatus.ImagePathTarget.DREPRESENTATION_DESCRIPTOR.equals((Object)imagePathTarget) && eAttribute != null && target instanceof DRepresentationDescriptor) {
                    DRepresentationDescriptor representationDescriptor = (DRepresentationDescriptor)target;
                    DialectUIManager.INSTANCE.openEditor((Session)sessionOpt.get(), representationDescriptor.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
                    fixSucceeded = ImageMarkerResolution.fixImagePathInRichText((EObject)representationDescriptor, (String)eAttribute.getName(), (String)notReachableImagePath, (TransactionalEditingDomain)ted);
                } else if (ImagePathWrappingStatus.ImagePathTarget.SEMANTIC_TARGET.equals((Object)imagePathTarget) && eAttribute != null) {
                    fixSucceeded = ImageMarkerResolution.fixImagePathInRichText((EObject)target, (String)eAttribute.getName(), (String)notReachableImagePath, (TransactionalEditingDomain)ted);
                } else if (ImagePathWrappingStatus.ImagePathTarget.WORKSPACE_IMAGE.equals((Object)imagePathTarget) && target instanceof DSemanticDecorator && (dRepresentation = this.getRepresentation((DSemanticDecorator)target)) != null) {
                    DialectUIManager.INSTANCE.openEditor((Session)sessionOpt.get(), dRepresentation, (IProgressMonitor)new NullProgressMonitor());
                    fixSucceeded = ImageMarkerResolution.fixWorkspaceImagePath((EObject)target, (String)notReachableImagePath, (TransactionalEditingDomain)ted);
                }
            }
            if (fixSucceeded) {
                try {
                    marker_p.delete();
                }
                catch (CoreException exception_p) {
                    this._logger.error((Object)("Exception while deleting marker : " + exception_p.toString()));
                }
            }
        }
    }

    private DRepresentation getRepresentation(DSemanticDecorator dSemanticDecorator) {
        DSemanticDecorator current = dSemanticDecorator;
        while (current != null) {
            if (current instanceof DRepresentation) {
                return (DRepresentation)current;
            }
            current = current.eContainer();
        }
        return null;
    }
}

