/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathConstraint;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.handler.validation.CapellaDiagnostician;

public class ImagePathOnRichTextAttributeCheck
extends ImagePathConstraint {
    public IStatus validate(IValidationContext ctx) {
        boolean calledByCapella = Stream.of(Thread.currentThread().getStackTrace()).filter(ste -> ste.getClassName().equals(CapellaDiagnostician.class.getName())).findFirst().isPresent();
        if (!calledByCapella) {
            return ctx.createSuccessStatus();
        }
        EObject target = ctx.getTarget();
        ArrayList failureStatuses = new ArrayList();
        if (target instanceof CapellaElement) {
            Session.of((EObject)target).ifPresent(session -> {
                Collection representationDescriptors = DialectManager.INSTANCE.getRepresentationDescriptors(target, session);
                for (DRepresentationDescriptor dRepresentationDescriptor : representationDescriptors) {
                    failureStatuses.addAll(this.validateImagePathInRichText((EObject)dRepresentationDescriptor, ctx, ImagePathWrappingStatus.ImagePathTarget.DREPRESENTATION_DESCRIPTOR));
                }
            });
        }
        failureStatuses.addAll(this.validateImagePathInRichText(target, ctx, ImagePathWrappingStatus.ImagePathTarget.SEMANTIC_TARGET));
        IStatus returnedStatus = null;
        returnedStatus = failureStatuses.isEmpty() ? ctx.createSuccessStatus() : (failureStatuses.size() == 1 ? (IStatus)failureStatuses.get(0) : ConstraintStatus.createMultiStatus((IValidationContext)ctx, failureStatuses));
        return returnedStatus;
    }
}

