/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.sirius.validation.ddiagram;

import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.diagram.ui.internal.quickfix.ImageMarkerMassResolution;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.validation.ConstraintStatusDiagnostic;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class ImagePathMassResolver
extends AbstractCapellaMarkerResolution {
    protected Logger _logger = ReportManagerRegistry.getInstance().subscribe("Model Validation");

    public void run(IMarker marker_p) {
        List modelElements = this.getModelElements(marker_p);
        if (modelElements.size() < 1) {
            return;
        }
        EObject target = (EObject)modelElements.get(0);
        Optional sessionOpt = Session.of((EObject)target);
        Diagnostic diagnostic = MarkerViewHelper.getDiagnostic((IMarker)marker_p);
        ImagePathWrappingStatus imagePathStatus = null;
        if (diagnostic instanceof ConstraintStatusDiagnostic && ((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus() instanceof ImagePathWrappingStatus) {
            imagePathStatus = (ImagePathWrappingStatus)((ConstraintStatusDiagnostic)diagnostic).getConstraintStatus();
        }
        if (imagePathStatus != null && sessionOpt.isPresent()) {
            String notReachableImagePath = imagePathStatus.getNotReachableImagePath();
            boolean fixSucceeded = FileProvider.getDefault().exists((IPath)new Path(notReachableImagePath));
            if (!fixSucceeded) {
                fixSucceeded = ImageMarkerMassResolution.fixImagePathMassively((Session)((Session)sessionOpt.get()), (String)notReachableImagePath);
            }
            if (fixSucceeded) {
                try {
                    marker_p.delete();
                }
                catch (CoreException exception_p) {
                    this._logger.error((Object)("Exception while deleting marker : " + exception_p.toString()));
                }
            }
        }
    }

    private DRepresentation getRepresentation(DSemanticDecorator dSemanticDecorator) {
        DSemanticDecorator current = dSemanticDecorator;
        while (current != null) {
            if (current instanceof DRepresentation) {
                return (DRepresentation)current;
            }
            current = current.eContainer();
        }
        return null;
    }
}

