/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.obfuscator.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.model.obfuscator.ObfuscatorHelper;

public class ObfuscateRepresentationCommand
extends AbstractReadWriteCommand {
    private DRepresentationDescriptor descriptor;

    public ObfuscateRepresentationCommand(DRepresentationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void run() {
        if (this.descriptor != null) {
            this.obfuscateDRepresentation(this.descriptor);
            this.descriptor = null;
        }
    }

    protected void obfuscateDRepresentation(DRepresentationDescriptor descriptor) {
        descriptor.setName(ObfuscatorHelper.generateUnreadableString(descriptor.getName()));
        descriptor.setDocumentation(ObfuscatorHelper.generateUnreadableString(descriptor.getDocumentation()));
        DRepresentation representation = descriptor.getRepresentation();
        if (representation != null) {
            this.obfuscateGMFDiagram(representation);
            this.obfuscateRepresentationElements(representation);
        }
    }

    protected void obfuscateGMFDiagram(DRepresentation representation) {
        for (EObject diag : this.getOpposites((EObject)representation, NotationPackage.eINSTANCE.getView_Element())) {
            if (diag == null || !(diag instanceof Diagram)) continue;
            Diagram diagram = (Diagram)diag;
            for (Object child : diagram.getPersistedChildren()) {
                if (child == null) continue;
                if (child instanceof Shape) {
                    this.obfuscateShape((Shape)child);
                    continue;
                }
                if (!(child instanceof Node)) continue;
                this.obfuscateNode((Node)child);
            }
        }
    }

    protected void obfuscateNode(Node parent) {
        Style style;
        if (parent == null) {
            return;
        }
        for (Object child : parent.getPersistedChildren()) {
            if (child == null) continue;
            if (child instanceof Shape) {
                this.obfuscateShape((Shape)child);
                continue;
            }
            if (!(child instanceof Node)) continue;
            this.obfuscateNode((Node)child);
        }
        if (parent.getElement() == null && (style = parent.getStyle(NotationPackage.Literals.SHAPE_STYLE)) instanceof ShapeStyle) {
            ShapeStyle ss = (ShapeStyle)style;
            ss.setDescription(ObfuscatorHelper.generateUnreadableString(ss.getDescription()));
        }
    }

    protected void obfuscateShape(Shape shape) {
        if (shape == null) {
            return;
        }
        shape.setDescription(ObfuscatorHelper.generateUnreadableString(shape.getDescription()));
    }

    protected void obfuscateRepresentationElements(DRepresentation representation) {
        TreeIterator content = representation.eAllContents();
        while (content.hasNext()) {
            EObject object = (EObject)content.next();
            if (object == null || object.eIsProxy() || !(object instanceof DRepresentationElement)) continue;
            this.obfuscateDRepresentationElement((DRepresentationElement)object);
        }
    }

    protected void obfuscateDRepresentationElement(DRepresentationElement dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getName();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setName(semanticName);
                    } else {
                        dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setName(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
        if (dElement instanceof DDiagramElement) {
            this.obfuscateDDiagramElement((DDiagramElement)dElement);
        }
        if (dElement instanceof DLine) {
            this.obfuscateDLine((DLine)dElement);
        }
        if (dElement instanceof DColumn) {
            this.obfuscateDColumn((DColumn)dElement);
        }
        if (dElement instanceof DCell) {
            this.obfuscateDCell((DCell)dElement);
        }
    }

    protected void obfuscateDDiagramElement(DDiagramElement object) {
        DDiagramElement dElement = object;
        EObject target = dElement.getTarget();
        String name = dElement.getTooltipText();
        if (name != null && name.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setTooltipText(semanticName);
                    } else {
                        dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
                    }
                } else {
                    dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
                }
            } else {
                dElement.setTooltipText(ObfuscatorHelper.generateUnreadableString(name));
            }
        }
        if (dElement instanceof DEdge) {
            this.obfuscateDEdge((DEdge)dElement);
        }
    }

    protected void obfuscateDEdge(DEdge object) {
        String value = object.getBeginLabel();
        if (value != null && value.length() > 0) {
            object.setBeginLabel(ObfuscatorHelper.generateUnreadableString(value));
        }
        if ((value = object.getEndLabel()) != null && value.length() > 0) {
            object.setEndLabel(ObfuscatorHelper.generateUnreadableString(value));
        }
    }

    protected void obfuscateDLine(DLine dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected void obfuscateDColumn(DColumn dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected void obfuscateDCell(DCell dElement) {
        EObject target = dElement.getTarget();
        String value = dElement.getLabel();
        if (value != null && value.length() > 0 && !"X".equals(value)) {
            if (target != null && !target.eIsProxy()) {
                if (target instanceof AbstractNamedElement) {
                    String semanticName = ((AbstractNamedElement)target).getName();
                    if (semanticName != null && semanticName.length() > 0) {
                        dElement.setLabel(semanticName);
                    } else {
                        dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                    }
                } else {
                    dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
                }
            } else {
                dElement.setLabel(ObfuscatorHelper.generateUnreadableString(value));
            }
        }
    }

    protected List<EObject> getOpposites(EObject element, EReference ref) {
        UniqueEList result = new UniqueEList();
        ECrossReferenceAdapter referencer = this.getGlobalReferencer(element);
        if (referencer != null) {
            Collection settings = referencer.getNonNavigableInverseReferences(element);
            for (EStructuralFeature.Setting setting : settings) {
                if (!ref.equals(setting.getEStructuralFeature())) continue;
                result.add(setting.getEObject());
            }
        }
        return Collections.unmodifiableList(result);
    }

    protected ECrossReferenceAdapter getGlobalReferencer(EObject elementInSession) {
        Session session;
        ECrossReferenceAdapter result = null;
        EObject semanticElement = ((DSemanticDecorator)elementInSession).getTarget();
        if (semanticElement != null && (session = SessionManager.INSTANCE.getSession(semanticElement)) != null) {
            result = session.getSemanticCrossReferencer();
        }
        return result;
    }
}

