/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import java.util.List;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionItemService;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionModel;

public class DecompositionDragAndDrop {
    private DragSource _dragSource;
    private DropTarget _dropTarget;
    private DecompositionModel _decompModel;
    private TreeViewer _sourceViewer;
    private TreeViewer _targetViewer;
    private LocalSelectionTransfer _sourceTransfer = LocalSelectionTransfer.getTransfer();
    private LocalSelectionTransfer _targetTransfer = LocalSelectionTransfer.getTransfer();
    static Object currentElement;

    public DecompositionDragAndDrop(Tree sourceTree_p, DecompositionModel decompModel_p) {
        this._dragSource = new DragSource((Control)sourceTree_p, 3);
        this._dropTarget = new DropTarget((Control)sourceTree_p, 3);
        this._dragSource.setTransfer(new Transfer[]{this._sourceTransfer});
        this._dropTarget.setTransfer(new Transfer[]{this._targetTransfer});
        LCDragSourceListener dragSourceListener = new LCDragSourceListener(sourceTree_p);
        this._dragSource.addDragListener((DragSourceListener)dragSourceListener);
        LCDropTargetAdapter dropTargetAdapter = new LCDropTargetAdapter();
        dragSourceListener.setDropTargetAdapter(dropTargetAdapter);
        this._dropTarget.addDropListener((DropTargetListener)dropTargetAdapter);
        this._decompModel = decompModel_p;
    }

    public boolean dropTargetValidate(DropTargetEvent event, Tree dragSourceTree_p) {
        if (event.item != null) {
            TreeItem item = (TreeItem)event.item;
            Object treeID = item.getParent().getData("TREEID");
            boolean checkExistence = false;
            if (treeID.equals("TARGET_TREE")) {
                checkExistence = true;
            }
            if (!item.getParent().equals(dragSourceTree_p) && this._decompModel.isDropAllowed(item.getData()) && this._decompModel.isDragAllowed(currentElement)) {
                if (checkExistence) {
                    if (this._decompModel.isDropPossible(item.getData(), currentElement)) {
                        if (event.detail != 1 && event.detail != 2) {
                            event.detail = 2;
                        }
                    } else {
                        event.detail = 0;
                    }
                } else if (event.detail != 1 && event.detail != 2) {
                    event.detail = 2;
                }
            } else {
                event.detail = 0;
            }
        } else {
            event.detail = 0;
        }
        return event.detail != 0;
    }

    public DragSource getDragSource() {
        return this._dragSource;
    }

    public void setDragSource(DragSource dragSource_p) {
        this._dragSource = dragSource_p;
    }

    public DropTarget getDropTarget() {
        return this._dropTarget;
    }

    public void setDropTarget(DropTarget dropTarget_p) {
        this._dropTarget = dropTarget_p;
    }

    public boolean handleAttach(Object node_p, Object item_p) {
        if (node_p instanceof DecompositionComponent && item_p instanceof DecompositionItem) {
            DecompositionItem itf = (DecompositionItem)item_p;
            DecompositionComponent component = (DecompositionComponent)node_p;
            return this._decompModel.attachInterface(component, itf.getCopy());
        }
        if (node_p instanceof DecompositionComponent && item_p instanceof DecompositionItemService) {
            DecompositionItemService sce = (DecompositionItemService)item_p;
            DecompositionComponent component = (DecompositionComponent)node_p;
            return this._decompModel.attachService(component, sce.getCopy(), sce.getParentDecompositionItem());
        }
        if (node_p instanceof DecompositionItem && item_p instanceof DecompositionItemService) {
            DecompositionItemService sce = (DecompositionItemService)item_p;
            DecompositionItem itf = (DecompositionItem)node_p;
            return this._decompModel.attachService(itf, sce.getCopy(), sce.getParentDecompositionItem());
        }
        return false;
    }

    public boolean handleDetach(Object node_p, Object item_p) {
        DecompositionComponent component = (DecompositionComponent)node_p;
        DecompositionItem item = (DecompositionItem)item_p;
        return this._decompModel.detachInterface(component, item);
    }

    public boolean handleDetach(Object item_p) {
        if (item_p instanceof DecompositionItem) {
            DecompositionItem item = (DecompositionItem)item_p;
            DecompositionComponent component = item.getParentComponent();
            if (component.isReusedComponent()) {
                return false;
            }
            return this._decompModel.detachInterface(component, item);
        }
        if (item_p instanceof DecompositionItemService) {
            DecompositionItemService itemSce = (DecompositionItemService)item_p;
            DecompositionItem itemItf = itemSce.getParentDecompositionItem();
            if (!itemItf.isInternal()) {
                return false;
            }
            return this._decompModel.detachService(itemItf, itemSce);
        }
        return false;
    }

    public void refreshItems() {
        this.getSourceViewer().refresh(true);
        this.getTargetViewer().refresh(true);
        this.getSourceViewer().setSelection(null, true);
        this.getTargetViewer().setSelection(null, true);
        this.getSourceViewer().getTree().notifyListeners(13, new Event());
    }

    public TreeViewer getSourceViewer() {
        return this._sourceViewer;
    }

    public void setSourceViewer(TreeViewer viewer_p) {
        this._sourceViewer = viewer_p;
    }

    public LocalSelectionTransfer getSourceTransfer() {
        return this._sourceTransfer;
    }

    public void setSourceTransfer(LocalSelectionTransfer sourceTransfer_p) {
        this._sourceTransfer = sourceTransfer_p;
    }

    public DecompositionModel getDecompModel() {
        return this._decompModel;
    }

    public TreeViewer getTargetViewer() {
        return this._targetViewer;
    }

    public void setTargetViewer(TreeViewer targetViewer_p) {
        this._targetViewer = targetViewer_p;
    }

    public LocalSelectionTransfer getTargetTransfer() {
        return this._targetTransfer;
    }

    public void setTargetTransfer(LocalSelectionTransfer targetTransfer_p) {
        this._targetTransfer = targetTransfer_p;
    }

    class LCDragSourceListener
    implements DragSourceListener {
        private Tree _dragSourceTree;
        private LCDropTargetAdapter _dropTargetAdapter;

        public LCDragSourceListener(Tree sourceTree_p) {
            this._dragSourceTree = sourceTree_p;
        }

        public void dragStart(DragSourceEvent event) {
            Object treeID = this._dragSourceTree.getData("TREEID");
            if (treeID.equals("SOURCE_TREE")) {
                boolean bl = event.doit = !DecompositionDragAndDrop.this.getSourceViewer().getSelection().isEmpty();
                if (event.doit) {
                    Object data = ((ITreeSelection)DecompositionDragAndDrop.this.getSourceViewer().getSelection()).getFirstElement();
                    DecompositionDragAndDrop.this.getSourceTransfer().setSelection(DecompositionDragAndDrop.this.getSourceViewer().getSelection());
                    event.data = data;
                    currentElement = data;
                    this._dropTargetAdapter.setSourceTree(this._dragSourceTree);
                }
            } else if (treeID.equals("TARGET_TREE")) {
                boolean bl = event.doit = !DecompositionDragAndDrop.this.getTargetViewer().getSelection().isEmpty();
                if (event.doit) {
                    Object data = ((ITreeSelection)DecompositionDragAndDrop.this.getTargetViewer().getSelection()).getFirstElement();
                    DecompositionDragAndDrop.this.getTargetTransfer().setSelection(DecompositionDragAndDrop.this.getTargetViewer().getSelection());
                    event.data = data;
                    currentElement = data;
                    this._dropTargetAdapter.setSourceTree(this._dragSourceTree);
                }
            }
        }

        public void dragFinished(DragSourceEvent event) {
            this._dropTargetAdapter.setSourceTree(null);
            event.data = null;
            currentElement = null;
            DecompositionDragAndDrop.this.refreshItems();
        }

        public void dragSetData(DragSourceEvent event) {
            if (event.doit) {
                Object treeID = this._dragSourceTree.getData("TREEID");
                if (treeID.equals("SOURCE_TREE")) {
                    Object data = ((ITreeSelection)DecompositionDragAndDrop.this.getSourceViewer().getSelection()).getFirstElement();
                    DecompositionDragAndDrop.this.getSourceTransfer().setSelection(DecompositionDragAndDrop.this.getSourceViewer().getSelection());
                    event.data = data;
                    currentElement = data;
                    this._dropTargetAdapter.setSourceTree(this._dragSourceTree);
                } else if (treeID.equals("TARGET_TREE")) {
                    Object data = ((ITreeSelection)DecompositionDragAndDrop.this.getTargetViewer().getSelection()).getFirstElement();
                    DecompositionDragAndDrop.this.getTargetTransfer().setSelection(DecompositionDragAndDrop.this.getTargetViewer().getSelection());
                    event.data = data;
                    currentElement = data;
                    this._dropTargetAdapter.setSourceTree(this._dragSourceTree);
                }
            }
        }

        public LCDropTargetAdapter getDropTargetAdapter() {
            return this._dropTargetAdapter;
        }

        public void setDropTargetAdapter(LCDropTargetAdapter dropTargetAdapter_p) {
            this._dropTargetAdapter = dropTargetAdapter_p;
        }
    }

    class LCDropTargetAdapter
    extends DropTargetAdapter {
        private Tree _sourceTree;

        public void dragEnter(DropTargetEvent event) {
            DecompositionDragAndDrop.this.dropTargetValidate(event, this.getSourceTree());
        }

        public void dragOver(DropTargetEvent event) {
            DecompositionDragAndDrop.this.dropTargetValidate(event, this.getSourceTree());
            event.feedback |= 0x18;
        }

        public void drop(DropTargetEvent event) {
            TreeItem item;
            if (DecompositionDragAndDrop.this.dropTargetValidate(event, this.getSourceTree()) && (item = (TreeItem)event.item) != null) {
                ITreeSelection selection = (ITreeSelection)event.data;
                Object data = selection.getFirstElement();
                if (DecompositionDragAndDrop.this.getDecompModel().isDragAllowed(data)) {
                    Object treeID = item.getParent().getData("TREEID");
                    if (treeID.equals("SOURCE_TREE")) {
                        if (!DecompositionDragAndDrop.this.getTargetViewer().getSelection().isEmpty()) {
                            List list = selection.toList();
                            for (Object element : list) {
                                if (DecompositionDragAndDrop.this.handleDetach(element)) continue;
                            }
                            DecompositionDragAndDrop.this.refreshItems();
                        }
                    } else if (treeID.equals("TARGET_TREE") && DecompositionDragAndDrop.this.getDecompModel().isDropPossible(item.getData(), data) && DecompositionDragAndDrop.this.handleAttach(item.getData(), data)) {
                        DecompositionDragAndDrop.this.refreshItems();
                    }
                }
            }
            this.setSourceTree(null);
        }

        public Tree getSourceTree() {
            return this._sourceTree;
        }

        public void setSourceTree(Tree sourceTree_p) {
            this._sourceTree = sourceTree_p;
        }
    }
}

