/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.query.IQuery;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.cybersecurity.model.CybersecurityConfiguration;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.SecurityNeeds;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.ThreatApplication;
import org.polarsys.capella.cybersecurity.model.ThreatInvolvement;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.kitalpha.emde.model.ElementExtension;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class CybersecurityQueries {
    public static SecurityNeeds getSecurityNeeds(ExtensibleElement e) {
        for (ElementExtension ee : e.getOwnedExtensions()) {
            if (!(ee instanceof SecurityNeeds)) continue;
            return (SecurityNeeds)ee;
        }
        return null;
    }

    public static Stream<PrimaryAsset> getThreatenedPrimaryAssets(Threat threat) {
        return threat.getOwnedThreatApplications().stream().map(ThreatApplication::getAsset).filter(Objects::nonNull);
    }

    public static Stream<AbstractFunctionalBlock> getThreatenedComponents(Threat threat) {
        return CybersecurityQueries.getThreatenedPrimaryAssets(threat).flatMap(pa -> pa.getOwnedMembers().stream()).flatMap(pam -> {
            if (pam.getMember() instanceof AbstractFunction) {
                return ((AbstractFunction)pam.getMember()).getAllocationBlocks().stream();
            }
            return Stream.empty();
        });
    }

    public static Stream<Component> getInvolvedComponents(Threat threat) {
        return threat.getOwnedThreatInvolvements().stream().map(ThreatInvolvement::getComponent);
    }

    public static Stream<Component> getInvolvedThreatSources(Threat threat) {
        return CybersecurityQueries.getInvolvedComponents(threat).filter(c -> CybersecurityQueries.isThreatSource(c));
    }

    public static Stream<Component> getInvolvedActors(Threat threat) {
        return CybersecurityQueries.getInvolvedComponents(threat).filter(c -> !CybersecurityQueries.isThreatSource(c) && c.isActor());
    }

    public static Stream<Component> getInvolvedEntities(Threat threat) {
        return CybersecurityQueries.getInvolvedComponents(threat).filter(c -> !CybersecurityQueries.isThreatSource(c) && c instanceof Entity && !c.isActor());
    }

    public static Stream<Component> getInvolvedActors(PrimaryAsset asset) {
        return CybersecurityQueries.getThreatsOf(asset).flatMap(CybersecurityQueries::getInvolvedActors);
    }

    public static Stream<Component> getInvolvedThreatSources(PrimaryAsset asset) {
        return CybersecurityQueries.getThreatsOf(asset).flatMap(CybersecurityQueries::getInvolvedThreatSources);
    }

    public static boolean isThreatSource(Component c) {
        for (ElementExtension e : c.getOwnedExtensions()) {
            if (!(e instanceof TrustBoundaryStorage)) continue;
            return ((TrustBoundaryStorage)e).isThreatSource();
        }
        return false;
    }

    public static boolean isTrusted(Component c) {
        if (c != null) {
            for (ElementExtension e : c.getOwnedExtensions()) {
                if (!(e instanceof TrustBoundaryStorage)) continue;
                return ((TrustBoundaryStorage)e).isTrusted();
            }
        }
        return true;
    }

    public static boolean isTrustBoundary(FunctionalExchange fe) {
        AbstractFunction sf = CybersecurityQueries.getSourceFunction(fe);
        AbstractFunction tf = CybersecurityQueries.getTargetFunction(fe);
        return CybersecurityQueries.isTrusted(sf) ^ CybersecurityQueries.isTrusted(tf);
    }

    public static boolean isTrustBoundary(ComponentExchange ce) {
        Component source = ComponentExchangeExt.getSourceComponent((ComponentExchange)ce);
        Component target = ComponentExchangeExt.getTargetComponent((ComponentExchange)ce);
        boolean areTrustedAllocatedFE = CybersecurityQueries.areTrustBoundaryFE((EList<FunctionalExchange>)ce.getAllocatedFunctionalExchanges());
        return areTrustedAllocatedFE || CybersecurityQueries.isTrusted(source) ^ CybersecurityQueries.isTrusted(target);
    }

    public static boolean isTrustBoundary(PhysicalLink pl) {
        EObject source = pl.getSourcePhysicalPort().eContainer();
        EObject target = pl.getTargetPhysicalPort().eContainer();
        if (!(source instanceof Component) || !(target instanceof Component)) {
            return false;
        }
        boolean areTrustedAllocatedCE = CybersecurityQueries.areTrustBoundaryCE((EList<ComponentExchange>)pl.getAllocatedComponentExchanges());
        return areTrustedAllocatedCE || CybersecurityQueries.isTrusted((Component)source) ^ CybersecurityQueries.isTrusted((Component)target);
    }

    public static boolean areTrustBoundaryFE(EList<FunctionalExchange> allocatedFE) {
        for (FunctionalExchange fe : allocatedFE) {
            if (!CybersecurityQueries.isTrustBoundary(fe)) continue;
            return true;
        }
        return false;
    }

    public static boolean areTrustBoundaryCE(EList<ComponentExchange> allocatedCE) {
        for (ComponentExchange ce : allocatedCE) {
            if (!CybersecurityQueries.isTrustBoundary(ce)) continue;
            return true;
        }
        return false;
    }

    public static Stream<Threat> getThreatsOf(PrimaryAsset pa) {
        return EObjectExt.getReferencers((EObject)pa, (EReference)CybersecurityPackage.Literals.THREAT_APPLICATION__ASSET).stream().map(s -> ((ThreatApplication)s).getThreatObj()).filter(Objects::nonNull).distinct();
    }

    public static boolean isTrusted(AbstractFunction f) {
        for (AbstractFunctionalBlock b : f.getAllocationBlocks()) {
            TrustBoundaryStorage tbs = CybersecurityQueries.getTrustBoundaryStorage((ExtensibleElement)b);
            if (tbs == null) continue;
            return tbs.isTrusted();
        }
        return true;
    }

    public static boolean isTrusted(ExtensibleElement e) {
        TrustBoundaryStorage tbs = CybersecurityQueries.getTrustBoundaryStorage(e);
        if (tbs != null) {
            return tbs.isTrusted();
        }
        return true;
    }

    public static TrustBoundaryStorage getTrustBoundaryStorage(ExtensibleElement element) {
        if (element instanceof Part) {
            element = ((Part)element).getType();
        }
        if (element != null) {
            for (ElementExtension ext : element.getOwnedExtensions()) {
                if (!(ext instanceof TrustBoundaryStorage)) continue;
                return (TrustBoundaryStorage)ext;
            }
        }
        return null;
    }

    public static Stream<Threat> getInvolvingThreats(Component c) {
        return EObjectExt.getReferencers((EObject)c, (EReference)CybersecurityPackage.Literals.THREAT_INVOLVEMENT__COMPONENT).stream().map(s -> ((ThreatInvolvement)s).getThreatObj()).filter(Objects::nonNull);
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(FunctionalPrimaryAsset fpa) {
        return fpa.getFunctions().stream().flatMap(af -> af.getAllocationBlocks().stream());
    }

    public static Stream<ExchangeItem> getExchangeItems(AbstractFunction function) {
        for (ExtensibleElement e : function.getOwnedExtensions()) {
            if (!(e instanceof FunctionStorage)) continue;
            return ((FunctionStorage)e).getExchangedItems().stream();
        }
        return Stream.empty();
    }

    public static Stream<PrimaryAsset> getEnterprisePrimaryAssets(PrimaryAsset asset) {
        return EObjectExt.getReferencers((EObject)asset, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> ((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<FunctionalPrimaryAsset> getFunctionalPrimaryAssets(AbstractFunction af) {
        return EObjectExt.getReferencers((EObject)af, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> (FunctionalPrimaryAsset)((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<FunctionalPrimaryAsset> getFunctionalPrimaryAssets(FunctionalChain fc) {
        return EObjectExt.getReferencers((EObject)fc, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> (FunctionalPrimaryAsset)((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)CybersecurityPackage.Literals.PRIMARY_ASSET_MEMBER__MEMBER).stream().map(s -> (InformationPrimaryAsset)((PrimaryAssetMember)s).getAsset());
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(AbstractFunction af) {
        return CybersecurityQueries.getExchangeItems(af).flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei)).distinct();
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(FunctionalExchange fe) {
        return fe.getExchangedItems().stream().flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei));
    }

    public static Stream<AbstractFunctionalBlock> getTrustBoundaryBlocks(FunctionalExchange fe) {
        ArrayList result = new ArrayList();
        AbstractFunction sf = CybersecurityQueries.getSourceFunction(fe);
        AbstractFunction tf = CybersecurityQueries.getTargetFunction(fe);
        if (CybersecurityQueries.isTrusted(sf)) {
            result.addAll(sf.getAllocationBlocks());
        }
        if (CybersecurityQueries.isTrusted(tf)) {
            result.addAll(tf.getAllocationBlocks());
        }
        return result.stream();
    }

    public static AbstractFunction getSourceFunction(FunctionalExchange fe) {
        if (BlockArchitectureExt.getRootBlockArchitecture((EObject)fe) instanceof OperationalAnalysis) {
            return (AbstractFunction)fe.getSource();
        }
        return (AbstractFunction)fe.getSourceFunctionOutputPort().eContainer();
    }

    public static AbstractFunction getTargetFunction(FunctionalExchange fe) {
        if (BlockArchitectureExt.getRootBlockArchitecture((EObject)fe) instanceof OperationalAnalysis) {
            return (AbstractFunction)fe.getTarget();
        }
        return (AbstractFunction)fe.getTargetFunctionInputPort().eContainer();
    }

    public static Stream<FunctionalPrimaryAsset> getFunctionalPrimaryAssets(Component c) {
        return c.getAllocatedFunctions().stream().flatMap(af -> CybersecurityQueries.getFunctionalPrimaryAssets(af)).distinct();
    }

    public static Stream<FunctionalPrimaryAsset> getComputedFunctionalPrimaryAssets(AbstractFunction af) {
        return af.getInvolvingFunctionalChains().stream().flatMap(fc -> CybersecurityQueries.getFunctionalPrimaryAssets(fc)).distinct();
    }

    public static Stream<FunctionalPrimaryAsset> getComputedFunctionalPrimaryAssets(FunctionalExchange fe) {
        List result = fe.getInvolvingFunctionalChains().stream().flatMap(fc -> CybersecurityQueries.getFunctionalPrimaryAssets(fc)).distinct().collect(Collectors.toList());
        result.addAll(CybersecurityQueries.getFunctionalPrimaryAssets(CybersecurityQueries.getTargetFunction(fe)).collect(Collectors.toList()));
        result.addAll(CybersecurityQueries.getFunctionalPrimaryAssets(CybersecurityQueries.getSourceFunction(fe)).collect(Collectors.toList()));
        return result.stream().distinct();
    }

    public static Stream<InformationPrimaryAsset> getInformationPrimaryAssets(Component c) {
        return c.getAllocatedFunctions().stream().flatMap(af -> CybersecurityQueries.getExchangeItems(af)).flatMap(ei -> CybersecurityQueries.getInformationPrimaryAssets(ei)).distinct();
    }

    public static Stream<Threat> getThreateningThreats(Component c) {
        return Stream.concat(CybersecurityQueries.getFunctionalPrimaryAssets(c).flatMap(fpa -> CybersecurityQueries.getThreatsOf(fpa)), CybersecurityQueries.getInformationPrimaryAssets(c).flatMap(ipa -> CybersecurityQueries.getThreatsOf(ipa))).distinct();
    }

    public static Stream<Component> getUsedActors(Component c) {
        return c.getOwnedExtensions().stream().filter(ext -> ext instanceof ThreatSourceUse).map(trb -> ((ThreatSourceUse)trb).getUsed()).filter(Objects::nonNull).distinct();
    }

    public static Stream<Component> getUsedByThreatSource(Component c) {
        return EObjectExt.getReferencers((EObject)c, (EReference)CybersecurityPackage.Literals.THREAT_SOURCE_USE__USED).stream().map(s -> ((ThreatSourceUse)s).getThreatSource()).filter(Objects::nonNull).distinct();
    }

    public static int getMaxSecurityNeedsValue(SecurityNeeds sn) {
        return sn == null ? 0 : IntStream.of(CybersecurityQueries.getConfidentialityIndex(sn), CybersecurityQueries.getIntegrityIndex(sn), CybersecurityQueries.getTraceabilityIndex(sn), CybersecurityQueries.getAvailabilityIndex(sn)).max().getAsInt();
    }

    public static String getDefaultSecurityNeedValue(EnumerationPropertyType type) {
        EnumerationPropertyLiteral literal = CybersecurityQueries.getLiteralOnIndex(type, 0);
        return literal != null ? literal.getName() : null;
    }

    public static String getConfidentialityValue(SecurityNeeds sn, Project project) {
        return sn != null && sn.getConfidentialityValue() != null ? sn.getConfidentialityValue().getName() : CybersecurityQueries.getDefaultSecurityNeedValue(CybersecurityQueries.getConfidentialityPropertyType(project));
    }

    public static String getIntegrityValue(SecurityNeeds sn, Project project) {
        return sn != null && sn.getIntegrityValue() != null ? sn.getIntegrityValue().getName() : CybersecurityQueries.getDefaultSecurityNeedValue(CybersecurityQueries.getIntegrityPropertyType(project));
    }

    public static String getTraceabilityValue(SecurityNeeds sn, Project project) {
        return sn != null && sn.getTraceabilityValue() != null ? sn.getTraceabilityValue().getName() : CybersecurityQueries.getDefaultSecurityNeedValue(CybersecurityQueries.getTraceabilityPropertyType(project));
    }

    public static String getAvailabilityValue(SecurityNeeds sn, Project project) {
        return sn != null && sn.getAvailabilityValue() != null ? sn.getAvailabilityValue().getName() : CybersecurityQueries.getDefaultSecurityNeedValue(CybersecurityQueries.getAvailabilityPropertyType(project));
    }

    public static int getConfidentialityIndex(SecurityNeeds sn) {
        return sn == null || sn.getConfidentialityValue() == null ? 0 : CybersecurityQueries.getIndexOfLiteral(sn.getConfidentialityValue());
    }

    public static int getIntegrityIndex(SecurityNeeds sn) {
        return sn == null || sn.getIntegrityValue() == null ? 0 : CybersecurityQueries.getIndexOfLiteral(sn.getIntegrityValue());
    }

    public static int getAvailabilityIndex(SecurityNeeds sn) {
        return sn == null || sn.getAvailabilityValue() == null ? 0 : CybersecurityQueries.getIndexOfLiteral(sn.getAvailabilityValue());
    }

    public static int getTraceabilityIndex(SecurityNeeds sn) {
        return sn == null || sn.getTraceabilityValue() == null ? 0 : CybersecurityQueries.getIndexOfLiteral(sn.getTraceabilityValue());
    }

    public static void setConfidentialityFromIndex(SecurityNeeds sn, int index, EnumerationPropertyType type) {
        EnumerationPropertyLiteral newValue;
        if (type != null && sn != null && (newValue = CybersecurityQueries.getLiteralOnIndex(type, index)) != null) {
            sn.setConfidentialityValue(newValue);
        }
    }

    public static void setIntegrityFromIndex(SecurityNeeds sn, int index, EnumerationPropertyType type) {
        EnumerationPropertyLiteral newValue;
        if (type != null && sn != null && (newValue = CybersecurityQueries.getLiteralOnIndex(type, index)) != null) {
            sn.setIntegrityValue(newValue);
        }
    }

    public static void setAvailabilityFromIndex(SecurityNeeds sn, int index, EnumerationPropertyType type) {
        EnumerationPropertyLiteral newValue;
        if (type != null && sn != null && (newValue = CybersecurityQueries.getLiteralOnIndex(type, index)) != null) {
            sn.setAvailabilityValue(newValue);
        }
    }

    public static void setTraceabilityFromIndex(SecurityNeeds sn, int index, EnumerationPropertyType type) {
        EnumerationPropertyLiteral newValue;
        if (type != null && sn != null && (newValue = CybersecurityQueries.getLiteralOnIndex(type, index)) != null) {
            sn.setTraceabilityValue(newValue);
        }
    }

    public static void setThreatKindFromIndex(Threat threat, int index, EnumerationPropertyType type) {
        EnumerationPropertyLiteral newValue;
        if (type != null && threat != null && (newValue = CybersecurityQueries.getLiteralOnIndex(type, index)) != null) {
            threat.setKind(newValue);
        }
    }

    private static int getIndexOfLiteral(EnumerationPropertyLiteral property) {
        EnumerationPropertyType type = (EnumerationPropertyType)property.eContainer();
        return type == null ? 0 : type.getOwnedLiterals().indexOf((Object)property);
    }

    private static EnumerationPropertyLiteral getLiteralOnIndex(EnumerationPropertyType type, int index) {
        return index >= 0 && type != null && index < type.getOwnedLiterals().size() ? (EnumerationPropertyLiteral)type.getOwnedLiterals().get(index) : null;
    }

    public static Stream<FunctionalExchange> getAllocatingFunctionalExchanges(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS).stream().map(s -> (FunctionalExchange)s);
    }

    public static Stream<AbstractFunction> getAllocatingFunctions(ExchangeItem ei) {
        return EObjectExt.getReferencers((EObject)ei, (EReference)CybersecurityPackage.Literals.FUNCTION_STORAGE__EXCHANGED_ITEMS).stream().map(s -> (AbstractFunction)s.eContainer());
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(InformationPrimaryAsset pa) {
        return pa.getExchangeItems().stream().flatMap(ei -> CybersecurityQueries.getSupportingComponents(ei)).distinct();
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(ExchangeItem ei) {
        return Stream.concat(CybersecurityQueries.getAllocatingFunctions(ei).flatMap(af -> af.getAllocationBlocks().stream()), CybersecurityQueries.getAllocatingFunctionalExchanges(ei).flatMap(fe -> Stream.of(CybersecurityQueries.getSourceFunction(fe), CybersecurityQueries.getTargetFunction(fe))).flatMap(af -> af.getAllocationBlocks().stream())).distinct();
    }

    public static Stream<AbstractFunctionalBlock> getSupportingComponents(FunctionalExchange fe) {
        return fe.getExchangedItems().stream().flatMap(ei -> CybersecurityQueries.getSupportingComponents(ei)).distinct();
    }

    public static Stream<ExchangeItem> getExchangeItems(ComponentExchange ce) {
        return ce.getAllocatedFunctionalExchanges().stream().flatMap(fe -> fe.getExchangedItems().stream()).distinct();
    }

    public static SecurityNeeds reduceSecurityNeeds(SecurityNeeds result, SecurityNeeds a) {
        EnumerationPropertyType typeA = CybersecurityQueries.getAvailabilityPropertyType(a) != null ? CybersecurityQueries.getAvailabilityPropertyType(a) : CybersecurityQueries.getAvailabilityPropertyType(result);
        EnumerationPropertyType typeC = CybersecurityQueries.getConfidentialityPropertyType(a) != null ? CybersecurityQueries.getConfidentialityPropertyType(a) : CybersecurityQueries.getConfidentialityPropertyType(result);
        EnumerationPropertyType typeI = CybersecurityQueries.getIntegrityPropertyType(a) != null ? CybersecurityQueries.getIntegrityPropertyType(a) : CybersecurityQueries.getIntegrityPropertyType(result);
        EnumerationPropertyType typeT = CybersecurityQueries.getTraceabilityPropertyType(a) != null ? CybersecurityQueries.getTraceabilityPropertyType(a) : CybersecurityQueries.getTraceabilityPropertyType(result);
        CybersecurityQueries.setAvailabilityFromIndex(result, Math.max(CybersecurityQueries.getAvailabilityIndex(result), CybersecurityQueries.getAvailabilityIndex(a)), typeA);
        CybersecurityQueries.setConfidentialityFromIndex(result, Math.max(CybersecurityQueries.getConfidentialityIndex(result), CybersecurityQueries.getConfidentialityIndex(a)), typeC);
        CybersecurityQueries.setIntegrityFromIndex(result, Math.max(CybersecurityQueries.getIntegrityIndex(result), CybersecurityQueries.getIntegrityIndex(a)), typeI);
        CybersecurityQueries.setTraceabilityFromIndex(result, Math.max(CybersecurityQueries.getTraceabilityIndex(result), CybersecurityQueries.getTraceabilityIndex(a)), typeT);
        return result;
    }

    public static CybersecurityConfiguration getCybersecurityConfiguration(Project project) {
        Optional<ElementExtension> result;
        if (project != null && (result = project.getOwnedExtensions().stream().filter(x -> x instanceof CybersecurityConfiguration).findFirst()).isPresent()) {
            return (CybersecurityConfiguration)result.get();
        }
        return null;
    }

    public static EnumerationPropertyType getConfidentialityPropertyType(SecurityNeeds sn) {
        return sn.getConfidentialityValue() != null && sn.getConfidentialityValue().eContainer() instanceof EnumerationPropertyType ? (EnumerationPropertyType)sn.getConfidentialityValue().eContainer() : null;
    }

    public static EnumerationPropertyType getIntegrityPropertyType(SecurityNeeds sn) {
        return sn.getIntegrityValue() != null && sn.getIntegrityValue().eContainer() instanceof EnumerationPropertyType ? (EnumerationPropertyType)sn.getIntegrityValue().eContainer() : null;
    }

    public static EnumerationPropertyType getTraceabilityPropertyType(SecurityNeeds sn) {
        return sn.getTraceabilityValue() != null && sn.getTraceabilityValue().eContainer() instanceof EnumerationPropertyType ? (EnumerationPropertyType)sn.getTraceabilityValue().eContainer() : null;
    }

    public static EnumerationPropertyType getAvailabilityPropertyType(SecurityNeeds sn) {
        return sn.getAvailabilityValue() != null && sn.getAvailabilityValue().eContainer() instanceof EnumerationPropertyType ? (EnumerationPropertyType)sn.getAvailabilityValue().eContainer() : null;
    }

    public static EnumerationPropertyType getConfidentialityPropertyType(Project project) {
        CybersecurityConfiguration config = CybersecurityQueries.getCybersecurityConfiguration(project);
        if (config != null) {
            return config.getConfidentiality();
        }
        return null;
    }

    public static EnumerationPropertyType getIntegrityPropertyType(Project project) {
        CybersecurityConfiguration config = CybersecurityQueries.getCybersecurityConfiguration(project);
        if (config != null) {
            return config.getIntegrity();
        }
        return null;
    }

    public static EnumerationPropertyType getTraceabilityPropertyType(Project project) {
        CybersecurityConfiguration config = CybersecurityQueries.getCybersecurityConfiguration(project);
        if (config != null) {
            return config.getTraceability();
        }
        return null;
    }

    public static EnumerationPropertyType getAvailabilityPropertyType(Project project) {
        CybersecurityConfiguration config = CybersecurityQueries.getCybersecurityConfiguration(project);
        if (config != null) {
            return config.getAvailability();
        }
        return null;
    }

    public static EnumerationPropertyType getThreatKindPropertyType(Project project) {
        CybersecurityConfiguration config = CybersecurityQueries.getCybersecurityConfiguration(project);
        if (config != null) {
            return config.getThreatKind();
        }
        return null;
    }

    public static int getConfidentialitySize(Project project) {
        EnumerationPropertyType type = CybersecurityQueries.getConfidentialityPropertyType(project);
        return type == null ? 0 : type.getOwnedLiterals().size();
    }

    public static int getIntegritySize(Project project) {
        EnumerationPropertyType type = CybersecurityQueries.getIntegrityPropertyType(project);
        return type == null ? 0 : type.getOwnedLiterals().size();
    }

    public static int getAvailabilitySize(Project project) {
        EnumerationPropertyType type = CybersecurityQueries.getAvailabilityPropertyType(project);
        return type == null ? 0 : type.getOwnedLiterals().size();
    }

    public static int getTraceabilitySize(Project project) {
        EnumerationPropertyType type = CybersecurityQueries.getTraceabilityPropertyType(project);
        return type == null ? 0 : type.getOwnedLiterals().size();
    }

    public static class AbstractFunction__ComputedFunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return CybersecurityQueries.getComputedFunctionalPrimaryAssets((AbstractFunction)object).collect(Collectors.toList());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class AbstractFunction__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getExchangeItems((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class AbstractFunction__FunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getFunctionalPrimaryAssets((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class AbstractFunction__InformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((AbstractFunction)object).collect(Collectors.toList());
        }
    }

    public static class Activity__ComputedOperationalPrimaryAssets
    extends AbstractFunction__ComputedFunctionalPrimaryAssets {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class ComponentExchange__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getExchangeItems((ComponentExchange)object).collect(Collectors.toList());
        }
    }

    public static class ComponentExchange__InformationPrimaryAsset
    implements IQuery {
        public List<Object> compute(Object object) {
            return ((ComponentExchange)object).getAllocatedFunctionalExchanges().stream().flatMap(fe -> CybersecurityQueries.getInformationPrimaryAssets(fe)).collect(Collectors.toList());
        }
    }

    public static class ComponentExchange__TrustBoundary
    implements IQuery {
        public List<Object> compute(Object object) {
            return Collections.singletonList(CybersecurityQueries.isTrustBoundary((ComponentExchange)object));
        }
    }

    public static class Component__InvolvingThreats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvingThreats((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__MaxCIAT
    implements IQuery {
        public List<Object> compute(Object object) {
            if (object instanceof Component && !((Component)object).getAllocatedFunctions().isEmpty()) {
                Component component = (Component)object;
                Stream<SecurityNeeds> fsn = component.getAllocatedFunctions().stream().flatMap(af -> af.getOwnedExtensions().stream()).filter(SecurityNeeds.class::isInstance).map(SecurityNeeds.class::cast);
                Stream<SecurityNeeds> esn = component.getAllocatedFunctions().stream().flatMap(fct -> CybersecurityQueries.getExchangeItems(fct)).flatMap(af -> af.getOwnedExtensions().stream()).filter(SecurityNeeds.class::isInstance).map(SecurityNeeds.class::cast);
                SecurityNeeds max = Stream.concat(fsn, esn).reduce(CybersecurityFactory.eINSTANCE.createSecurityNeeds(), CybersecurityQueries::reduceSecurityNeeds);
                Session session = SessionManager.INSTANCE.getSession((EObject)component);
                Project project = SessionHelper.getCapellaProject((Session)session);
                return Arrays.asList("Confidentiality: " + CybersecurityQueries.getConfidentialityValue(max, project), "Integrity: " + CybersecurityQueries.getIntegrityValue(max, project), "Availability: " + CybersecurityQueries.getAvailabilityValue(max, project), "Traceability: " + CybersecurityQueries.getTraceabilityValue(max, project));
            }
            return new ArrayList<Object>();
        }
    }

    public static class Component__SupportedFunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getFunctionalPrimaryAssets((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__SupportedInformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__ThreateningThreatSources
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreateningThreats((Component)object).flatMap(t -> CybersecurityQueries.getInvolvedThreatSources(t)).collect(Collectors.toList());
        }
    }

    public static class Component__ThreateningThreats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreateningThreats((Component)object).collect(Collectors.toList());
        }
    }

    public static class Component__TrustBoundaries
    implements IQuery {
        public List<Object> compute(Object object) {
            Component c = (Component)object;
            Stream<ComponentExchange> tbCEs = ComponentExt.getAllRelatedComponentExchange((Component)c).stream().filter(ce -> CybersecurityQueries.isTrustBoundary(ce));
            Stream<FunctionalExchange> tbFEs = ComponentExt.getRelatedFunctionalExchanges((Component)c).stream().filter(fe -> CybersecurityQueries.isTrustBoundary(fe));
            Stream<FunctionalExchange> ownTBFEs = c.getAllocatedFunctions().stream().flatMap(af -> Stream.concat(af.getIncoming().stream(), af.getOutgoing().stream())).distinct().filter(FunctionalExchange.class::isInstance).map(FunctionalExchange.class::cast).filter(fe -> CybersecurityQueries.isTrustBoundary(fe));
            return Stream.concat(tbCEs, Stream.concat(tbFEs, ownTBFEs)).collect(Collectors.toList());
        }
    }

    public static class EnterprisePrimaryAsset__PrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (object instanceof EnterprisePrimaryAsset) {
                result.addAll((Collection<Object>)((EnterprisePrimaryAsset)object).getPrimaryAssets());
            }
            return result;
        }
    }

    public static class ExchangeItem__PrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((ExchangeItem)object).collect(Collectors.toList());
        }
    }

    public static class ExchangeItem__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((ExchangeItem)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalChain__FunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return CybersecurityQueries.getFunctionalPrimaryAssets((FunctionalChain)object).collect(Collectors.toList());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class FunctionalExchange__ComputedFunctionalPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return CybersecurityQueries.getComputedFunctionalPrimaryAssets((FunctionalExchange)object).collect(Collectors.toList());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class FunctionalExchange__InformationPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInformationPrimaryAssets((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalExchange__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalExchange__TrustBoundaries
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getTrustBoundaryBlocks((FunctionalExchange)object).collect(Collectors.toList());
        }
    }

    public static class FunctionalPrimaryAsset__FunctionalChains
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return new ArrayList<FunctionalChain>((Collection<FunctionalChain>)((FunctionalPrimaryAsset)object).getFunctionalChains());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class FunctionalPrimaryAsset__FunctionalExchanges
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return ((FunctionalPrimaryAsset)object).getFunctions().stream().flatMap(af -> Stream.concat(af.getIncoming().stream(), af.getOutgoing().stream())).distinct().collect(Collectors.toList());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class FunctionalPrimaryAsset__Functions
    implements IQuery {
        public List<Object> compute(Object object) {
            if (this.showCategory(object)) {
                return new ArrayList<AbstractFunction>((Collection<AbstractFunction>)((FunctionalPrimaryAsset)object).getFunctions());
            }
            return new ArrayList<Object>();
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class FunctionalPrimaryAsset__Interactions
    extends FunctionalPrimaryAsset__FunctionalExchanges {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class FunctionalPrimaryAsset__OperationalActivities
    extends FunctionalPrimaryAsset__Functions {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class FunctionalPrimaryAsset__OperationalProcesses
    extends FunctionalPrimaryAsset__FunctionalChains {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class FunctionalPrimaryAsset__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((FunctionalPrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class InformationPrimaryAsset__ExchangeItems
    implements IQuery {
        public List<Object> compute(Object object) {
            return new ArrayList<ExchangeItem>((Collection<ExchangeItem>)((InformationPrimaryAsset)object).getExchangeItems());
        }
    }

    public static class InformationPrimaryAsset__SupportingComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getSupportingComponents((InformationPrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class Interaction__ComputedOperationalPrimaryAssets
    extends FunctionalExchange__ComputedFunctionalPrimaryAssets {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class OperationalProcess__FunctionalPrimaryAssets
    extends FunctionalChain__FunctionalPrimaryAssets {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class PrimaryAsset__ReferencingEnterprisePrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getEnterprisePrimaryAssets((PrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class PrimaryAsset__Threats
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatsOf((PrimaryAsset)object).collect(Collectors.toList());
        }
    }

    public static class ThreatSource__ThreatenedComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvingThreats((Component)object).flatMap(t -> CybersecurityQueries.getThreatenedComponents(t)).distinct().collect(Collectors.toList());
        }
    }

    public static class Threat__InvolvedActors
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvedActors((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__InvolvedEntities
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvedEntities((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__InvolvedThreatSources
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getInvolvedThreatSources((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__OwnedFunctionalChains
    implements IQuery {
        public List<Object> compute(Object object) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (this.showCategory(object)) {
                result.addAll((Collection<Object>)((AbstractCapability)object).getOwnedFunctionalChains());
            }
            return result;
        }

        public boolean showCategory(Object object) {
            return !(BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis);
        }
    }

    public static class Threat__OwnedOperationalProcesses
    extends Threat__OwnedFunctionalChains {
        @Override
        public boolean showCategory(Object object) {
            return BlockArchitectureExt.getRootBlockArchitecture((EObject)((EObject)object)) instanceof OperationalAnalysis;
        }
    }

    public static class Threat__ThreatenedComponents
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatenedComponents((Threat)object).collect(Collectors.toList());
        }
    }

    public static class Threat__ThreatenedPrimaryAssets
    implements IQuery {
        public List<Object> compute(Object object) {
            return CybersecurityQueries.getThreatenedPrimaryAssets((Threat)object).collect(Collectors.toList());
        }
    }
}

