/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.MultipleSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.CybersecurityPackage;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.ui.CommonHelpers;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorage;
import org.polarsys.capella.cybersecurity.ui.ElementExtensionStorageImpl;
import org.polarsys.capella.cybersecurity.ui.properties.fields.SemanticCheckboxGroup;
import org.polarsys.capella.cybersecurity.ui.properties.sections.Messages;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class FunctionCybersecuritySection
extends AbstractSection {
    private FunctionStorage elementExtension;
    private SemanticCheckboxGroup checkboxes;
    private MultipleSemanticField exchangeItems;

    public boolean select(Object eObject) {
        EObject eObjectToTest = super.selection(eObject);
        if (eObjectToTest == null) {
            return false;
        }
        if (eObjectToTest instanceof FunctionStorage) {
            return true;
        }
        EObject children = this.getFunctionStorageObject(eObjectToTest);
        return children != null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject newEObject = super.setInputSelection(part, selection);
        if (newEObject != null && !(newEObject instanceof FunctionStorage)) {
            newEObject = this.getFunctionStorageObject(newEObject);
        }
        if (newEObject != null) {
            this.loadData(newEObject);
        }
    }

    private EObject getFunctionStorageObject(EObject parent) {
        if (parent == null) {
            return null;
        }
        if (!CommonHelpers.isViewpointActive(parent, "org.polarsys.capella.cybersecurity")) {
            return null;
        }
        Object result = null;
        for (EObject iEObject : parent.eContents()) {
            if (!(iEObject instanceof FunctionStorage)) continue;
            FunctionStorage functionStorage = result = result == null ? (FunctionStorage)iEObject : null;
            if (result == null) break;
        }
        if (result == null && CommonHelpers.canBeExtendedBy(parent, CybersecurityPackage.Literals.FUNCTION_STORAGE)) {
            for (ElementExtensionStorageImpl adapter : parent.eAdapters()) {
                if (!(adapter instanceof ElementExtensionStorage) || !(((ElementExtensionStorage)adapter).getExtension() instanceof FunctionStorage)) continue;
                result = ((ElementExtensionStorage)adapter).getExtension();
            }
            if (result == null) {
                ElementExtensionStorageImpl adapter;
                adapter = new ElementExtensionStorageImpl((ExtensibleElement)parent, CybersecurityPackage.Literals.FUNCTION_STORAGE);
                result = adapter.getExtension();
            }
        }
        return result;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.checkboxes = new SemanticCheckboxGroup((Composite)this.getCheckGroup(), this.getWidgetFactory(), CybersecurityPackage.Literals.FUNCTION_STORAGE__DATA_STORAGE, CybersecurityPackage.Literals.FUNCTION_STORAGE__REMANENT_DATA);
        this.exchangeItems = new MultipleSemanticField((Composite)this.getReferencesGroup(), Messages.FunctionCybersecuritySection_0, this.getWidgetFactory(), (IMultipleSemanticFieldController)new AbstractMultipleSemanticFieldController(){

            public List<EObject> readOpenValues(EObject semanticElement, EStructuralFeature semanticFeature, boolean availableElements) {
                ArrayList<EObject> result = new ArrayList<EObject>(0);
                IBusinessQuery query = this.getReadOpenValuesQuery(semanticElement);
                if (query != null) {
                    List capellaElements = null;
                    if (availableElements) {
                        EObject queryElement = semanticElement.eContainer();
                        if (queryElement == null) {
                            ElementExtensionStorage st = (ElementExtensionStorage)EcoreUtil.getExistingAdapter((Notifier)semanticElement, ElementExtensionStorage.class);
                            queryElement = st.getExtendedElement();
                        }
                        capellaElements = query.getAvailableElements(queryElement);
                    } else {
                        capellaElements = query.getCurrentElements(semanticElement, false);
                    }
                    result.addAll(capellaElements);
                }
                return result;
            }

            protected IBusinessQuery getReadOpenValuesQuery(EObject semanticElement) {
                return BusinessQueriesProvider.getInstance().getContribution(semanticElement.eClass(), (EStructuralFeature)CybersecurityPackage.Literals.FUNCTION_STORAGE__EXCHANGED_ITEMS);
            }
        });
        this.exchangeItems.setDisplayedInWizard(this.isDisplayedInWizard());
    }

    public void loadData(EObject object) {
        super.loadData(object);
        this.checkboxes.loadData(object);
        this.exchangeItems.loadData(object, (EStructuralFeature)CybersecurityPackage.Literals.FUNCTION_STORAGE__EXCHANGED_ITEMS);
        this.elementExtension = (FunctionStorage)object;
    }

    public List<AbstractSemanticField> getSemanticFields() {
        ArrayList<AbstractSemanticField> abstractSemanticFields = new ArrayList<AbstractSemanticField>();
        abstractSemanticFields.add((AbstractSemanticField)this.checkboxes);
        abstractSemanticFields.add((AbstractSemanticField)this.exchangeItems);
        return abstractSemanticFields;
    }

    public void refresh() {
        if (this.elementExtension != null) {
            this.loadData((EObject)this.elementExtension);
        }
    }
}

