/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task.adapter;

import com.google.common.base.Preconditions;
import java.io.File;
import org.eclipse.buildship.core.internal.util.file.FileUtils;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;

final class ProjectNodeAdapter
implements IPropertySource {
    private static final String PROPERTY_NAME = "project.name";
    private static final String PROPERTY_DESCRIPTION = "project.description";
    private static final String PROPERTY_PATH = "project.path";
    private static final String PROPERTY_TYPE = "project.type";
    private static final String PROPERTY_PROJECT_DIRECTORY = "project.directory";
    private static final String PROPERTY_BUILD_OUTPUT_DIRECTORY = "project.buildOutputDirectory";
    private static final String PROPERTY_BUILD_SCRIPT_LOCATION = "project.buildScriptLocation";
    private final GradleProject project;

    ProjectNodeAdapter(ProjectNode projectNode) {
        this.project = ((ProjectNode)Preconditions.checkNotNull((Object)projectNode)).getGradleProject();
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROPERTY_NAME, "Name"), new PropertyDescriptor((Object)PROPERTY_DESCRIPTION, "Description"), new PropertyDescriptor((Object)PROPERTY_PATH, "Path"), new PropertyDescriptor((Object)PROPERTY_TYPE, "Type"), new PropertyDescriptor((Object)PROPERTY_PROJECT_DIRECTORY, "Directory"), new PropertyDescriptor((Object)PROPERTY_BUILD_OUTPUT_DIRECTORY, "Build Output Directory"), new PropertyDescriptor((Object)PROPERTY_BUILD_SCRIPT_LOCATION, "Build Script Location")};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_NAME)) {
            return this.project.getName();
        }
        if (id.equals(PROPERTY_DESCRIPTION)) {
            return this.project.getDescription();
        }
        if (id.equals(PROPERTY_PATH)) {
            return this.project.getPath();
        }
        if (id.equals(PROPERTY_TYPE)) {
            return "Gradle Project";
        }
        if (id.equals(PROPERTY_PROJECT_DIRECTORY)) {
            File projectDir = this.project.getProjectDirectory();
            return FileUtils.getAbsolutePath((File)projectDir).or((Object)"unknown");
        }
        if (id.equals(PROPERTY_BUILD_OUTPUT_DIRECTORY)) {
            File buildDir = this.project.getBuildDirectory();
            return buildDir == null ? "unknown" : buildDir;
        }
        if (id.equals(PROPERTY_BUILD_SCRIPT_LOCATION)) {
            GradleScript script = this.project.getBuildScript();
            return script == null ? "unknown" : FileUtils.getAbsolutePath((File)script.getSourceFile()).or((Object)"none");
        }
        throw new IllegalStateException("Unsupported project property: " + String.valueOf(id));
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

